<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Register New Student</h5>
    </div>

    <div class="card-body">
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <strong>Please fix the following errors:</strong>
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('students.store')); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            
            <h6 class="text-muted mb-3">Personal Information</h6>

            <div class="row mb-3">
                <div class="col-md-12">
                    <label>Full Name *</label>
                    <input type="text" name="name" value="<?php echo e(old('name')); ?>" class="form-control" required>
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- <div class="col-md-6">
                    <label>Admission Number *</label>
                    <input type="text" name="admission_no" value="<?php echo e(old('admission_no')); ?>" class="form-control">
                    <?php $__errorArgs = ['admission_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div> -->
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Date of Birth *</label>
                    <input type="date" name="dob" value="<?php echo e(old('dob')); ?>" class="form-control" required>
                    <?php $__errorArgs = ['dob'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="col-md-6">
                    <label>Gender *</label>
                    <select name="gender" class="form-select" required>
                        <option value="">Select</option>
                        <option value="Male" <?php echo e(old('gender')=='Male'?'selected':''); ?>>Male</option>
                        <option value="Female" <?php echo e(old('gender')=='Female'?'selected':''); ?>>Female</option>
                        <!-- <option value="Other" <?php echo e(old('gender')=='Other'?'selected':''); ?>>Other</option> -->
                    </select>
                    <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Nationality *</label>
                    <input type="text" name="nationality" value="<?php echo e(old('nationality','Indian')); ?>" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label>Mother Tongue *</label>
                    <input type="text" name="mother_tongue" value="<?php echo e(old('mother_tongue')); ?>" class="form-control" required>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Category *</label>
                    <select name="category" class="form-select" required>
                        <option value="GEN">GEN</option>
                        <option value="OBC">OBC</option>
                        <option value="SC">SC</option>
                        <option value="ST">ST</option>
                    </select>
                    <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="col-md-6">
                    <label>Caste *</label>
                    <input type="text" name="cast" value="<?php echo e(old('cast')); ?>" class="form-control" required>
                </div>
            </div>

            
            <h6 class="text-muted mt-4">Address Information</h6>

            <div class="mb-3">
                <label>Permanent Address *</label>
                <textarea name="address" class="form-control" required><?php echo e(old('address')); ?></textarea>
                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-3">
                <label>Local Address *</label>
                <textarea name="local_address" class="form-control" required><?php echo e(old('local_address')); ?></textarea>
                <?php $__errorArgs = ['local_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            
            <div class="row mb-3">
                <div class="col-md-4">
                    <input type="checkbox" name="belongs_to_minority_group" value="1" <?php echo e(old('belongs_to_minority_group')?'checked':''); ?>>
                    Minority
                </div>
                <div class="col-md-4">
                    <input type="checkbox" name="is_disability_ph" value="1" <?php echo e(old('is_disability_ph')?'checked':''); ?>>
                    Disability
                </div>
                <div class="col-md-4">
                    <input type="checkbox" name="is_transport_required" value="1" <?php echo e(old('is_transport_required')?'checked':''); ?>>
                    Transport
                </div>
            </div>

            
            <h6 class="text-muted mt-4">Class Details</h6>

            <div class="row mb-3">

                
                <div class="col-md-3">
                    <label class="form-label">Class *</label>
                    <select name="class_id" id="class_id"
                            class="form-select <?php $__errorArgs = ['class_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                        <option value="">Select Class</option>
                        <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($class->id); ?>"
                                <?php echo e(old('class_id') == $class->id ? 'selected' : ''); ?>>
                                <?php echo e($class->class_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['class_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                
                <div class="col-md-3">
                    <label class="form-label">Section *</label>
                    <select name="section_id" id="section_id"
                            class="form-select <?php $__errorArgs = ['section_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                        <option value="">Select Section</option>
                    </select>
                    <?php $__errorArgs = ['section_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>


                
                <div class="col-md-3">
                    <label class="form-label">Session *</label>
                    <select name="session_id"
                            class="form-select <?php $__errorArgs = ['session_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                        <option value="">Select Session</option>
                        <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($sec->id); ?>" <?php echo e(old('session_id') == ($sec->id) ? 'selected' : ''); ?>><?php echo e($sec->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['session_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="col-md-3">
                    <label class="form-label">Financial Year *</label>
                    <select name="financial_year_id" id="financial_year"
                            class="form-select <?php $__errorArgs = ['financial_year_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                        <?php $__currentLoopData = $academic_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($year->id); ?>"
                                <?php echo e(old('financial_year','2025-2026') ==
                                ($year->label) ? 'selected' : ''); ?>>
                                <?php echo e($year->label); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['financial_year_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

            </div>


            
            <h6 class="text-muted mt-4">Parent / Guardian</h6>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Father Name *</label>
                    <input type="text" name="father_name" value="<?php echo e(old('father_name')); ?>" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label>Mother Name *</label>
                    <input type="text" name="mother_name" value="<?php echo e(old('mother_name')); ?>" class="form-control" required>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Father Qualification</label>
                    <input type="text" name="father_qualification" value="<?php echo e(old('father_qualification')); ?>" class="form-control">
                </div>
                <div class="col-md-6">
                    <label>Mother Qualification</label>
                    <input type="text" name="mother_qualification" value="<?php echo e(old('mother_qualification')); ?>" class="form-control">
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Father Occupation *</label>
                    <input type="text" name="father_occupation" value="<?php echo e(old('father_occupation')); ?>" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label>Mother Occupation *</label>
                    <input type="text" name="mother_occupation" value="<?php echo e(old('mother_occupation')); ?>" class="form-control" required>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Father Phone *</label>
                    <input type="tel" pattern="[0-9]{10}" maxlength="10" name="father_phone" value="<?php echo e(old('father_phone')); ?>" class="form-control" placeholder="10 digit mobile number" required>
                </div>
                <div class="col-md-6">
                    <label>Mother Phone *</label>
                    <input type="tel" pattern="[0-9]{10}" maxlength="10" name="mother_phone" value="<?php echo e(old('mother_phone')); ?>" class="form-control" placeholder="10 digit mobile number" required>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Guardian Name *</label>
                    <input type="text" name="guardian_name" value="<?php echo e(old('guardian_name')); ?>" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label>Guardian Phone *</label>
                    <input type="tel" pattern="[0-9]{10}" maxlength="10" name="guardian_phone" value="<?php echo e(old('guardian_phone')); ?>" class="form-control" placeholder="10 digit mobile number" required>
                </div>
            </div>

            <div class="row mb-3">
                <label>Guardian Address *</label>
                <textarea name="guardian_address" class="form-control" required><?php echo e(old('guardian_address')); ?></textarea>
            </div>

            
            <div class="row mb-4">
                <div class="col-md-6">
                    <label>Profile Image</label>
                    <input type="file" name="profile_image" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label>DOB Proof</label>
                    <input type="file" name="dob_photo_copy" class="form-control" required>
                </div>
            </div>

            <div class="d-flex gap-2 justify-content-end mt-3">
                <button class="btn btn-primary btn-sm">Register Student</button>

                <a href="<?php echo e(route('students.index')); ?>" class="btn btn-secondary btn-sm">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\school\resources\views/students/register.blade.php ENDPATH**/ ?>