<div class="card">
    <div class="card-header bg-light">
        <div class="row align-items-center">
            <div class="col">
                <h5 class="mb-0">All Students</h5>
            </div>
            <div class="col-md-10">
                <form method="GET" action="{{ route('students.index') }}" class="row g-2">

                    {{-- Class --}}
                    <div class="col-md-4">
                        <select name="class_id"
                                id="class_id"
                                class="form-select form-select-sm">
                            <option value="">All Classes</option>
                            @foreach($classes as $class)
                                <option value="{{ $class->id }}"
                                    {{ request('class_id') == $class->id ? 'selected' : '' }}>
                                    {{ $class->class_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Section --}}
                    <div class="col-md-4">
                        <select name="section_id"
                                id="section_id"
                                class="form-select form-select-sm"
                                {{ request('class_id') ? '' : 'disabled' }}>
                            <option value="">All Sections</option>

                            {{-- When page reloads --}}
                            @if(request('class_id'))
                                @foreach($sections as $section)
                                    <option value="{{ $section->id }}"
                                        {{ request('section_id') == $section->id ? 'selected' : '' }}>
                                        {{ $section->section_name }}
                                    </option>
                                @endforeach
                            @endif
                        </select>
                    </div>

                    {{-- Search --}}
                    <div class="col-md-4">
                        <input type="search"
                            name="q"
                            value="{{ request('q') }}"
                            class="form-control form-control-sm"
                            placeholder="Search by name or admission #">
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Admission #</th>
                        <th>Name</th>
                        <th>Class</th>
                        <th>Section</th>
                        <th>Roll No</th>
                        <th>DOB</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($students as $student)
                    <tr>
                        <td>#{{$student->admission_no}}</td>
                        <td>{{$student->name}}</td>
                        <td>{{$student->activeClass->class->class_name}}</td>
                        <td>{{$student->activeClass->section->section_name}}</td>
                        <td>{{$student->activeClass->roll_no}}</td>
                        <td>{{$student->dob}}</td>
                        <td>
                            <div class="form-check form-switch">
                                <input
                                    class="form-check-input student-status"
                                    type="checkbox"
                                    id="status_{{ $student->id }}"
                                    data-id="{{ $student->id }}"
                                    data-url="{{ route('students.update', $student->id) }}"
                                    {{ $student->status ? 'checked' : '' }}
                                >
                            </div>
                        </td>
                        <td>
                            <a href="{{ route('students.edit', $student->id) }}" class="btn btn-sm btn-outline-secondary">Edit</a>
                            <a href="{{ route('students.show', $student->id) }}" class="btn btn-sm btn-outline-primary">View</a>
                        </td>
                    </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted">
                                No student found for the current academic year
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        {{-- Pagination --}}
        <div class="mt-3">
            {{ $students->links() }}
        </div>
    </div>
</div>