@extends('layouts.app')

@section('title', 'Students')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('students.index') }}">Students</a></li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
    @php
        // Get current active class detail
        $currentClass = $student->classDetails->first();
    @endphp

    <div id="students-page" class="page-content">
        <h1 class="mb-4">Student Management</h1>
        <div class="card">
            <div class="card-header bg-light">
                <h5 class="mb-0">Edit Student</h5>
            </div>

            <div class="card-body">

                {{-- GLOBAL ERRORS --}}
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <strong>Please fix the following errors:</strong>
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form method="POST" action="{{ route('students.update', $student->id) }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    {{-- ================= PERSONAL INFORMATION ================= --}}
                    <h6 class="text-muted mb-3">Personal Information</h6>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label>Full Name *</label>
                            <input type="text" name="name" value="{{ old('name', $student->name) }}"
                                class="form-control @error('name') is-invalid @enderror">
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Date of Birth</label>
                            <input type="date" name="dob" value="{{ old('dob', $student->dob) }}"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Gender</label>
                            <select name="gender" class="form-select">
                                <option value="">Select</option>
                                @foreach (['Male', 'Female', 'Other'] as $g)
                                    <option value="{{ $g }}"
                                        {{ old('gender', $student->gender) == $g ? 'selected' : '' }}>
                                        {{ $g }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Nationality</label>
                            <input type="text" name="nationality" value="{{ old('nationality', $student->nationality) }}"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Tongue</label>
                            <input type="text" name="mother_tongue"
                                value="{{ old('mother_tongue', $student->mother_tongue) }}" class="form-control">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Category *</label>
                            <select name="category" class="form-select">
                                @foreach (['GEN', 'OBC', 'SC', 'ST'] as $cat)
                                    <option value="{{ $cat }}"
                                        {{ old('category', $student->category) == $cat ? 'selected' : '' }}>
                                        {{ $cat }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label>Caste *</label>
                            <input type="text" name="cast" value="{{ old('cast', $student->cast) }}"
                                class="form-control">
                        </div>
                    </div>

                    {{-- ================= ADDRESS ================= --}}
                    <h6 class="text-muted mt-4 mb-3">Address</h6>

                    <div class="mb-3">
                        <label>Permanent Address *</label>
                        <textarea name="address" rows="2" class="form-control">{{ old('address', $student->address) }}</textarea>
                    </div>

                    <div class="mb-3">
                        <label>Local Address *</label>
                        <textarea name="local_address" rows="2" class="form-control">{{ old('local_address', $student->local_address) }}</textarea>
                    </div>

                    {{-- ================= FLAGS ================= --}}
                    <h6 class="text-muted mt-4 mb-3">Additional Information</h6>

                    <div class="row mb-3">
                        <div class="col-md-4 form-check">
                            <input type="checkbox" name="belongs_to_minority_group" value="1" class="form-check-input"
                                {{ old('belongs_to_minority_group', $student->belongs_to_minority_group) ? 'checked' : '' }}>
                            <label class="form-check-label">Minority</label>
                        </div>

                        <div class="col-md-4 form-check">
                            <input type="checkbox" name="is_disability_ph" value="1" class="form-check-input"
                                {{ old('is_disability_ph', $student->is_disability_ph) ? 'checked' : '' }}>
                            <label class="form-check-label">PH</label>
                        </div>

                        <div class="col-md-4 form-check">
                            <input type="checkbox" name="is_transport_required" value="1" class="form-check-input"
                                {{ old('is_transport_required', $student->is_transport_required) ? 'checked' : '' }}>
                            <label class="form-check-label">Transport</label>
                        </div>
                    </div>

                    {{-- ================= CLASS ASSIGNMENT ================= --}}
                    <h6 class="text-muted mt-4 mb-3">Class Assignment</h6>

                    <div class="row mb-3">
                        <div class="col-md-3">
                            <label>Class *</label>
                            <select name="class_id" class="form-select">
                                @foreach ($classes as $class)
                                    <option value="{{ $class->id }}"
                                        {{ old('class_id', $currentClass?->class_id) == $class->id ? 'selected' : '' }}>
                                        {{ $class->class_name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('class_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label>Section *</label>
                            <select name="section_id" class="form-select">
                                @foreach ($classes as $class)
                                    @if ($class->id == old('class_id', $currentClass?->class_id))
                                        @foreach ($class->sections as $section)
                                            <option value="{{ $section->id }}"
                                                {{ old('section_id', $currentClass?->section_id) == $section->id ? 'selected' : '' }}>
                                                {{ $section->section_name }}
                                            </option>
                                        @endforeach
                                    @endif
                                @endforeach
                            </select>
                            @error('section_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label>Session *</label>
                            <select name="session_id" class="form-select @error('session_id') is-invalid @enderror" required>
                                <option value="">Select Session</option>
                                @foreach($sessions as $sec)
                                    <option value="{{$sec->id}}" {{ old('session_id',$currentClass?->session_id) == ($sec->id) ? 'selected' : '' }}>{{ $sec->name }}</option>
                                @endforeach
                            </select>
                            @error('session_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label>Academic Year *</label>
                            <select name="financial_year_id" class="form-select">
                                @foreach ($academicYears as $year)
                                    <option value="{{ $year->id }}"
                                        {{ old('financial_year_id', $currentClass?->finalcial_year_id) == $year->id ? 'selected' : '' }}>
                                        {{ $year->label }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- ================= PARENT / GUARDIAN ================= --}}
                    <h6 class="text-muted mt-4 mb-3">Parent / Guardian Details</h6>

                    {{-- Names --}}
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Name *</label>
                            <input type="text" name="father_name"
                                value="{{ old('father_name', $student->parent->father_name) }}"
                                class="form-control @error('father_name') is-invalid @enderror">
                            @error('father_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label>Mother Name *</label>
                            <input type="text" name="mother_name"
                                value="{{ old('mother_name', $student->parent->mother_name) }}"
                                class="form-control @error('mother_name') is-invalid @enderror">
                            @error('mother_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    {{-- Qualifications --}}
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Qualification</label>
                            <input type="text" name="father_qualification"
                                value="{{ old('father_qualification', $student->parent->father_qualification) }}"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Qualification</label>
                            <input type="text" name="mother_qualification"
                                value="{{ old('mother_qualification', $student->parent->mother_qualification) }}"
                                class="form-control">
                        </div>
                    </div>

                    {{-- Occupation --}}
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Occupation *</label>
                            <input type="text" name="father_occupation"
                                value="{{ old('father_occupation', $student->parent->father_occupation) }}"
                                class="form-control @error('father_occupation') is-invalid @enderror">
                            @error('father_occupation')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label>Mother Occupation *</label>
                            <input type="text" name="mother_occupation"
                                value="{{ old('mother_occupation', $student->parent->mother_occupation) }}"
                                class="form-control @error('mother_occupation') is-invalid @enderror">
                            @error('mother_occupation')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    {{-- Phones --}}
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Phone *</label>
                            <input type="tel" name="father_phone" maxlength="10" pattern="[0-9]{10}"
                                value="{{ old('father_phone', $student->parent->father_phone) }}"
                                class="form-control @error('father_phone') is-invalid @enderror">
                            @error('father_phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label>Mother Phone *</label>
                            <input type="tel" name="mother_phone" maxlength="10" pattern="[0-9]{10}"
                                value="{{ old('mother_phone', $student->parent->mother_phone) }}"
                                class="form-control @error('mother_phone') is-invalid @enderror">
                            @error('mother_phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    {{-- IDs --}}
                    <!-- <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Voter ID</label>
                            <input type="text" name="father_voter_id"
                                value="{{ old('father_voter_id', $student->parent->father_voter_id) }}"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Voter ID</label>
                            <input type="text" name="mother_voter_id"
                                value="{{ old('mother_voter_id', $student->parent->mother_voter_id) }}"
                                class="form-control">
                        </div>
                    </div> -->

                    {{-- Guardian --}}
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Guardian Name</label>
                            <input type="text" name="guardian_name"
                                value="{{ old('guardian_name', $student->parent->guardian_name) }}" class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Guardian Phone</label>
                            <input type="tel" name="guardian_phone" maxlength="10" pattern="[0-9]{10}"
                                value="{{ old('guardian_phone', $student->parent->guardian_phone) }}"
                                class="form-control @error('guardian_phone') is-invalid @enderror">
                            @error('guardian_phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="mb-3">
                        <label>Guardian Address</label>
                        <textarea name="guardian_address" rows="2" class="form-control">{{ old('guardian_address', $student->parent->guardian_address) }}</textarea>
                    </div>

                    {{-- ================= DOCUMENTS ================= --}}
                    <h6 class="text-muted mt-4 mb-3">Documents</h6>

                    <div class="row mb-3">

                        {{-- PROFILE PHOTO --}}
                        <div class="col-md-6">
                            <label class="form-label">Profile Photo</label>

                            @if($student->profile_image)
                                <div class="mb-2">
                                    <img
                                        src="{{ asset('storage/'.$student->profile_image) }}"
                                        alt="Profile Photo"
                                        class="img-thumbnail"
                                        style="max-height:150px;">
                                </div>
                            @else
                                <p class="text-muted">No profile photo uploaded</p>
                            @endif

                            <input type="file" name="profile_image" class="form-control">
                            <small class="text-muted">Leave empty to keep existing photo</small>
                        </div>

                        {{-- DOB PROOF --}}
                        <div class="col-md-6">
                            <label class="form-label">DOB Proof</label>

                            @if($student->dob_photo_copy)
                                <div class="mb-2">
                                    @php
                                        $ext = pathinfo($student->dob_photo_copy, PATHINFO_EXTENSION);
                                    @endphp

                                    @if(in_array(strtolower($ext), ['jpg','jpeg','png','webp']))
                                        <img
                                            src="{{ asset('storage/'.$student->dob_photo_copy) }}"
                                            alt="DOB Proof"
                                            class="img-thumbnail"
                                            style="max-height:150px;">
                                    @else
                                        <a href="{{ asset('storage/'.$student->dob_photo_copy) }}"
                                        target="_blank"
                                        class="btn btn-sm btn-outline-primary">
                                            View / Download DOB Proof
                                        </a>
                                    @endif
                                </div>
                            @else
                                <p class="text-muted">No DOB proof uploaded</p>
                            @endif

                            <input type="file" name="dob_photo_copy" class="form-control">
                            <small class="text-muted">Leave empty to keep existing document</small>
                        </div>

                    </div>

                    <div class="d-flex gap-2 justify-content-end mt-3">
                        <button type="submit" class="btn btn-primary btn-sm">
                            Update Student
                        </button>

                        <a href="{{ route('students.index') }}" class="btn btn-secondary btn-sm">
                            Cancel
                        </a>
                    </div>

                </form>
            </div>
        </div>
    </div>
@endsection
