<?php $__env->startSection('content'); ?>
    <div class="intro-y col-span-12 lg:col-span-12 transection-details-view">
        <div class="intro-y box mt-8 shadow-lg rounded-2xl overflow-hidden">
            <div class="bg-gradient-to-r from-blue-600 to-indigo-600 p-5">
                <h2 class="font-semibold text-lg text-black">
                    Expense Transaction Details:
                </h2>
                <div class="w-full sm:w-auto  mt-4 sm:mt-0 mr-4" style="float: right">
                    <a href="<?php echo e(route('expense.print', $expense->expense_id)); ?>" target="_blank">
                        <button class="button text-white bg-theme-1 shadow-md">
                            Print Details
                        </button>
                    </a>
                </div>
            </div>

            <div class="p-8 bg-white">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-y-6 gap-x-10">
                    <?php if(isset($expense->organisation_id)): ?>
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Organisation Name:</p>
                            <p class="text-blue-600 font-semibold">
                                <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organisation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($organisation->organisation_id == $expense->organisation_id): ?>
                                        <?php echo e($organisation->organisation_name); ?>

                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </p>
                        </div>
                    <?php endif; ?>
                    <?php if(isset($expense->account_type_id)): ?>
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Account Type Name:</p>
                            <p class="text-blue-600 font-semibold">
                                <?php $__currentLoopData = $accountTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accountType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($accountType->account_type_id == $expense->account_type_id): ?>
                                        <?php echo e($accountType->account_type_Name); ?>

                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </p>
                        </div>
                    <?php endif; ?>
                    <?php if(isset($expense->expense_head)): ?>
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Expense Head Name:</p>
                            <p class="text-blue-600 font-semibold">
                                <?php $__currentLoopData = $expenseHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expenseHead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($expenseHead->expense_head_id == $expense->expense_head): ?>
                                        <?php echo e($expenseHead->expense_head_name); ?>

                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </p>
                        </div>
                    <?php endif; ?>
                    <?php if(isset($expense->receipt_no)): ?>
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Voucher / Receipt No. :</p>
                            <p class="text-blue-600 font-semibold">
                                <?php if(isset($expense->receipt_no)): ?>
                                    <?php echo e($expense->receipt_no ? $expense->receipt_no : ''); ?>

                                <?php endif; ?>
                            </p>
                        </div>
                    <?php endif; ?>
                    <?php if(@isset($expense->asset_id)): ?>
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Asset Name:</p>
                            <p class="text-blue-600 font-semibold">
                                <?php $__currentLoopData = $assets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($asset->asset_id == $expense->asset_id): ?>
                                        <?php echo e($asset->asset_name); ?>

                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </p>
                        </div>
                    <?php endif; ?>
                    <?php if(@isset($expense->liability_id)): ?>
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Liability Name:</p>
                            <p class="text-blue-600 font-semibold">
                                <?php $__currentLoopData = $liabilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $liability): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($liability->liability_id == $expense->liability_id): ?>
                                        <?php echo e($liability->liability_name); ?>

                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </p>
                        </div>
                    <?php endif; ?>
                    <?php if(@isset($expense->vendor_id)): ?>
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Vendor Name:</p>
                            <p class="text-blue-600 font-semibold">
                                <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($vendor->vendor_id == $expense->vendor_id): ?>
                                        <?php echo e($vendor->vendor_name); ?> - <?php echo e($vendor->vendor_type); ?>

                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </p>
                        </div>
                    <?php endif; ?>
                    <?php if(@isset($expense->staff_id)): ?>
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Staff Name:</p>
                            <p class="text-blue-600 font-semibold">
                                <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($vendor->vendor_id == $expense->staff_id): ?>
                                        <?php echo e($vendor->vendor_name); ?> - <?php echo e($vendor->vendor_type); ?>

                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </p>
                        </div>
                    <?php endif; ?>
                    <?php if(@isset($expense->financial_year_id)): ?>
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Accounting Year:</p>
                            <p class="text-blue-600 font-semibold">
                                <?php $__currentLoopData = $accounting_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accounting_year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($accounting_year->accounting_year_id == $expense->financial_year_id): ?>
                                        <?php echo e($accounting_year->accounting_year_financial); ?>

                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </p>
                        </div>
                    <?php endif; ?>
                    <?php if(@isset($expense->transaction_date)): ?>
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Date of Transaction:</p>
                            <p class="text-blue-600 font-semibold">
                                <?php echo e(\Carbon\Carbon::parse($expense->transaction_date)->format('d-m-Y')); ?>

                            </p>
                        </div>
                    <?php endif; ?>
                    <?php if(@isset($expense->transaction_reference)): ?>
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Transaction Reference No.:</p>
                            <p class="text-blue-600 font-semibold"><?php echo e($expense->transaction_reference); ?></p>
                        </div>
                    <?php endif; ?>
                    <?php if(@isset($expense->payment_type_id)): ?>
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Payment Type:</p>
                            <p class="text-blue-600 font-semibold"><?php echo e($expense->paymentType->name ?? '-'); ?></p>
                        </div>
                    <?php endif; ?>

                    
                    <?php if(@isset($expense->transaction_narration)): ?>
                        <div class="md:col-span-2 list-chart">
                            <p class="text-gray-600 font-medium">Transaction Narration:</p>
                            <p class="text-blue-600 font-semibold italic"><?php echo e($expense->transaction_narration ?? '—'); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
                <?php if(@isset($expense->transaction_amount)): ?>
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Transaction Amount:</p>
                        <p class="text-red-600 text-xl font-bold">
                            ₹ <?php echo e(number_format($expense->transaction_amount, 2)); ?>

                        </p>
                    </div>
                <?php endif; ?>
                <?php if(!empty($expense->file_path)): ?>
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Uploaded Files:</p>
                        <div class="flex gap-4 flex-wrap">
                            <?php $__currentLoopData = explode(',', $expense->file_path); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $file = trim($file);
                                    $extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                                ?>

                                <?php if($extension === 'pdf'): ?>
                                    <a href="<?php echo e(asset('storage/' . $file)); ?>" target="_blank"
                                        class="flex flex-col items-center justify-center w-32 h-32 bg-gray-100 border rounded shadow cursor-pointer">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-12 h-12 text-red-600"
                                            fill="currentColor" viewBox="0 0 24 24">
                                            <path
                                                d="M6 2a2 2 0 0 0-2 2v16c0
                                                                                                                                                                            1.1.9 2 2 2h12a2 2 0 0
                                                                                                                                                                            0 2-2V8l-6-6H6zm7 1.5L18.5
                                                                                                                                                                            9H13V3.5zM8 13h8v2H8v-2z" />
                                        </svg>
                                        <span class="text-sm text-gray-700">PDF File</span>
                                    </a>
                                <?php else: ?>
                                    <a href="<?php echo e(asset('storage/' . $file)); ?>" target="_blank">
                                        <img src="<?php echo e(asset('storage/' . $file)); ?>" alt="Uploaded Image"
                                            class="w-32 h-32 object-cover rounded shadow cursor-pointer">
                                    </a>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="mt-8 text-right">
                    <a href="<?php echo e(route('expense.index')); ?>"
                        class="inline-flex items-center px-5 py-2.5 rounded-lg bg-gray-600 text-white font-medium hover:bg-gray-700 transition duration-200">
                        ← Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravelproject\ramkrishna-sevashram-new\resources\views/auth/transactions/expense/detail.blade.php ENDPATH**/ ?>