<?php $__env->startSection('content'); ?>
    <div class="col-span-12 lg:col-span-12">
        <div class="flex justify-between mt-5">
            <h2 class="text-lg font-medium mr-auto">
                Account Brought Forward Amount
            </h2>

            <?php
                $menuId = \App\Models\Menu::where('route', 'capital.index')->value('id');
                $permissionService = app(\App\Services\PermissionService::class);
            ?>

            <?php if($permissionService->hasPermission($menuId, 'w')): ?>
                <?php if(@isset($recordExists) && !$recordExists > 0): ?>
                    <div class="w-full sm:w-auto flex mt-4 sm:mt-0 mr-2">
                        <a href="<?php echo e(route('capital.create')); ?>">
                            <button class="button text-white bg-theme-1 shadow-md">
                                Enter Previous Years Capital
                            </button>
                        </a>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
            <?php if($permissionService->hasPermission($menuId, 'x')): ?>
                <div class="w-full sm:w-auto flex mt-4 sm:mt-0 gap-4">
                    <a href="<?php echo e(route('capital.net.index')); ?>">
                        <button class="button text-white bg-theme-1 shadow-md">
                            Current Balance (Cash/Bank)
                        </button>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
    </div>
    <!-- BEGIN: HTML Table Data -->
    <div class="intro-y box p-5 mt-5">

        <?php if(session('success')): ?>
            <div class="rounded-md flex items-center px-5 py-4 mb-2 border border-theme-9 text-theme-9 dark:border-theme-9">
                <?php echo e(session('success')); ?>

            </div>
        <?php elseif(session('error')): ?>
            <div class="rounded-md flex items-center px-5 py-4 mb-2 border border-theme-6 text-theme-6 dark:border-theme-6">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <div class="flex flex-col sm:flex-row sm:items-end xl:items-start">
            <form class="xl:flex w-full" id="tabulator-html-filter-form">

                <div class="sm:flex items-center justify-between w-full">
                    <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center gap-2 flex-wrap">
                            <label for="page-size" class="form-label mb-0">Data Per Page</label>
                            <select id="page-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                                
                                <option value="10">10</option>
                                <option value="30">30</option>
                                <option value="50">50</option>
                                <option value="100">100</option>
                            </select>
                        </div>
                    </div>
                    &nbsp; &nbsp; &nbsp;
                    <div>
                        <input type="text" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border" id="search-string"
                            placeholder="Search...">
                    </div>

                </div>

            </form>
        </div>
        <div class="overflow-x-auto scrollbar-hidden">
            <div class="mt-5 table-report table-report--tabulator" id="account_brought_forward-table"></div>
        </div>

    </div>
    <!-- END: HTML Table Data -->

    <link href="<?php echo e(asset('build/assets/css/tabulator.min.css')); ?>" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tabulator/6.3.1/css/tabulator_materialize.min.css" rel="stylesheet">
    <script type="text/javascript" src="https://unpkg.com/tabulator-tables@6.3.1/dist/js/tabulator.min.js"></script>


    <script>
        var canRead = <?php echo json_encode($permissionService->hasPermission($menuId, 'r'), 512) ?>;
        var canWrite = <?php echo json_encode($permissionService->hasPermission($menuId, 'w'), 512) ?>;
        var canExecute = <?php echo json_encode($permissionService->hasPermission($menuId, 'x'), 512) ?>;



        var currentYearRange =
            "<?php echo e(\Carbon\Carbon::createFromDate(date('Y'), 4, 1)->format('d-m-Y') . ' to ' . \Carbon\Carbon::createFromDate(date('Y') + 1, 3, 31)->format('d-m-Y')); ?>";
        var table = new Tabulator("#account_brought_forward-table", {
            ajaxURL: "<?php echo e(route('capital.details')); ?>",
            ajaxParams: function() {
                return {
                    _token: document.querySelector('meta[name="csrf-token"]').getAttribute("content"),
                    search: document.querySelector("#search-string").value
                };
            },
            ajaxConfig: "POST",
            layout: "fitColumns",
            theme: "bootstrap5",
            paginationMode: "remote",
            pagination: true,
            paginationSize: 10,
            paginationSizeSelector: false,
            layout: "fitColumns",
            search: true,
            movableRows: true,
            movableColumns: true,
            // 🔹 Custom loader spinner
            ajaxLoaderLoading: `
                   <div style='display:inline-block; border:4px solid #333; border-radius:10px; background:#fff; font-weight:bold; font-size:16px; color:#000; padding:10px 20px;'>Loading Data</div>
                `,
            columnDefaults: {
                tooltip: true,
            },
            columns: [{
                    title: "SL",
                    hozAlign: "center",
                    formatter: function(cell, formatterParams, onRendered) {
                        let row = cell.getRow();
                        let data = row.getData();
                        let page = table.getPage();
                        let perPage = table.getPageSize();

                        if (!page) page = 0;
                        if (!perPage) perPage = 10;

                        return ((row.getPosition(true) + 1) + ((page - 1) * perPage) - 1);
                    },
                    maxWidth: 30
                },
                {
                    title: "Accounting Year",
                    field: "financial_year.accounting_year_financial",
                    hozAlign: "center",
                    headerSort: true,
                },
                {
                    title: "Date As On",
                    field: "dated_as_on",
                    hozAlign: "center",
                    headerSort: true,
                    // maxWidth: 400
                },
                {
                    title: "Cash In Hand (₹)",
                    field: "cash_in_hand",
                    hozAlign: "center",
                    headerSort: true,
                    // maxWidth: 400
                },
                {
                    title: "Cash At Bank (₹)",
                    field: "cash_at_bank",
                    hozAlign: "center",
                    headerSort: true,
                    // maxWidth: 400
                },
                {
                    title: "Action",
                    headerSort: false,
                    maxWidth: 620,
                    headerHozAlign: "center",
                    formatter: function() {

                        let html = `
                            <div class="flex justify-center items-center">
                              `;
                        if (canExecute) {
                            html += `
                              <a class="flex items-center mr-3" data-action="edit">
                                 <span  data-toggle="tooltip" data-original-title="Edit user">
                                   <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-check-square w-4 h-4 mr-1"><polyline points="9 11 12 14 22 4"></polyline><path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"></path></svg> 
                                </span>
                                 </a>
                                              `;
                        }

                        return html;
                    },
                    cellClick: function(e, cell) {
                        const rowData = cell.getRow().getData();
                        const actionEl = e.target.closest('[data-action]');
                        const action = actionEl ? actionEl.dataset.action : null;

                        if (action === "edit") {
                            console.log("Row Data:", rowData);
                            let encodedId = btoa(rowData.id);
                            window.location.href = "/capital/edit/" + encodedId;

                        }
                    }
                }
            ],
            rowFormatter: function(row) {
                const data = row.getData();
                if (data.is_current === 1) {
                    row.getElement().style.backgroundColor = "#1C3FAA";
                    row.getElement().style.color = "white";
                }
            },

            ajaxResponse: function(url, params, response) {
                return {
                    data: response.data,
                    last_page: response.last_page,
                    current_page: response.current_page,
                    total: response.total
                };
            }
        });

        document.getElementById("page-size").addEventListener("change", function() {
            table.setPageSize(Number(this.value));
        });
        document.getElementById("search-string").addEventListener("input", function() {
            table.setData();
        });
    </script>
    <style>
        #accounting-year-table {
            position: relative;
        }

        #accounting-year-table .tabulator-loader {
            position: absolute !important;
            inset: 0 !important;
            display: flex !important;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.7) !important;
            z-index: 9999 !important;
        }

        #accounting-year-table .tabulator-loader-msg {
            background: transparent !important;
            border: none !important;
            box-shadow: none !important;
            padding: 0 !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/download/public_html/resources/views/auth/capitals/index.blade.php ENDPATH**/ ?>