


<?php $__env->startSection('content'); ?>


<div class="intro-y listing-table col-span-12 lg:col-span-12">

    <!-- BEGIN: Select Options -->
    <div class="intro-y box mt-5">
        <!-- BEGIN: Horizontal Form -->
        <div class="intro-y box mt-5">
            <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                <h2 class="font-medium text-base mr-auto">
                    Members Yearly Record
                </h2>

            </div>
            

            <table class="member_donation_list">
                <thead>
                    <tr>
                        <th rowspan="2">Member Name</th>

                        <?php
                        // Check if yearly subscription exists in income heads
                        $yearlyIncomeHead = $incomeHeads->first(function ($h) {
                        $normalized = strtolower(str_replace(' ', '', trim($h->income_head_name)));
                        return $normalized === 'yearlysubscription';
                        });
                        $yearlyIncomeHeadId = $yearlyIncomeHead->income_head_id ?? null;
                        ?>

                        <?php if($yearlyIncomeHead): ?>
                        <th colspan="2">Yearly Subscription</th>
                        <?php endif; ?>

                        <?php $__currentLoopData = $incomeHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $normalizedHead = strtolower(str_replace(' ', '', trim($head->income_head_name)));
                        ?>

                        <?php if($normalizedHead !== 'yearlysubscription'): ?>
                        <th rowspan="2"><?php echo e(ucwords($head->income_head_name)); ?> (₹)</th>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <th rowspan="2">Total(₹)</th>
                    </tr>

                    <?php if($yearlyIncomeHead): ?>
                    <tr>
                        <th>Subscription Fee(₹)</th>
                        <th>Contingent Fee(₹)</th>
                    </tr>
                    <?php endif; ?>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $donationData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $donorId => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                    $incomes = $data['incomes'] ?? [];
                    $total = 0;
                    ?>
                    <tr>
                        <td><?php echo e($data['donor']->donor_name); ?></td>

                        
                        <?php if($yearlyIncomeHead): ?>
                        <?php
                        $yearlyTransactions = $incomes[$yearlyIncomeHeadId] ?? [];
                        $subscriptionFee = !empty($yearlyTransactions) ? 400 : '';
                        $contingentFee = !empty($yearlyTransactions) ? 100 : '';
                        if ($subscriptionFee) $total += $subscriptionFee + $contingentFee;
                        ?>
                        <td>
                            <?php if(!empty($yearlyTransactions)): ?>
                            <?php echo e($subscriptionFee); ?>

                            <?php $__currentLoopData = $yearlyTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tran): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            (<?php echo e($tran['date']); ?>)
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <button
                                class="add-subscription-btn bg-blue-500 hover:bg-green-600 text-white text-s px-2 py-1.5 rounded absolute bottom-1 right-1"
                                data-donor-id="<?php echo e($data['donor']->donor_id); ?>"
                                data-income-head-id="<?php echo e($yearlyIncomeHead->income_head_id ?? ''); ?>">
                                +
                            </button>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if(!empty($yearlyTransactions)): ?>
                            <?php echo e($contingentFee); ?>

                            <?php $__currentLoopData = $yearlyTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tran): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            (<?php echo e($tran['date']); ?>)
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </td>
                        <?php endif; ?>

                        
                        <?php $__currentLoopData = $incomeHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $headId = $head->income_head_id;
                        $normalizedHead = strtolower(str_replace(' ', '', trim($head->income_head_name)));
                        $transactions = $incomes[$headId] ?? [];
                        $headTotal = array_sum(array_column($transactions, 'amount'));
                        if ($normalizedHead !== 'yearlysubscription') {
                        $total += $headTotal;
                        }
                        ?>
                        <?php if($normalizedHead !== 'yearlysubscription'): ?>
                        <td>
                            <?php if(!empty($transactions)): ?>
                            <strong>Total: <?php echo e($headTotal); ?></strong><br>
                            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tran): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e($tran['amount']); ?> (<?php echo e($tran['date']); ?>)<br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <br>
                            <button class="add-donation-btn bg-green-500 hover:bg-green-600 text-white text-s px-2 py-1.5 rounded absolute bottom-1 right-1"
                                data-donor-id="<?php echo e($data['donor']->donor_id); ?>"
                                data-income-head-id="<?php echo e($headId); ?>">
                                +
                            </button>
                        </td>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <td><?php echo e($total); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>

            </table>



        </div>

        <!-- Subscription Modal -->
        <div id="subscriptionModal"
            style="display:none; position:fixed; inset:0; background: rgba(0,0,0,0.5); z-index:50; justify-content:center; align-items:center;">
            <div
                style="background:white; padding:20px; border-radius:8px; max-width:600px; margin:auto; position:relative;">
                <button id="closeModal"
                    style="position:absolute; top:10px; right:10px; font-size:20px; font-weight:bold;">&times;</button>
                <h2 style="font-weight:bold; margin-bottom:10px;">Add Subscription</h2>

                <form id="modalSubscriptionForm">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="donor_id" id="modal_donor_id">
                    <input type="hidden" name="organisation_id" id="modal_organisation_id">
                    <input type="hidden" name="account_type_id" id="modal_account_type_id">
                    <input type="hidden" name="income_head_id" id="modal_income_head_id">

                    <div style="margin-bottom:10px;">
                        <label>Money Receipt No.</label>
                        <input type="text" name="money_receipt_no" id="money_receipt_no"
                            style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;">
                    </div>
                    <div style="margin-bottom:10px;">
                        <label>Payment Type</label>
                        <select name="payment_type_id"
                            style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;" required>
                            <option value="">-- Select Payment Type --</option>
                            <?php $__currentLoopData = $paymentTypes->where('parent_id', null); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $children = $paymentTypes->where('parent_id', $parent->id); ?>
                            <?php if($children->isEmpty()): ?>
                            <option value="<?php echo e($parent->id); ?>"><?php echo e($parent->name); ?></option>
                            <?php else: ?>
                            <optgroup label="<?php echo e($parent->name); ?>">
                                <?php $__currentLoopData = $children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($child->id); ?>"><?php echo e($child->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </optgroup>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div style="margin-bottom:10px;">
                        <label>Transaction Amount</label>
                        <input type="text" name="transaction_amount" value="500"
                            style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;">
                    </div>
                    <div style="margin-bottom:10px;">
                        <label>Transaction Date</label>
                        <input type="date" name="transaction_date" value="<?php echo e(now()->toDateString()); ?>"
                            style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;">
                    </div>
                    <div style="margin-bottom:10px;">
                        <label>Transaction Narration</label>
                        <textarea name="transaction_narration" style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;"></textarea>
                    </div>

                    <div style="text-align:right;">
                        <button type="button" id="modalCloseBtn"
                            style="background:#ccc; padding:6px 12px; border:none; border-radius:4px; margin-right:5px;">Cancel</button>
                        <button type="submit"
                            style="background:#4CAF50; color:white; padding:6px 12px; border:none; border-radius:4px;">Save</button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Donation Modal -->
        <div id="donationModal"
            style="display:none; position:fixed; inset:0; background: rgba(0,0,0,0.5); z-index:50; justify-content:center; align-items:center;">
            <div class="bg-white rounded-lg shadow-lg w-1/3 p-6 relative">
                <button type="button" id="modalDonationCloseBtn"
                    class="absolute top-2 right-2 text-gray-600 hover:text-gray-900">
                    ✕
                </button>
                <h2 class="text-lg font-bold mb-4">Add Donation</h2>
                <form id="modalDonationForm">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="donor_id" id="donation_modal_donor_id">
                    <input type="hidden" name="income_head_id" id="donation_modal_income_head_id">

                    <div class="mb-3">
                        <label class="block text-sm font-medium">Amount</label>
                        <input type="number" name="amount" class="input border w-full" required>
                    </div>
                    <div style="margin-bottom:10px;">
                        <label>Payment Type</label>
                        <select name="payment_type_id"
                            style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;" required>
                            <option value="">-- Select Payment Type --</option>
                            <?php $__currentLoopData = $paymentTypes->where('parent_id', null); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $children = $paymentTypes->where('parent_id', $parent->id); ?>
                            <?php if($children->isEmpty()): ?>
                            <option value="<?php echo e($parent->id); ?>"><?php echo e($parent->name); ?></option>
                            <?php else: ?>
                            <optgroup label="<?php echo e($parent->name); ?>">
                                <?php $__currentLoopData = $children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($child->id); ?>"><?php echo e($child->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </optgroup>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="flex justify-end space-x-2">
                        <button type="button" id="closeDonationModal"
                            class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600">Cancel</button>
                        <button type="submit"
                            class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Save</button>
                    </div>
                </form>
            </div>
        </div>


    </div>
    <!-- END: Horizontal Form -->
</div>
<!-- END: Select Options -->
</div>


<script>
    const donors = <?php echo json_encode($donors, 15, 512) ?>;
    document.querySelectorAll('.add-subscription-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            let donorId = this.dataset.donorId;
            let incomeId = this.dataset.incomeHeadId;
            let donor = donors.find(d => d.donor_id == donorId);

            document.getElementById('modal_donor_id').value = donorId;
            // document.getElementById('modal_organisation_id').value = donor.organisation_id;
            // document.getElementById('modal_account_type_id').value = donor.account_type_id;
            document.getElementById('modal_income_head_id').value = incomeId;

            document.getElementById('subscriptionModal').style.display = 'flex';
        });
    });
    document.getElementById('closeModal').addEventListener('click', () => {
        document.getElementById('subscriptionModal').style.display = 'none';
    });
    document.getElementById('modalCloseBtn').addEventListener('click', () => {
        document.getElementById('subscriptionModal').style.display = 'none';
    });
    document.getElementById('modalSubscriptionForm').addEventListener('submit', function(e) {
        e.preventDefault();
        let formData = new FormData(this);

        fetch("<?php echo e(route('donor.subscription.store')); ?>", {
                method: 'POST',
                body: formData,
            })
            .then(res => res.json())
            .then(data => {
                alert('Subscription saved!');
                location.reload();
            })
            .catch(err => console.error(err));
    });

    document.addEventListener("DOMContentLoaded", function() {

        document.querySelectorAll('.add-donation-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                let donorId = this.dataset.donorId;
                let incomeId = this.dataset.incomeHeadId;

                document.getElementById('donation_modal_donor_id').value = donorId;
                document.getElementById('donation_modal_income_head_id').value = incomeId;

                document.getElementById('donationModal').style.display = 'flex';
            });
        });

        document.getElementById('closeDonationModal').addEventListener('click', () => {
            document.getElementById('donationModal').style.display = 'none';
        });
        document.getElementById('modalDonationCloseBtn').addEventListener('click', () => {
            document.getElementById('donationModal').style.display = 'none';
        });

        document.getElementById('modalDonationForm').addEventListener('submit', function(e) {
            e.preventDefault();
            let formData = new FormData(this);

            fetch("<?php echo e(route('donor.member.donation.list.submit')); ?>", {
                    method: 'POST',
                    body: formData,
                    headers: {
                        "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').content
                    }
                })
                .then(res => res.json())
                .then(data => {
                    alert('Donation saved!');
                    location.reload();
                })
                .catch(err => console.error(err));
        });

    });

    function cleanAmount(val) {
        val = val.replace(/[^0-9.]/g, "");

        let parts = val.split(".");
        if (parts.length > 2) {
            val = parts[0] + "." + parts.slice(1).join("");
        }
        if (/^0[0-9]/.test(val)) {
            val = val.replace(/^0+/, "");
        }

        if (val.startsWith("0.") || val === "0") {
            val = val.replace(/^0+/, "");
        }
        return val;
    }
    $("input[name='transaction_amount'], input[name='amount']").on("input", function() {
        this.value = cleanAmount(this.value);
    });
    $("#money_receipt_no").on("input", function() {
        let value = $(this).val();
        value = value.replace(/[^A-Za-z0-9]/g, "");
        if (value.length > 20) {
            value = value.substring(0, 20);
        }
        $(this).val(value);
        let errorDiv = $("#error-transaction-reference");
        if (value.length < 5) {
            errorDiv.text("Transaction reference must be at least 5 characters.");
        } else {
            errorDiv.text("");
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/ramakrishna-sevashram/resources/views/auth/donor/subscription/list.blade.php ENDPATH**/ ?>