<?php $__env->startSection('content'); ?>
    <div class="ledgers-page-sec bg-gray-100 col-span-12 lg:col-span-12">
        <div class="ledgers-page-wraper flex w-full bg-white shadow-md rounded-2xl overflow-hidden">
            <div class="w-full p-4">
                <div class="content-box">

                    <!-- Date Filter -->
                    <div class="flex justify-between items-center mb-4">

                        <div>
                            <h3 class="text-base font-medium text-black">
                                <u><?php echo e(ucfirst($donor->donor_name)); ?></u>
                            </h3>
                        </div>

                        

                    </div>

                    <div class="sngl-box">
                        <!-- Cash Payments -->
                        <div>
                            <h3 class="text-base font-medium mb-2 text-black mb-4">Transaction History</h3>
                            <?php
                                $totalPaid = 0;

                            ?>
                            <table class="w-full text-left border-collapse shadow-sm rounded-lg overflow-hidden mb-3">
                                <thead>
                                    <tr>
                                        <th class="p-3 text-left">Date</th>
                                        <th class="p-3 text-left">Income Head Name</th>
                                        <th class="p-3 text-left">Narration</th>
                                        <th class="p-3 text-right">Received Amount</th>
                                        
                                    </tr>
                                </thead>
                                <tbody id="cashTable" class="divide-y"></tbody>
                                <tfoot>
                                    <?php $__empty_1 = true; $__currentLoopData = $donorRecords; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php $totalPaid += $record->paid_amount; ?>
                                        <tr class="hover:bg-gray-50">
                                            <td class="p-3">
                                                <?php echo e(\Carbon\Carbon::parse($record->created_at)->format('d-m-Y')); ?></td>
                                            <td class="p-3">
                                                <?php echo e($record->income_head_name); ?></td>
                                            <td class="p-3">
                                                <?php echo e($record->transaction_narration); ?></td>

                                            <td class="p-3 text-right font-medium text-blue-600">
                                                ₹ <?php echo e(number_format($record->paid_amount, 2)); ?>

                                            </td>
                                            

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="5" class="p-3 text-center text-gray-500">No records found</td>
                                        </tr>
                                    <?php endif; ?>

                                </tfoot>
                            </table>
                        </div>


                        <!-- Grand Total -->
                        <div class="mt-4">
                            <table class="w-full text-left border-collapse shadow-sm rounded-lg overflow-hidden">
                                <tfoot>

                                    <tr class="bg-gray-200 font-bold">
                                        <td colspan="2" class="p-3 text-right">Grand Total</td>
                                        <td class="p-3 text-right text-black">
                                            ₹ <?php echo e(number_format($totalPaid, 2)); ?>

                                        </td>
                                        <td colspan="2"></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                    </div>
                    <div class="mt-6">
                        <button onclick="history.back()"
                            class="px-4 py-2 rounded-lg bg-gray-500 hover:bg-gray-600 text-white shadow text-sm transition">
                            ← Back
                        </button>
                    </div>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravelproject\ramkrishna-sevashram-new\resources\views/auth/ledgers/donor/detail.blade.php ENDPATH**/ ?>