<?php $__env->startSection('content'); ?>
    <div class="intro-y col-span-12 lg:col-span-12">

        <!-- BEGIN: Select Options -->
        <div class="intro-y box mt-5 income-head-top-sec">
            <h2 class="text-lg font-medium mr-auto">Heads </h2>
            <div class="w-full sm:w-auto flex mt-4 sm:mt-0">
                <a href="<?php echo e(route('heads.create')); ?>">
                    <button class="button text-white bg-theme-1 shadow-md">
                        Add Head
                    </button>
                </a>
            </div>
        </div>
    </div>
    </div>
    <!-- BEGIN: HTML Table Data -->
    <div class="intro-y box p-5 mt-5">
        <div class="flex flex-col sm:flex-row sm:items-end xl:items-start">
            <form class="xl:flex w-full" id="tabulator-html-filter-form">
                <div class="sm:flex items-center justify-between w-full">
                    <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center gap-2 flex-wrap">
                            <label for="page-size" class="form-label mb-0">Data Per Page</label>
                            <select id="page-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                                
                                <option value="10">10</option>
                                <option value="30">30</option>
                                <option value="50">50</option>
                                <option value="100">100</option>
                            </select>
                        </div>
                    </div>

                    &nbsp; &nbsp; &nbsp;
                    <div>
                        <input type="text" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border" id="search-string"
                            placeholder="Search...">
                    </div>

                </div>
            </form>
        </div>
        <div class="overflow-x-auto scrollbar-hidden">
            <div class="mt-5 table-report table-report--tabulator" id="transcation_table"></div>
        </div>
    </div>
    <!-- END: HTML Table Data -->


    <script src="<?php echo e(asset('js/tabulator.min.js')); ?>"></script>
    <script>
        $(document).ready(function() {

            <?php if(session('success')): ?>
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: <?php echo json_encode(session('success'), 15, 512) ?>,
                    timer: 2500,
                    showConfirmButton: false
                });
            <?php endif; ?>

            <?php if(session('error')): ?>
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: <?php echo json_encode(session('error'), 15, 512) ?>,
                    timer: 2500,
                    showConfirmButton: false
                });
            <?php endif; ?>

        });
    </script>

    <?php echo $__env->make('utils.alert', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // 🧭 Current financial year range
            var currentYearRange =
                "<?php echo e(\Carbon\Carbon::createFromDate(date('Y'), 4, 1)->format('d-m-Y') . ' to ' . \Carbon\Carbon::createFromDate(date('Y') + 1, 3, 31)->format('d-m-Y')); ?>";

            // 🧱 Initialize Tabulator table
            var table = new Tabulator("#transcation_table", {
                ajaxURL: "<?php echo e(route('transactions.list')); ?>",
                ajaxParams: function() {
                    return {
                        _token: document.querySelector('meta[name="csrf-token"]').getAttribute(
                            "content"),
                        search: document.querySelector("#search-string").value,
                        "type": "expense"
                        // organisation_id: document.querySelector("#org-size").value,
                    };
                },
                ajaxConfig: "POST",
                layout: "fitColumns",
                theme: "bootstrap5",
                paginationMode: "remote",
                pagination: true,
                paginationSize: 10,
                paginationSizeSelector: false,
                movableRows: true,
                movableColumns: true,
                ajaxLoaderLoading: `
                <div style='display:inline-block; border:4px solid #333; border-radius:10px; background:#fff; font-weight:bold; font-size:16px; color:#000; padding:10px 20px;'>
                    Loading Data
                </div>
            `,
                columnDefaults: {
                    headerHozAlign: "left",
                    tooltip: true,
                },
                columns: [{
                        title: "SL",
                        formatter: function(cell, formatterParams, onRendered) {
                            let row = cell.getRow();
                            let data = row.getData();
                            let page = table.getPage();
                            let perPage = table.getPageSize();

                            if (!page) page = 0;
                            if (!perPage) perPage = 10;

                            return ((row.getPosition(true) + 1) + ((page - 1) * perPage) - 1);
                        },
                        maxWidth: 100,
                        headerSort: false,
                        hozAlign: "center"
                    },
                    {
                        title: "Transaction Date",
                        field: "transaction_date",
                        headerSort: true,
                        minWidth: 180,
                    },
                    {
                        title: "Transaction Amount",
                        field: "transaction_amount",
                        headerSort: true,
                        minWidth: 180,
                    },

                    {
                        title: "Head Name",
                        field: "head_name",
                        headerSort: true,
                        minWidth: 180,
                    },
                    {
                        title: "Payment Type",
                        field: "payment_type_name",
                        headerSort: true,
                        minWidth: 100,
                    },
                    {
                        title: "Action",
                        headerHozAlign: "center",
                        headerSort: false,
                        hozAlign: "center",
                        width: 100,
                        formatter: function(cell) {
                            let data = cell.getRow().getData();
                            return `
                            <button class="edit-btn" data-id="${data.id}" style="background:none; border:none; color:blue; cursor:pointer;">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"
                                    class="feather feather-eye w-4 h-4 mr-1">
                                    <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8S1 12 1 12z"></path>
                                    <circle cx="12" cy="12" r="3"></circle>
                                </svg>
                            </button>
                        `;
                        }
                    },
                ],
                rowFormatter: function(row) {
                    const data = row.getData();
                    if (data.is_current === 1) {
                        row.getElement().style.backgroundColor = "lightblue";
                        row.getElement().style.color = "black";
                    }
                },
                ajaxResponse: function(url, params, response) {
                    return {
                        data: response.data,
                        last_page: response.last_page,
                        current_page: response.current_page,
                        total: response.total,
                    };
                }
            });



            // 📄 Page size change
            document.getElementById("page-size")?.addEventListener("change", function() {
                table.setPageSize(Number(this.value));
            });

            // 🔍 Live search
            document.getElementById("search-string")?.addEventListener("input", function() {
                table.setData();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravelproject\ramkrishna-sevashram-new\resources\views/jounaltransactions/expense.blade.php ENDPATH**/ ?>