<?php $__env->startSection('content'); ?>
<div class="intro-y col-span-12 lg:col-span-12 user-prtmition-table">
    <div class="intro-y box mt-5">
        <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
            <p class="mr-auto" style="font-size: 24px;    font-weight: 500;">
                Permissions for user - <span style="color: #1c3faa;"><?php echo e($user->name); ?></span> 
</p>
        </div>
        <div class="p-5">
            <form method="POST" action="<?php echo e(route('users.permissions.store', $user->id)); ?>">
                <?php echo csrf_field(); ?>
                <div class="space-y-4">
                    <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div x-data="{ open: true }" class="border rounded-lg p-4 bg-gray-50 shadow-sm">

                        <!-- Parent -->
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-2">
                                <?php if($menu->children->count()): ?>
                                <!-- Expand/Collapse button -->
                                <button type="button" @click="open = !open"
                                    class="text-sm text-gray-600 hover:text-blue-600">
                                    <span x-show="!open">▶</span>
                                    <span x-show="open">▼</span>
                                </button>
                                <?php endif; ?>
                                <span class="font-bold text-gray-800"><?php echo e(ucfirst($menu->name)); ?></span>
                            </div>

                            <!-- If no children → show checkboxes -->
                            <?php if(!$menu->children->count()): ?>
                            <div class="flex items-center gap-4">
                                <div class="flex gap-3">
                                    <?php $__currentLoopData = $permissionCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permissionCode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <label class="inline-flex items-center gap-1 text-sm">

                                        <?php if($permissionCode->id == 1): ?>
                                        <input type="radio"
                                            class="rounded border-gray-300 text-blue-600 shadow-sm focus:ring-blue-500"
                                            value="<?php echo e($permissionCode->id); ?>"
                                            name="permission_codes[<?php echo e($menu->id); ?>][]"
                                            <?php if($user->menuPermissions->where('menu_id', $menu->id)->pluck('permissions')->contains($permissionCode->id)): echo 'checked'; endif; ?>>View
                                        <?php elseif($permissionCode->id == 2): ?>
                                        <input type="radio"
                                            class="rounded border-gray-300 text-blue-600 shadow-sm focus:ring-blue-500"
                                            value="<?php echo e($permissionCode->id); ?>"
                                            name="permission_codes[<?php echo e($menu->id); ?>][]"
                                            <?php if($user->menuPermissions->where('menu_id', $menu->id)->pluck('permissions')->contains($permissionCode->id)): echo 'checked'; endif; ?>> Add
                                        <?php endif; ?>
                                    </label>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <div>
                                    <button type="button"
                                        class="type-btn clear-radio bg-gray-200 text-gray-700 px-3 py-1 rounded"
                                        data-menu-id="<?php echo e($menu->id); ?>">
                                        Clear
                                    </button>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>

                        <!-- Children -->
                        <?php if($menu->children->count()): ?>
                        <div class="ml-6 mt-3 space-y-2" x-show="open" x-transition>
                            <?php $__currentLoopData = $menu->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex items-center justify-between pl-3 border-l-2 border-gray-300">
                                <span class="font-medium text-gray-700"><?php echo e(ucfirst($child->name)); ?></span>
                                <div class="flex items-center gap-4">
                                    <div class="flex gap-3">
                                        <?php $__currentLoopData = $permissionCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permissionCode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <label class="inline-flex items-center gap-1 text-sm">

                                            <?php if($permissionCode->id == 1): ?>
                                            <input type="radio"
                                                class="rounded border-gray-300 text-blue-600 shadow-sm focus:ring-blue-500"
                                                value="<?php echo e($permissionCode->id); ?>"
                                                name="permission_codes[<?php echo e($child->id); ?>][]"
                                                <?php if($user->menuPermissions->where('menu_id', $child->id)->pluck('permissions')->contains($permissionCode->id)): echo 'checked'; endif; ?>> View
                                            <?php elseif(
                                            $permissionCode->id == 2 &&
                                            strtolower($child->name) !== 'incomes ledger' &&
                                            strtolower($child->name) !== 'expenses ledger'): ?>
                                            <?php if($menu->id != 45): ?>
                                            <input type="radio"
                                                class="rounded border-gray-300 text-blue-600 shadow-sm focus:ring-blue-500"
                                                value="<?php echo e($permissionCode->id); ?>"
                                                name="permission_codes[<?php echo e($child->id); ?>][]"
                                                <?php if($user->menuPermissions->where('menu_id', $child->id)->pluck('permissions')->contains($permissionCode->id)): echo 'checked'; endif; ?>> Add
                                            <?php endif; ?>
                                            <?php endif; ?>
                                        </label>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <button type="button"
                                        class="clear-radio bg-gray-200 text-gray-700 px-3 py-1 rounded type-btn"
                                        data-menu-id="<?php echo e($child->id); ?>">
                                        Clear
                                    </button>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <div class="mt-6">
                    <button type="submit" class="button w-32 bg-theme-1 text-white hover:bg-blue-700">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Alpine.js -->
<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('.clear-radio').forEach(function(button) {
            button.addEventListener('click', function() {
                const menuId = this.dataset.menuId;
                document.querySelectorAll(`input[name="permission_codes[${menuId}][]"]`)
                    .forEach(function(radio) {
                        radio.checked = false;
                    });
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravelproject\ramkrishna-sevashram-new\resources\views/auth/users/permission.blade.php ENDPATH**/ ?>