@extends('master.authMaster')

@section('content')
@php
use Carbon\Carbon;

$currentOrganisationId = old('organisation_id', optional($currentOrganisation)->organisation_id);
$financialYear = \App\Models\AccountingYear::current();
if ($financialYear) {
[$fyStart, $fyEnd] = array_map('trim', explode(' to ', $financialYear->accounting_year_financial));
$minDate = Carbon::createFromFormat('d-m-Y', $fyStart)->toDateString();
$maxDateCandidate = Carbon::createFromFormat('d-m-Y', $fyEnd);
$today = Carbon::today();
$maxDate = $today->greaterThan($maxDateCandidate) ? $maxDateCandidate->toDateString() : $today->toDateString();
} else {
$minDate = now()->subYear()->toDateString();
$maxDate = now()->toDateString();
}

$oldRows = collect(old('contra_rows', [['bank_id' => null, 'amount' => null, 'date' => null]]));
@endphp

<div class="intro-y col-span-12 lg:col-span-12">
    <div class="intro-y box mt-5">
        <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
            <h2 class="font-medium text-base mr-auto">
                Contra Entry List
            </h2>
            <a href="{{ route('transactions.index') }}"
                class="button text-white bg-gray-600 hover:bg-gray-700 shadow-md mt-3 sm:mt-0">
                ← Back to Transactions
            </a>
        </div>
        <div style="display:flex; justify-content:space-between; margin-top:10px; padding:0 20px; align-items:center;">

            <!-- LEFT: Date Filters -->
            <div style="display:flex; gap:10px; align-items:center;">
                <input
                    type="date"
                    class="input w-full sm:w-40 xxl:w-full border"
                    id="from-date"
                    placeholder="From Date" />

                <input
                    type="date"
                    class="input w-full sm:w-40 xxl:w-full border"
                    id="to-date"
                    placeholder="To Date" />
            </div>

            <!-- RIGHT: Search -->
            <div>
                <input
                    type="text"
                    class="input w-full sm:w-40 xxl:w-full border"
                    id="search-string"
                    placeholder="Search..." />
            </div>

        </div>

        <div class="p-5">
            <div class="mt-5 table-report table-report--tabulator" id="contra-listing-table"></div>
            <div style="display: flex; justify-content : end;">
                <button style="
                    background-color:#0072ff;
                    border-radius:20px;
                    padding:5px 20px;
                    display:flex;
                    color : white;
                    align-items:center;
                    gap:6px;
                    ">
                    <svg viewBox="0 0 24 24" style="width:20px; height:20px;">
                        <g>
                            <path  fill="white" d="M17.5 20H17v-2h.5a4.5 4.5 0 1 0-1.245-8.821l-1.33.383.054-1.383a1.881 1.881 0 0 1 .02-.2 4 4 0 0 0-7.924-.719l-.13.7-.7.106a5 5 0 0 0-.91 9.652L4.667 19.6a7 7 0 0 1 .608-13.377 6 6 0 0 1 11.646.8A6.5 6.5 0 1 1 17.5 20z" />
                            <path  fill="white" d="m11 22.414-3.707-3.707 1.414-1.414L11 19.586l2.293-2.293 1.414 1.414L11 22.414z" />
                            <path  fill="white" d="M10 11h2v10h-2z" />
                        </g>
                    </svg>
                    Download Report
                </button>

            </div>
        </div>

    </div>
</div>

@include('utils.alert')


<script src="{{ asset('js/tabulator.min.js') }}"></script>
<script>
    var table = new Tabulator("#contra-listing-table", {
        ajaxURL: "{{ route('heads.list') }}",
        ajaxParams: function() {
            return {
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute("content"),
                search: document.querySelector("#search-string").value,
            };
        },

        ajaxConfig: "POST",
        layout: "fitColumns",
        theme: "bootstrap5",
        paginationMode: "remote",
        pagination: true,
        paginationSize: 10,
        paginationSizeSelector: false,
        layout: "fitColumns",
        search: true,
        movableRows: true,
        movableColumns: true,

        // 🔹 Custom loader spinner
        ajaxLoaderLoading: `
                   <div style='display:inline-block; border:4px solid #333; border-radius:10px; background:#fff; font-weight:bold; font-size:16px; color:#000; padding:10px 20px;'>Loading Data</div>
                `,


        columnDefaults: {
            headerHozAlign: "left",
            tooltip: true,
        },
        columns: [{
                formatter: "handle",
                width: 40,
                headerSort: false,
                frozen: true,
                hozAlign: "center",
            },
            {
                title: "Date",
                field: "id",
                headerSort: true,
                // formatter: function(cell, formatterParams, onRendered) {
                //     let row = cell.getRow();
                //     let data = row.getData();
                //     let page = table.getPage();
                //     let perPage = table.getPageSize();

                //     if (!page) page = 0;
                //     if (!perPage) perPage = 10;

                //     return ((row.getPosition(true) + 1) + ((page - 1) * perPage) - 1);
                // },
                // maxWidth: 150
            },
            {
                title: "Id",
                field: "name",
                headerSort: true,
                minWidth: 200
            },
            {
                title: "Particular (Dr)",
                field: "groupname",
                headerSort: true,
                minWidth: 200
            },
            {
                title: "Particular (Cr)",
                field: "groupname",
                headerSort: true,
                minWidth: 200
            },
            {
                title: "Narration",
                field: "groupname",
                headerSort: true,
                minWidth: 200
            },
            {
                title: "Status",
                headerHozAlign: "center",
                formatter: function(cell) {
                    let data = cell.getRow().getData();
                    if (data.status === 'active') {
                        return `<button class="status-btn" data-id="${data.id}"  data-status="${data.status}" style="color: #ffffff;background: green;border-radius: 25px; width: 70px;">${data.status}</button> `;
                    } else {
                        return `<button class="status-btn" data-id="${data.id}" data-status="${data.status}" style="color: #ffffff;background: red;border-radius: 25px; width: 70px;">${data.status}</button> `;

                    }
                },
                hozAlign: "center",
                width: 180,
            },
            {
                title: "Action",
                headerHozAlign: "center",
                headerSort: false,
                formatter: function(cell) {
                    let data = cell.getRow().getData();
                    return `
                    <button class="edit-btn" data-id="${data.id}" style="color: blue;"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-check-square w-4 h-4 mr-1"><polyline points="9 11 12 14 22 4"></polyline><path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"></path>
                    </svg></button>
                    <button class="delete-btn" data-id="${data.id}"style="color: red;"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 w-4 h-4 mr-1">
                    <polyline points="3 6 5 6 21 6"></polyline>
                    <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                    <line x1="10" y1="11" x2="10" y2="17"></line>
                    <line x1="14" y1="11" x2="14" y2="17"></line>
                    </svg></button>
                `;
                },
                hozAlign: "center",
                width: 180,
            },

        ],
        rowFormatter: function(row) {
            const data = row.getData();
            if (data.is_current === 1) {
                row.getElement().style.backgroundColor = "lightblue";
                row.getElement().style.color = "black";
            }
        },

        ajaxResponse: function(url, params, response) {
            return {
                data: response.data,
                last_page: response.last_page,
                current_page: response.current_page,
                total: response.total
            };
        },
    });

    table.on("rowMoved", function(row) {

        var tableData = table.getData(); // current visible order
        var orderedIds = tableData.map(item => item.id); // FIXED ✔

        fetch("{{ route('heads.updateOrder') }}", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute("content"),

                },
                body: JSON.stringify({
                    items: orderedIds
                })
            })
            .then(response => response.json())
            .then(data => {
                console.log("Reorder success", data);

                // 🔥 Reload table so order reflects from DB
                table.replaceData();
            })
            .catch(error => console.error("Reorder failed:", error));
    });


    $(document).on('click', '.edit-btn', function() {
        let id = $(this).data('id');
        let encodedId = btoa(id);
        window.location.href = `/head-groups/edit/${encodedId}`; // Redirect to edit page
    });

    $(document).on('click', '.delete-btn', function() {
        let id = $(this).data('id');

        Swal.fire({
            title: "Are you sure?",
            text: "This record will be deleted!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonText: "Yes, delete it!",
            cancelButtonText: "Cancel"
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ route('head-groups.delete') }}",
                    type: 'POST',
                    data: {
                        id: id,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.status) {
                            Swal.fire("Deleted!", response.message, "success");
                            table.replaceData();
                        } else {
                            Swal.fire("Error!", response.message || "Failed to delete",
                                "error");
                        }
                    },
                    error: function(xhr) {
                        Swal.fire("Error!", "An error occurred while deleting.", "error");
                    }
                });
            }
        });
    });

    $(document).on('click', '.status-btn', function() {
        let id = $(this).data('id');
        let status = $(this).data('status');
        console.log(status);
        let newStatus = status === 'active' ? 'inactive' : 'active';

        Swal.fire({
            title: "Are you sure?",
            text: "You want to make it '" + newStatus + "'",
            icon: "warning",
            showCancelButton: true,
            confirmButtonText: "Yes!",
            cancelButtonText: "Cancel"
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ route('head-groups.status') }}",
                    type: 'POST',
                    data: {
                        id: id,
                        new_status: newStatus,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.status) {
                            Swal.fire("Changed!", response.message, "success");
                            table.replaceData(); // 🔄 reload Tabulator data
                        } else {
                            Swal.fire("Error!", response.message || "Failed to change",
                                "error");
                        }
                    },
                    error: function(xhr) {
                        Swal.fire("Error!", "An error occurred while changing status.",
                            "error");
                    }
                });
            }
        });
    });

    document.getElementById("page-size").addEventListener("change", function() {
        table.setPageSize(Number(this.value));
    });

    /*     document.getElementById("org-size").addEventListener("change", function() {
            table.setData();
        }); */

    document.getElementById("search-string").addEventListener("input", function() {
        table.setData();
    });
</script>
@endsection