@extends('master.authMaster')

@section('content')
    <div class="intro-y col-span-12 lg:col-span-12 transection-details-view">
        <div class="intro-y box mt-8 shadow-lg rounded-2xl overflow-hidden">
            <div class="bg-gradient-to-r from-blue-600 to-indigo-600 p-5">
                <h2 class="font-semibold text-lg text-black">
                    Expense Transaction Details:
                </h2>
                <div class="w-full sm:w-auto  mt-4 sm:mt-0 mr-4" style="float: right">
                    <a href="{{ route('expense.print', $expense->expense_id) }}" target="_blank">
                        <button class="button text-white bg-theme-1 shadow-md">
                            Print Details
                        </button>
                    </a>
                </div>
            </div>

            <div class="p-8 bg-white">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-y-6 gap-x-10">
                    @if (isset($expense->organisation_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Organisation Name:</p>
                            <p class="text-blue-600 font-semibold">
                                @foreach ($organisations as $organisation)
                                    @if ($organisation->organisation_id == $expense->organisation_id)
                                        {{ $organisation->organisation_name }}
                                    @endif
                                @endforeach
                            </p>
                        </div>
                    @endif
                    @if (isset($expense->account_type_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Account Type Name:</p>
                            <p class="text-blue-600 font-semibold">
                                @foreach ($accountTypes as $accountType)
                                    @if ($accountType->account_type_id == $expense->account_type_id)
                                        {{ $accountType->account_type_Name }}
                                    @endif
                                @endforeach
                            </p>
                        </div>
                    @endif
                    @if (isset($expense->expense_head))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Expense Head Name:</p>
                            <p class="text-blue-600 font-semibold">
                                @foreach ($expenseHeads as $expenseHead)
                                    @if ($expenseHead->expense_head_id == $expense->expense_head)
                                        {{ $expenseHead->expense_head_name }}
                                    @endif
                                @endforeach
                            </p>
                        </div>
                    @endif
                    @if (isset($expense->receipt_no))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Voucher / Receipt No. :</p>
                            <p class="text-blue-600 font-semibold">
                                @if (isset($expense->receipt_no))
                                    {{ $expense->receipt_no ? $expense->receipt_no : '' }}
                                @endif
                            </p>
                        </div>
                    @endif
                    @if (@isset($expense->asset_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Asset Name:</p>
                            <p class="text-blue-600 font-semibold">
                                @foreach ($assets as $asset)
                                    @if ($asset->asset_id == $expense->asset_id)
                                        {{ $asset->asset_name }}
                                    @endif
                                @endforeach
                            </p>
                        </div>
                    @endif
                    @if (@isset($expense->liability_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Liability Name:</p>
                            <p class="text-blue-600 font-semibold">
                                @foreach ($liabilities as $liability)
                                    @if ($liability->liability_id == $expense->liability_id)
                                        {{ $liability->liability_name }}
                                    @endif
                                @endforeach
                            </p>
                        </div>
                    @endif
                    @if (@isset($expense->vendor_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Vendor Name:</p>
                            <p class="text-blue-600 font-semibold">
                                @foreach ($vendors as $vendor)
                                    @if ($vendor->vendor_id == $expense->vendor_id)
                                        {{ $vendor->vendor_name }} - {{ $vendor->vendor_type }}
                                    @endif
                                @endforeach
                            </p>
                        </div>
                    @endif
                    @if (@isset($expense->staff_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Staff Name:</p>
                            <p class="text-blue-600 font-semibold">
                                @foreach ($vendors as $vendor)
                                    @if ($vendor->vendor_id == $expense->staff_id)
                                        {{ $vendor->vendor_name }} - {{ $vendor->vendor_type }}
                                    @endif
                                @endforeach
                            </p>
                        </div>
                    @endif
                    @if (@isset($expense->financial_year_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Accounting Year:</p>
                            <p class="text-blue-600 font-semibold">
                                @foreach ($accounting_years as $accounting_year)
                                    @if ($accounting_year->accounting_year_id == $expense->financial_year_id)
                                        {{ $accounting_year->accounting_year_financial }}
                                    @endif
                                @endforeach
                            </p>
                        </div>
                    @endif
                    @if (@isset($expense->transaction_date))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Date of Transaction:</p>
                            <p class="text-blue-600 font-semibold">
                                {{ \Carbon\Carbon::parse($expense->transaction_date)->format('d-m-Y') }}
                            </p>
                        </div>
                    @endif
                    @if (@isset($expense->transaction_reference))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Transaction Reference No.:</p>
                            <p class="text-blue-600 font-semibold">{{ $expense->transaction_reference }}</p>
                        </div>
                    @endif
                    @if (@isset($expense->payment_type_id))
                        <div class="list-chart">
                            <p class="text-gray-600 font-medium">Payment Type:</p>
                            <p class="text-blue-600 font-semibold">{{ $expense->paymentType->name ?? '-' }}</p>
                        </div>
                    @endif

                    {{-- @if (@isset($expense->purpose_id))
                        <div>
                            <p class="text-gray-600 font-medium">Purpose:</p>
                            <p class="text-blue-600 font-semibold">{{ $expense->purpose->name ?? '-' }}</p>
                        </div>
                    @endif --}}
                    @if (@isset($expense->transaction_narration))
                        <div class="md:col-span-2 list-chart">
                            <p class="text-gray-600 font-medium">Transaction Narration:</p>
                            <p class="text-blue-600 font-semibold italic">{{ $expense->transaction_narration ?? '—' }}</p>
                        </div>
                    @endif
                </div>
                @if (@isset($expense->transaction_amount))
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Transaction Amount:</p>
                        <p class="text-red-600 text-xl font-bold">
                            ₹ {{ number_format($expense->transaction_amount, 2) }}
                        </p>
                    </div>
                @endif
                @if (!empty($expense->file_path))
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Uploaded Files:</p>
                        <div class="flex gap-4 flex-wrap">
                            @foreach (explode(',', $expense->file_path) as $file)
                                @php
                                    $file = trim($file);
                                    $extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                                @endphp

                                @if ($extension === 'pdf')
                                    <a href="{{ asset('storage/' . $file) }}" target="_blank"
                                        class="flex flex-col items-center justify-center w-32 h-32 bg-gray-100 border rounded shadow cursor-pointer">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-12 h-12 text-red-600"
                                            fill="currentColor" viewBox="0 0 24 24">
                                            <path
                                                d="M6 2a2 2 0 0 0-2 2v16c0
                                                                                                                                                                            1.1.9 2 2 2h12a2 2 0 0
                                                                                                                                                                            0 2-2V8l-6-6H6zm7 1.5L18.5
                                                                                                                                                                            9H13V3.5zM8 13h8v2H8v-2z" />
                                        </svg>
                                        <span class="text-sm text-gray-700">PDF File</span>
                                    </a>
                                @else
                                    <a href="{{ asset('storage/' . $file) }}" target="_blank">
                                        <img src="{{ asset('storage/' . $file) }}" alt="Uploaded Image"
                                            class="w-32 h-32 object-cover rounded shadow cursor-pointer">
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif

                <div class="mt-8 text-right">
                    <a href="{{ route('expense.index') }}"
                        class="inline-flex items-center px-5 py-2.5 rounded-lg bg-gray-600 text-white font-medium hover:bg-gray-700 transition duration-200">
                        ← Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection
