@extends('master.authMaster')


@section('content')
    <div class="ledgers-page-sec bg-gray-100 col-span-12 lg:col-span-12">


        {{-- <h3 class="text-base font-medium mb-2 text-black mb-4">Net Total Account</h3> --}}
        <div class="ledgers-page-wraper flex w-full bg-white shadow-md rounded-2xl overflow-hidden">

            <!-- Sidebar / Filter Box -->
            <div class="w-full bg-white border rounded-2xl p-6 shadow-md">

                <div class="content-box">
                    <div class="sngl-box">
                        <div id="tab1" class="tab-content">

                            <table class="w-full text-left border-collapse overflow-hidden rounded-xl">
                                <thead>
                                    <tr class="bg-gray-50 border-b text-gray-700 text-sm">
                                        <th class="p-4 font-semibold">Accounts</th>
                                        <th class="p-4 text-right font-semibold">Amount</th>
                                        <th class="p-4 text-center font-semibold">Action</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-gray-200 text-sm">
                                    <tr class="hover:bg-gray-50">
                                        <td class="p-4 font-medium text-gray-800">Cash</td>
                                        <td class="p-4 text-right text-blue-600 font-semibold">
                                            {{ number_format($totalCash, 2) }}
                                        </td>
                                        <td class="p-4 text-center">
                                            <a href="{{ route('capital.amount.detail.index', ['flag' => 'cash']) }}">
                                                <button
                                                    class="px-4 py-1 rounded-lg bg-blue-500 hover:bg-blue-600 transition text-white text-sm shadow">
                                                    Show Details
                                                </button>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr class="hover:bg-gray-50">
                                        <td class="p-4 font-medium text-gray-800">Bank</td>
                                        <td class="p-4 text-right text-blue-600 font-semibold">
                                            {{ number_format($totalBank, 2) }}
                                        </td>
                                        <td class="p-4 text-center">
                                            <a href="{{ route('capital.amount.detail.index', ['flag' => 'bank']) }}">
                                                <button
                                                    class="px-4 py-1 rounded-lg bg-blue-500 hover:bg-blue-600 transition text-white text-sm shadow">
                                                    Show Details
                                                </button>
                                            </a>
                                        </td>
                                    </tr>

                                </tbody>
                            </table>

                        </div>
                    </div>
                </div>

                <div class="mt-6">
                    <button onclick="history.back()"
                        class="px-4 py-2 rounded-lg bg-gray-500 hover:bg-gray-600 text-white shadow text-sm transition">
                        ← Back
                    </button>
                </div>

            </div>
        @endsection
