@extends('master.authMaster')


@section('content')
{{-- Form --}}
<div class="intro-y col-span-12 lg:col-span-12">

    <!-- BEGIN: Select Options -->
    <div class="intro-y box mt-5">
        <!-- BEGIN: Horizontal Form -->

        <div class="intro-y box mt-5">
            <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                <h2 class="font-medium text-base mr-auto">
                    Edit
                    <b> Account Brought Forward</b><br>
                </h2>
            </div>

            <div class="p-5" id="horizontal-form">
                <div id="year-message" class="mb-4"></div>

                <form id="accountBroughtForwardForm" method="POST" action="{{ route('capital.update' , $accountCapital->id) }}">
                    @csrf
                    <div class="preview">
                        {{-- <div class="grid grid-cols-12 gap-6 mt-5"> --}}
                        <div class="intro-y col-span-12 lg:col-span-12">
                            <!-- BEGIN: Input -->



                            <div class="intro-y box">
                                <div class="p-5" id="input">
                                    <div class="preview">
                                        <div class="w-full -ml-4 -mr-4 flex flex-wrap">
                                            <div class="w-full px-4">
                                                <div class="mt-3">
                                                    <label> Accounting Year <span style="color: red">*</span></label>
                                                    <select id="accounting_year_id" name="accounting_year_id"
                                                        class="input w-full border mt-2" readonly>
                                                        @foreach ($years as $year)
                                                        <option value="{{ $year->accounting_year_id }}"
                                                            {{ $year->accounting_year_id == $accountCapital->financial_year_id ? 'selected' : '' }}>
                                                            {{ $year->accounting_year_financial }}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-organisation"></div>
                                                </div>
                                            </div>


                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Cash in Hand (₹)</label>
                                                    <input id="cash_in_hand" type="text"
                                                        class="input w-full border mt-2" name="cash_in_hand"
                                                        value="{{ old('cash_in_hand' , $accountCapital->cash_in_hand) }}" placeholder="Enter Amount">
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-cash_in_hand"></div>
                                                </div>
                                            </div>

                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Cash at Bank (₹)</label>
                                                    <input id="cash_at_bank" type="text"
                                                        class="input w-full border mt-2" name="cash_at_bank"
                                                        value="{{ old('cash_at_bank', $accountCapital->cash_at_bank) }}" placeholder="Enter Amount">
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-transaction-amount"></div>
                                                </div>
                                            </div>

                                            <div class="w-full px-4">
                                                <div class="mt-3">
                                                    <label>Date As On</label>
                                                    <input type="date" class="input w-full border mt-2"
                                                        name="transaction_date"
                                                        value="{{ old('transaction_date', Carbon\Carbon::parse($accountCapital->dated_as_on)->format('Y-m-d')) }}"
                                                        onfocus="this.showPicker()" readonly />
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-date"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            {{-- </div> --}}

                        </div>
                        <div class="sm:pl-5 mt-5">

                            <a href="{{ route('capital.index') }}"><span
                                    class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600">
                                    ← Back
                                </span></a>
                            <button type="submit" class="button w-24 bg-theme-1 text-white">Save</button>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
    <!-- END: Horizontal Form -->
</div>
<!-- END: Select Options -->
</div>
{{-- <div class="intro-y col-span-12 lg:col-span-6">
    </div> --}}


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        $('#accounting_year_id').on('mousedown', function(e) {
            e.preventDefault();
        });
        $('#accounting_year_id').on('keydown', function(e) {
            e.preventDefault();
        });


        $("#cash_in_hand, #cash_at_bank").on("input", function() {
            let val = $(this).val();
            val = val.replace(/[^0-9.]/g, "");
            if ((val.match(/\./g) || []).length > 1) {
                val = val.replace(/\.+$/, "");
            }
            $(this).val(val);
        });

        function cleanAmount(val) {
            val = val.replace(/[^0-9.]/g, "");

            let parts = val.split(".");
            if (parts.length > 2) {
                val = parts[0] + "." + parts.slice(1).join("");
            }
            if (/^0[0-9]/.test(val)) {
                val = val.replace(/^0+/, "");
            }

            if (val.startsWith("0.") || val === "0") {
                val = val.replace(/^0+/, "");
            }
            return val;
        }
        $("input[name='cash_in_hand'], input[name='cash_at_bank']").on("input", function() {
            this.value = cleanAmount(this.value);
        });
    });
</script>
@endsection