$(document).ready(function () {
    const $container = $("#donation-rows");
    const maxRows = 10;

    $("#donationForm").on("submit", function (e) {
        let submitButton = $("#submitDonation");
        e.preventDefault();
        submitButton.prop("disabled", true).text("Submitting...");
        form_submit(this);
    });

    $container.on("click", ".btn-add", function (e) {
        e.preventDefault();
        let $template = $(".donation-row").first();
        let $nextRow = $template.clone(true, true);
        let rowCount = $container.find(".donation-mamber-wraper").length;
        if (rowCount >= maxRows) {
            toastr.error(
                "You can only add up to " + maxRows + " donations at once.",
                "Error",
                toastrProperties
            );
            return;
        }

        $nextRow.css("visibility", "visible");
        $nextRow.find('input[name="amounts[]"]').val("");
        $nextRow.find("select").prop("selectedIndex", 0);

        $container.append($nextRow);
        disableSelectedIncomeHeads();
    });

    $container.on("click", ".btn-remove", function (e) {
        e.preventDefault();
        if ($container.find(".donation-mamber-wraper").length > 1) {
            $(this).closest(".donation-mamber-wraper").remove();
            disableSelectedIncomeHeads();
        }
    });

    $container.on("change", "select[name='income_heads[]']", function () {
        disableSelectedIncomeHeads();
    });

    $container.on("input", "input[name='amounts[]']", function () {
        this.value = cleanAmount(this.value);
    });

    function form_submit(form) {
        let formData = new FormData(form);
        let submitButton = $("#submitDonation");
        $.ajax({
            url: storeTransactionRoute,
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            success: function (response) {
                if (response.status) {
                    toastr.success(response.message, toastrProperties);
                    window.location.href = "/donor";
                } else {
                    toastr.error(response.message, "Error", toastrProperties);
                    submitButton.prop("disabled", false).text("Save");
                }
            },
            error: function (xhr) {
                toastr.error(
                    xhr.responseJSON?.message || "Something went wrong!",
                    "Error",
                    toastrProperties
                );
                submitButton.prop("disabled", false).text("Save");
            },
        });
    }
    function disableSelectedIncomeHeads() {
        let selectedHeads = [];
        $container.find("select[name='income_heads[]']").each(function () {
            if ($(this).val()) selectedHeads.push($(this).val());
        });

        $container.find("select[name='income_heads[]']").each(function () {
            let currentVal = $(this).val();
            $(this)
                .find("option")
                .each(function () {
                    if (
                        selectedHeads.includes($(this).val()) &&
                        $(this).val() !== currentVal
                    ) {
                        $(this).prop("disabled", true);
                    } else {
                        $(this).prop("disabled", false);
                    }
                });
        });
    }
    function cleanAmount(val) {
        val = val.replace(/[^0-9.]/g, "");

        let parts = val.split(".");
        if (parts.length > 2) {
            val = parts[0] + "." + parts.slice(1).join("");
        }

        if (/^0[0-9]/.test(val)) {
            val = val.replace(/^0+/, "");
        }

        if (val.startsWith("0.") || val === "0") {
            val = val.replace(/^0+/, "");
        }

        return val;
    }
});
