<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('accounting_years', function (Blueprint $table) {
            $table->unsignedBigInteger('accounting_start_year')->nullable()->after('accounting_year_financial');
            $table->unsignedBigInteger('accounting_end_year')->nullable()->after('accounting_start_year');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('accounting_years', function (Blueprint $table) {
            $table->dropColumn(['accounting_start_year', 'accounting_end_year']);
        });
    }
};
