<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('heads', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->unsignedBigInteger('head_group_id');
            $table->unsignedBigInteger('account_type_id');
            $table->string('type')->nullable();
            $table->integer('organisation_id');
            $table->decimal('opening_balance', 15, 2)->default(0);
            $table->string('asset_or_liability_type')->nullable();
            $table->enum('depriciation_type', ['flat', 'percentage'])->nullable();
            $table->string('depriciation_rate')->nullable();
            $table->string('depriciation_tenure')->nullable()->comment("Depriciation tenure in months");
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('heads');
    }
};
