<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {

        Schema::table('organisations', function (Blueprint $table) {
            $table->integer('organisation_id', true)->change();
            $table->renameColumn('organisation_Name', 'organisation_name');
            $table->renameColumn('accounting_year_ID', 'accounting_year_id');
            $table->renameColumn('organisation_Address', 'organisation_address');
            $table->renameColumn('organisation_ContactNumber', 'organisation_contact_number');
            $table->renameColumn('organisation_Email', 'organisation_email');
            $table->renameColumn('organisation_GSTIN', 'organisation_gstin');
            $table->renameColumn('organisation_PAN', 'organisation_pan');
        });
    }

    public function down(): void
    {
        Schema::table('organisations', function (Blueprint $table) {
            $table->bigIncrements('organisation_ID')->change();
            $table->renameColumn('organisation_name', 'organisation_Name');
            $table->renameColumn('accounting_year_id', 'accounting_year_ID');
            $table->renameColumn('organisation_address', 'organisation_Address');
            $table->renameColumn('organisation_contact_number', 'organisation_ContactNumber');
            $table->renameColumn('organisation_email', 'organisation_Email');
            $table->renameColumn('organisation_gstin', 'organisation_GSTIN');
            $table->renameColumn('organisation_pan', 'organisation_PAN');
        });
    }
};
