<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LiabilityBroughtForward extends Model
{
    use HasFactory;

    protected $table = 'liability_brought_forwards';

    protected $fillable = [
        'financial_year_id',
        'total_liability_amount',
        'user_id',
        'dated_as_on',
        'organisation_id',
        'account_type_id'
    ];

    public function financialYear()
    {
        return $this->belongsTo(AccountingYear::class, 'financial_year_id');
    }
}
