<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\CommonTrait;

class Income extends Model
{
    use HasFactory, SoftDeletes, CommonTrait;

    protected $table;
    protected $primaryKey = 'id';

    protected $fillable = [
        'organisation_id',
        'account_type_id',
        'payment_type_id',
        'head_id',
        'user_id',
        'transaction_reference',
        'transaction_amount',
        'transaction_date',
        'transcation_type',
        'transaction_narration',
        'money_receipt_no',
        'file_path',
        'paid_by',
        'donor_id',
        'head_group_id'
    ];
    
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = $this->getYearPrefixedTables()['journal_transactions'];
    }
    public function organisation()
    {
        return $this->belongsTo(Organisation::class, 'organisation_id', 'organisation_id');
    }

    public function accountType()
    {
        return $this->belongsTo(AccountType::class, 'account_type_id', 'account_type_id');
    }

    public function incomeHead()
    {
        return $this->belongsTo(IncomeHead::class, 'head_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
    public function paymentType()
    {
        return $this->belongsTo(PaymentType::class, 'payment_type_id', 'id');
    }
    public function purpose()
    {
        return $this->belongsTo(Purpose::class, 'purpose_id', 'id');
    }
    public function incomeHeadGroup()
    {
       return $this->belongsTo(IncomeHeadGroup::class, 'head_group_id', 'id');
       
    }
    public function donor()
    {
        return $this->belongsTo(Donor::class, 'donor_id', 'donor_id');
    }

    public function donorRecords()
    {
        return $this->hasMany(DonorRecord::class, 'journal_id', 'income_id');
    }
}
