<?php

namespace App\Http\Controllers;

use App\Models\AccountingYear;
use App\Models\Menu;
use App\Models\Organisation;
use App\Models\Vendor;
use App\Services\PermissionService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class LedgerVendorController extends Controller
{
    protected $permissionService;
    protected $menuId;
    protected $currentYear;
    protected $currentOrgId;


    public function __construct(PermissionService $permissionService)
    {
        $this->permissionService = $permissionService;
        $this->menuId = Menu::where('route', 'ledger.vendor.index')->value('id');
        $this->currentYear = AccountingYear::current();
        $this->currentOrgId = Organisation::current();
    }

    public function index()
    {
        if (!$this->permissionService->hasPermission($this->menuId, 'r')) {
            abort(403, 'You do not have read access to Ledger Vendor Records.');
        }
        $vendorsWithRecords = DB::table('vendor_records as vr')
            ->join('vendors as v', 'vr.vendor_id', '=', 'v.vendor_id')
            ->leftJoin('expenses as e', 'vr.journal_id', '=', 'e.expense_id')
            ->where(function ($query) {
                $query->whereNull('vr.journal_id')
                    ->orWhereNull('e.deleted_at');
            })
            ->where('e.organisation_id',  $this->currentOrgId->organisation_id)
            ->select(
                'v.vendor_id as vendor_id',
                'v.vendor_name',
                'v.vendor_type',
                'v.vendor_contact_person',
                'v.vendor_phone_number',
                'v.vendor_email',
                DB::raw('SUM(vr.total_amount) as total_amount'),
                DB::raw('SUM(vr.paid_amount) as paid_amount')
            )
            ->groupBy(
                'v.vendor_id',
                'v.vendor_name',
                'v.vendor_type',
                'v.vendor_contact_person',
                'v.vendor_phone_number',
                'v.vendor_email'
            )
            ->get();

        return view('auth.ledgers.vendor.index', compact('vendorsWithRecords'));
    }

    public function getVendorHeadDetails($vendor_id)
    {
        $vendor = DB::table('vendors')
            ->where('vendor_id', $vendor_id)
            ->first();

        $vendorRecords = DB::table('vendor_records as vr')
            ->leftJoin('expenses as e', 'vr.journal_id', '=', 'e.expense_id')
            ->leftJoin('expense_heads as eh', 'e.expense_head', '=', 'eh.expense_head_id')
            ->where('vr.vendor_id', $vendor_id)
            ->where('e.organisation_id',  $this->currentOrgId->organisation_id)
            ->where(function ($query) {
                $query->whereNull('vr.journal_id')
                    ->orWhereNull('e.deleted_at');
            })
            ->orderBy('vr.created_at', 'desc')
            ->select(
                'vr.*',
                'e.transaction_date',
                'e.transaction_amount',
                'e.transaction_narration',
                'eh.expense_head_name'
            )
            ->get();
        $vendorType = $vendor->vendor_type;
        // return $vendorType;

        return view('auth.ledgers.vendor.detail', compact('vendor', 'vendorRecords', 'vendorType'));
    }
    public function create() {}

    public function store(Request $request) {}

    public function show(string $id) {}

    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
