<?php

namespace App\Http\Controllers;

use App\Models\AccountingYear;
use App\Models\Expense;
use App\Models\ExpenseHead;
use App\Models\ExpenseHeadGroup;
use App\Models\Menu;
use App\Models\Organisation;
use App\Services\PermissionService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class LedgerExpenseController extends Controller
{
    protected $permissionService;
    protected $menuId;
    protected $currentYear;
    protected $currentOrgId;


    public function __construct(PermissionService $permissionService)
    {
        $this->permissionService = $permissionService;
        $this->menuId = Menu::where('route', 'ledger.expense.index')->value('id');
        $this->currentYear = AccountingYear::current();
        $this->currentOrgId = Organisation::current();
    }

    public function index()
    {
        if (!$this->permissionService->hasPermission($this->menuId, 'r')) {
            abort(403, 'You do not have read access to Ledger Expense Records.');
        }

        $ledgerExpenseHeads = DB::table('expenses')
            ->where('financial_year_id', $this->currentYear->accounting_year_id)
            ->where('organisation_id', $this->currentOrgId->organisation_id)
            ->whereNull('deleted_at')
            ->select('expense_head', DB::raw('SUM(transaction_amount) as total_amount'))
            ->groupBy('expense_head')
            ->get()
            ->keyBy('expense_head');

        $ledgerExpenseHeadIds = $ledgerExpenseHeads->keys()->toArray();

        $expenseHeads = ExpenseHead::with('group')
            ->where('status', 'active')
            ->whereIn('expense_head_id', $ledgerExpenseHeadIds)
            ->get();

        $expenseHeadsByGroup = $expenseHeads->filter(fn($h) => $h->group)
            ->groupBy(fn($h) => $h->group->expense_head_group_ID);

        $expenseHeadsWithoutGroup = $expenseHeads->filter(fn($h) => !$h->group);

        $expenseHeadGroups = ExpenseHeadGroup::where('status', 'active')->get();

        return view('auth.ledgers.expense.index', compact(
            'ledgerExpenseHeads',
            'expenseHeadsByGroup',
            'expenseHeadsWithoutGroup',
            'expenseHeadGroups'
        ));
    }


    public function getExpenseHeadDetails($id)
    {

        if (!$this->permissionService->hasPermission($this->menuId, 'r')) {
            abort(403, 'You do not have read access to Ledger Expense Records.');
        }
        $expenses = Expense::with('expenseHead.group', 'purpose')
            ->where('expense_head', $id)
            ->where('financial_year_id', $this->currentYear->accounting_year_id)
            ->where('organisation_id', $this->currentOrgId->organisation_id)
            ->orderBy('transaction_date', 'desc')
            ->get();
        $expenseHeadName = $expenses->first()?->expenseHead?->expense_head_name ?? 'N/A';
        $expenseHeadGroupName = $expenses->first()?->expenseHead?->group?->expense_head_group_Name ?? 'Ungrouped';

        // return $expenseHeadGroupName;
        return view('auth.ledgers.expense.detail', compact('expenses', 'expenseHeadName', 'expenseHeadGroupName'));
    }
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
