<?php

namespace App\Http\Controllers;

use App\Models\AccountingYear;
use App\Models\Menu;
use App\Models\Organisation;
use App\Services\PermissionService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class LedgerDonorController extends Controller
{

    protected $permissionService;
    protected $menuId;
    protected $currentYear;
    protected $currentOrgId;


    public function __construct(PermissionService $permissionService)
    {
        $this->permissionService = $permissionService;
        $this->menuId = Menu::where('route', 'ledger.donor.index')->value('id');
        $this->currentYear = AccountingYear::current();
        $this->currentOrgId = Organisation::current();
    }

    public function index()
    {
        if (!$this->permissionService->hasPermission($this->menuId, 'r')) {
            abort(403, 'You do not have read access to Ledger Donor Records.');
        }

        $donorsWithRecords = DB::table('donor_records as dr')
            ->join('donors as d', 'dr.donor_id', '=', 'd.donor_id')
            ->leftJoin('incomes as i', 'dr.journal_id', '=', 'i.income_id')
            ->where(function ($query) {
                $query->whereNull('dr.journal_id')
                    ->orWhereNull('i.deleted_at');
            })
            ->where('i.organisation_id',  $this->currentOrgId->organisation_id)
            ->select(
                'd.donor_id',
                'd.donor_name',
                'd.donor_type',
                'd.donor_contact_person',
                'd.donor_phone_number',
                'd.donor_email',
                'd.donor_status',
                DB::raw('SUM(dr.paid_amount) as paid_amount')
            )
            ->groupBy(
                'd.donor_id',
                'd.donor_name',
                'd.donor_type',
                'd.donor_contact_person',
                'd.donor_phone_number',
                'd.donor_email',
                'd.donor_status'
            )
            ->get();

        return view('auth.ledgers.donor.index', compact('donorsWithRecords'));
    }

    public function getDonorHeadDetails($donorId)
    {
        $donor = DB::table('donors')
            ->where('donor_id', $donorId)
            ->first();

        $donorRecords = DB::table('donor_records as dr')
            ->leftJoin('incomes as i', 'dr.journal_id', '=', 'i.income_id')
            ->leftJoin('income_heads as ih', 'i.income_head', '=', 'ih.income_head_id')
            ->where('dr.donor_id', $donorId)
            ->where('i.organisation_id',  $this->currentOrgId->organisation_id)
            ->where(function ($query) {
                $query->whereNull('dr.journal_id')
                    ->orWhereNull('i.deleted_at');
            })
            ->orderBy('dr.created_at', 'asc')
            ->select(
                'dr.*',
                'i.transaction_date',
                'i.transaction_amount',
                'i.transaction_narration',
                'ih.income_head_name'
            )
            ->get();
        // return $donorRecords;
        return view('auth.ledgers.donor.detail', compact('donor', 'donorRecords'));
    }

    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
