<div class="card">
    <div class="card-header bg-light">
        <div class="row align-items-center">
            <div class="col">
                <h5 class="mb-0">All Students</h5>
            </div>
            <div class="col-md-10">
                <form method="GET" action="<?php echo e(route('students.index')); ?>" class="row g-2">

                    
                    <div class="col-md-4">
                        <select name="class_id"
                                id="class_id"
                                class="form-select form-select-sm">
                            <option value="">All Classes</option>
                            <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($class->id); ?>"
                                    <?php echo e(request('class_id') == $class->id ? 'selected' : ''); ?>>
                                    <?php echo e($class->class_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    
                    <div class="col-md-4">
                        <select name="section_id"
                                id="section_id"
                                class="form-select form-select-sm"
                                <?php echo e(request('class_id') ? '' : 'disabled'); ?>>
                            <option value="">All Sections</option>

                            
                            <?php if(request('class_id')): ?>
                                <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($section->id); ?>"
                                        <?php echo e(request('section_id') == $section->id ? 'selected' : ''); ?>>
                                        <?php echo e($section->section_name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                    </div>

                    
                    <div class="col-md-4">
                        <input type="search"
                            name="q"
                            value="<?php echo e(request('q')); ?>"
                            class="form-control form-control-sm"
                            placeholder="Search by name or admission #">
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Admission #</th>
                        <th>Name</th>
                        <th>Class</th>
                        <th>Section</th>
                        <th>Roll No</th>
                        <th>DOB</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>#<?php echo e($student->admission_no); ?></td>
                        <td><?php echo e($student->name); ?></td>
                        <td><?php echo e($student->activeClass->class->class_name); ?></td>
                        <td><?php echo e($student->activeClass->section->section_name); ?></td>
                        <td><?php echo e($student->activeClass->roll_no); ?></td>
                        <td><?php echo e($student->dob); ?></td>
                        <td>
                            <div class="form-check form-switch">
                                <input
                                    class="form-check-input student-status"
                                    type="checkbox"
                                    id="status_<?php echo e($student->id); ?>"
                                    data-id="<?php echo e($student->id); ?>"
                                    data-url="<?php echo e(route('students.update', $student->id)); ?>"
                                    <?php echo e($student->status ? 'checked' : ''); ?>

                                >
                            </div>
                        </td>
                        <td>
                            <a href="<?php echo e(route('students.edit', $student->id)); ?>" class="btn btn-sm btn-outline-secondary">Edit</a>
                            <a href="<?php echo e(route('students.show', $student->id)); ?>" class="btn btn-sm btn-outline-primary">View</a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center text-muted">
                                No student found for the current academic year
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <div class="mt-3">
            <?php echo e($students->links()); ?>

        </div>
    </div>
</div><?php /**PATH C:\xampp\htdocs\school\resources\views/students/list.blade.php ENDPATH**/ ?>