<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>@yield('title', 'School Management')</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/switchery/0.8.2/switchery.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <link rel="stylesheet" href="{{ asset('css/styles.css') }}">

</head>

<body>
    <div class="d-flex" id="app">
        <!-- Sidebar -->
        <nav class="sidebar bg-dark text-white">
            @include('partials.sidebar')
        </nav>

        <div class="main-content flex-grow-1">
            @include('partials.navbar')

            <div class="breadcrumb-container bg-light border-bottom px-4 py-2">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        @yield('breadcrumb')
                    </ol>
                </nav>
            </div>

            <div class="content-area p-4">
                @if (session('success'))
                    <div id="alert" class="alert alert-success">{{ session('success') }}</div>
                @endif

                @if (session('error'))
                    <div id="alert" class="alert alert-danger">{{ session('error') }}</div>
                @endif

                @yield('content')

                @include('partials.footer')
            </div>
        </div>
    </div>
    @yield('modal')
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/switchery/0.8.2/switchery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <!-- Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="{{ asset('js/script.js') }}"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const alert = document.getElementById('alert');
            if (alert) {
                setTimeout(() => {
                    alert.classList.add('fade');
                    alert.classList.remove('show');
                    alert.style.display = 'none';
                }, 3000); // 2 seconds
            }
        });
        
    </script>
    <script>
        $(document).ready(function () {

            $('.select2').select2({
                allowClear: true,
                width: '100%'
            });

            // $('.select2').select2({
            //     dropdownParent: $('#editClassFeeModal'), // or your modal id
            //     width: '100%'
            // });


        });
</script>


    @yield('script')
</body>

</html>
