<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StaffAcademicYear extends Model
{
    protected $table = 'staff_academic_years';

    protected $fillable = [
        'staff_id',
        'financial_year_id',
        'status',
    ];

    public function staff()
    {
        return $this->belongsTo(Staff::class);
    }

    public function financialYear()
    {
        return $this->belongsTo(AcademicYear::class, 'financial_year_id');
    }
}
