

<?php $__env->startSection('title', 'Students'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('students.index')); ?>">Students</a></li>
    <li class="breadcrumb-item active">Edit</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php
        // Get current active class detail
        $currentClass = $student->classDetails->first();
    ?>

    <div id="students-page" class="page-content">
        <h1 class="mb-4">Student Management</h1>

        <div class="card">
            <div class="card-header bg-light">
                <h5 class="mb-0">Edit Student</h5>
            </div>

            <div class="card-body">

                
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <strong>Please fix the following errors:</strong>
                        <ul class="mb-0">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form method="POST" action="<?php echo e(route('students.update', $student->id)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    
                    <h6 class="text-muted mb-3">Personal Information</h6>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label>Full Name *</label>
                            <input type="text" name="name"
                                placeholder="Enter student's full name"
                                value="<?php echo e(old('name', $student->name)); ?>"
                                class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Date of Birth *</label>
                            <input type="date" id="dob" name="dob"
                                placeholder="Select date of birth"
                                value="<?php echo e(old('dob', $student->dob)); ?>"
                                class="form-control" required>
                        </div>

                        <div class="col-md-6">
                            <label>Gender *</label>
                            <select name="gender" class="form-select" required>
                                <option value="">Select Gender</option>
                                <?php $__currentLoopData = ['MALE', 'FEMALE']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($g); ?>"
                                        <?php echo e(old('gender', strtoupper($student->gender)) == $g ? 'selected' : ''); ?>>
                                        <?php echo e($g); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Nationality</label>
                            <input type="text" name="nationality"
                                placeholder="e.g. Indian"
                                value="<?php echo e(old('nationality', $student->nationality)); ?>"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Tongue</label>
                            <input type="text" name="mother_tongue"
                                placeholder="e.g. Bengali, Hindi"
                                value="<?php echo e(old('mother_tongue', $student->mother_tongue)); ?>"
                                class="form-control">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Category *</label>
                            <select name="category" class="form-select" required>
                                <option value="">Select Category</option>
                                <?php $__currentLoopData = ['GEN', 'OBC', 'SC', 'ST']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($cat); ?>"
                                        <?php echo e(old('category', $student->category) == $cat ? 'selected' : ''); ?>>
                                        <?php echo e($cat); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label>Caste</label>
                            <input type="text" name="cast"
                                placeholder="Enter caste (if applicable)"
                                value="<?php echo e(old('cast', $student->cast)); ?>"
                                class="form-control">
                        </div>
                    </div>

                    
                    <h6 class="text-muted mt-4 mb-3">Address</h6>

                    <div class="mb-3">
                        <label>Permanent Address *</label>
                        <textarea name="address" rows="2"
                                placeholder="Enter permanent residential address"
                                class="form-control" required><?php echo e(old('address', $student->address)); ?></textarea>
                    </div>

                    <div class="mb-3">
                        <label>Local Address</label>
                        <textarea name="local_address" rows="2"
                                placeholder="Enter local address (if different)"
                                class="form-control"><?php echo e(old('local_address', $student->local_address)); ?></textarea>
                    </div>

                    
                    <h6 class="text-muted mt-4 mb-3">Additional Information</h6>

                    <div class="row mb-3">
                        <div class="col-md-4 form-check">
                            <input type="checkbox" name="belongs_to_minority_group" value="1" class="form-check-input"
                                <?php echo e(old('belongs_to_minority_group', $student->belongs_to_minority_group) ? 'checked' : ''); ?>>
                            <label class="form-check-label">Minority</label>
                        </div>

                        <div class="col-md-4 form-check">
                            <input type="checkbox" name="is_disability_ph" value="1" class="form-check-input"
                                <?php echo e(old('is_disability_ph', $student->is_disability_ph) ? 'checked' : ''); ?>>
                            <label class="form-check-label">Physically Handicapped</label>
                        </div>

                        <div class="col-md-4 form-check">
                            <input type="checkbox" name="is_transport_required" value="1" class="form-check-input"
                                <?php echo e(old('is_transport_required', $student->is_transport_required) ? 'checked' : ''); ?>>
                            <label class="form-check-label">Transport Required</label>
                        </div>
                    </div>

                    
                    <h6 class="text-muted mt-4 mb-3">Class Assignment</h6>

                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label>Class *</label>
                            <select name="class_id" id="class_id" class="form-select" required>
                                <option value="">Select Class</option>
                                <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($class->id); ?>"
                                        <?php echo e(old('class_id', $currentClass?->class_id) == $class->id ? 'selected' : ''); ?>>
                                        <?php echo e($class->class_name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label>Section *</label>
                            <select name="section_id" id="reg_section_id" class="form-select" required>
                                <option value="">Select Section</option>
                                <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($class->id == old('class_id', $currentClass?->class_id)): ?>
                                        <?php $__currentLoopData = $class->sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($section->id); ?>"
                                                <?php echo e(old('section_id', $currentClass?->section_id) == $section->id ? 'selected' : ''); ?>>
                                                <?php echo e($section->section_name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label>Admission Date *</label>
                            <input type="date" id="admission_date" name="admission_date"
                                placeholder="Select admission date"
                                value="<?php echo e(old('admission_date', $currentClass?->admission_date)); ?>"
                                class="form-control" required>
                        </div>
                    </div>

                    
                    <h6 class="text-muted mt-4 mb-3">Parent / Guardian Details</h6>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Name *</label>
                            <input type="text" name="father_name"
                                placeholder="Enter father's full name"
                                value="<?php echo e(old('father_name', $student->parent->father_name)); ?>"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Name *</label>
                            <input type="text" name="mother_name"
                                placeholder="Enter mother's full name"
                                value="<?php echo e(old('mother_name', $student->parent->mother_name)); ?>"
                                class="form-control">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Qualification</label>
                            <input type="text" name="father_qualification"
                                placeholder="e.g. Graduate, Diploma"
                                value="<?php echo e(old('father_qualification', $student->parent->father_qualification)); ?>"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Qualification</label>
                            <input type="text" name="mother_qualification"
                                placeholder="e.g. Graduate, Diploma"
                                value="<?php echo e(old('mother_qualification', $student->parent->mother_qualification)); ?>"
                                class="form-control">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Occupation</label>
                            <input type="text" name="father_occupation"
                                placeholder="Enter father's occupation"
                                value="<?php echo e(old('father_occupation', $student->parent->father_occupation)); ?>"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Occupation</label>
                            <input type="text" name="mother_occupation"
                                placeholder="Enter mother's occupation"
                                value="<?php echo e(old('mother_occupation', $student->parent->mother_occupation)); ?>"
                                class="form-control">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Father Phone *</label>
                            <input type="tel" name="father_phone"
                                placeholder="10 digit mobile number"
                                maxlength="10" pattern="[0-9]{10}"
                                value="<?php echo e(old('father_phone', $student->parent->father_phone)); ?>"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Mother Phone</label>
                            <input type="tel" name="mother_phone"
                                placeholder="10 digit mobile number"
                                maxlength="10" pattern="[0-9]{10}"
                                value="<?php echo e(old('mother_phone', $student->parent->mother_phone)); ?>"
                                class="form-control">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Guardian Name</label>
                            <input type="text" name="guardian_name"
                                placeholder="Enter guardian name"
                                value="<?php echo e(old('guardian_name', $student->parent->guardian_name)); ?>"
                                class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Guardian Phone</label>
                            <input type="tel" name="guardian_phone"
                                placeholder="10 digit mobile number"
                                maxlength="10" pattern="[0-9]{10}"
                                value="<?php echo e(old('guardian_phone', $student->parent->guardian_phone)); ?>"
                                class="form-control">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label>Guardian Address</label>
                        <textarea name="guardian_address" rows="2"
                                placeholder="Enter guardian address"
                                class="form-control"><?php echo e(old('guardian_address', $student->parent->guardian_address)); ?></textarea>
                    </div>

                    
                    <h6 class="text-muted mt-4 mb-3">Documents</h6>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Profile Photo</label>
                            <input type="file" name="profile_image" class="form-control" accept="image/*">
                            <small class="text-muted">Upload recent passport size photo</small>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">DOB Proof</label>
                            <input type="file" name="dob_photo_copy" class="form-control" accept="image/*,application/pdf">
                            <small class="text-muted">Birth certificate / Aadhaar / PDF</small>
                        </div>
                    </div>

                    <div class="d-flex gap-2 justify-content-end mt-3">
                        <button type="submit" class="btn btn-primary btn-sm">Update Student</button>
                        <a href="<?php echo e(route('students.index')); ?>" class="btn btn-secondary btn-sm">Cancel</a>
                    </div>

                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        const classes = <?php echo json_encode($classes, 15, 512) ?>;

        $(document).on('change', '#class_id', function () {

            const classId = $(this).val();
            let html = '<option value="">Select Section</option>';

            const selectedClass = classes.find(c => c.id == classId);

            if (selectedClass && selectedClass.sections) {
                selectedClass.sections.forEach(section => {
                    html += `<option value="${section.id}">${section.section_name}</option>`;
                });
            }

            const $section = $('#reg_section_id');

            console.log('Section element found:', $section.length);

            $section
                .prop('disabled', false)
                .html(html);
        });
    </script>

    <script>
        $(document).ready(function () {

            let today = new Date();

            // Max = today (disable future)
            let maxDate = today.toISOString().split('T')[0];

            // Min = today - 1 month
            let minDate = new Date(
                today.getFullYear(),
                today.getMonth() - 3,
                today.getDate()
            ).toISOString().split('T')[0];

            $('#admission_date').attr({
                min: minDate,
                max: maxDate
            });

            

            maxDate = new Date(
                today.getFullYear() - 2,
                today.getMonth(),
                today.getDate()
            ).toISOString().split('T')[0];

            $('#dob').attr('max', maxDate);

        });
    </script>
    <script>
        document.getElementById('dob_photo_copy').addEventListener('change', function (event) {

            let input   = event.target;
            let file    = input.files[0];
            let preview = document.getElementById('dobPreview');

            preview.innerHTML = ""; // clear old preview

            let dt = new DataTransfer(); // rebuild file list

            if (!file) return;

            // ✅ Allowed types
            let allowedTypes = [
                'image/jpeg',
                'image/png',
                'image/jpg',
                'image/webp',
                'image/gif',
                'application/pdf'
            ];

            if (!allowedTypes.includes(file.type)) {
                toastr.error("Only images and PDF files are allowed!", "Error");
                input.value = "";
                return;
            }

            // keep valid file
            dt.items.add(file);
            input.files = dt.files;

            // 🖼️ IMAGE PREVIEW
            if (file.type.startsWith('image/')) {

                let reader = new FileReader();
                reader.onload = function (e) {

                    let col = document.createElement('div');
                    col.classList.add('col-md-3', 'mb-3');

                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" 
                                class="card-img-top img-fluid"
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;

                    preview.appendChild(col);
                };

                reader.readAsDataURL(file);

            }
            // 📄 PDF PREVIEW (ICON + NAME)
            else if (file.type === 'application/pdf') {

                let col = document.createElement('div');
                col.classList.add('col-md-3', 'mb-3');

                col.innerHTML = `
                    <div class="card text-center p-3">
                        <i class="fa fa-file-pdf-o fa-3x text-danger mb-2"></i>
                        <p class="small">${file.name}</p>
                    </div>
                `;

                preview.appendChild(col);
            }

        });
        document.getElementById('profile_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = input.files[0];
            let preview = document.getElementById('profilePreview');
            // Clear old preview

            let dt = new DataTransfer(); // For rebuilding file list

            if (file && file.type.startsWith('image/')) {
                dt.items.add(file); // Keep valid file

                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-3', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = "";
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }

            // Replace with filtered file list (empty if invalid)
            input.files = dt.files;
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/school-ramkrishna/resources/views/students/edit.blade.php ENDPATH**/ ?>