
<div class="card mb-4">
    <div class="card-header bg-light">
        <div class="row align-items-center">
            <div class="d-flex gap-2">
                <div class="col">
                    <h5 class="mb-0">Search Transactions</h5>
                </div>
                <button 
                    type="button"
                    class="btn btn-outline-danger btn-sm"
                    data-bs-toggle="modal"
                    data-bs-target="#expenseModal"
                >
                    <i class="bi bi-plus-circle me-1"></i> Add Expense
                </button>
                <button
                    type="button"
                    class="btn btn-outline-primary btn-sm"
                    data-bs-toggle="modal"
                    data-bs-target="#incomeModal"
                >
                    <i class="bi bi-plus-circle me-1"></i> Add Income
                </button>

            </div>
        </div>
    </div>

    <div class="card-body">
        <form method="GET" action="<?php echo e(route('transactions.index')); ?>">
            <div class="row mb-3">

                
                <div class="col-md-2">
                    <select name="financial_year_id" class="form-select form-select-sm">
                        <?php $__currentLoopData = $academic_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($year->id); ?>"
                                <?php echo e(request('financial_year_id', $active_academic_year->id) == $year->id ? 'selected' : ''); ?>>
                                <?php echo e($year->label); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                
                <div class="col-md-2">
                    <input
                        type="month"
                        name="month"
                        class="form-control form-control-sm"
                        value="<?php echo e(request('month', now()->format('Y-m'))); ?>">
                </div>
                <div class="col-md-3">
                    <select name="type" class="form-select form-select-sm">
                        <option value="">Select Transaction Type</option>
                        <option value="income" <?php echo e(request('type') == 'income' ? 'selected' : ''); ?>>Income</option>
                        <option value="expense" <?php echo e(request('type') == 'expense' ? 'selected' : ''); ?>>Expense</option>
                    </select>
                </div>

                
                <div class="col-md-5">
                    <input
                        type="search"
                        name="q"
                        value="<?php echo e(request('q')); ?>"
                        class="form-control form-control-sm"
                        placeholder="Search by Ref.Transaction ID / Money Receipt No / Head Name">
                </div>
            </div>

            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary btn-sm">
                    Search
                </button>

                <a href="<?php echo e(route('transactions.index')); ?>"
                   class="btn btn-outline-secondary btn-sm">
                    Clear Filter
                </a>
            </div>
        </form>
    </div>
</div>


<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Transaction History</h5>
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead>
                    <tr>
                        <th title="Income / Expense Head">Income / Expense Head</th>
                        <th title="Transaction Type">Transactions Type</th>
                        <th title="Transaction ID">Ref. Transactions ID/Money Receipt No.</th>
                        <th title="Payment Amount">Amount</th>
                        <th title="Payment Method">Payment Method</th>
                        <th title="Payment Date">Payment Date</th>
                        <th title="Actions">Actions</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="<?php echo e($t->type === 'income' ? 'table-success' : 'table-danger'); ?>">
                            <td>
                                <?php echo e($t->type === 'income'
                                    ? ($t->income_head_name ?? '—')
                                    : ($t->expense_head_name ?? '—')); ?>

                            </td>
                            <td><?php echo e(ucfirst($t->type)); ?></td>
                            <td><?php echo e($t->transaction_ref_id); ?></td>
                            <td><?php echo e(number_format($t->transaction_amount, 2)); ?></td>
                            <td><?php echo e(ucfirst($t->payment_method)); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($t->transaction_date)->format('d M Y')); ?></td>
                            <td>
                                <button
                                    class="mt-1 btn btn-outline-secondary btn-sm view-transaction"
                                    data-url="<?php echo e(route('transactions.show', ['type' => $t->type, 'id' => $t->id])); ?>">
                                    View
                                </button>
                                <?php if( ($t->type === 'income' &&  $t->income_head_id != 1 ) || ($t->type === 'expense' &&  $t->expense_head_id != 1 )  ): ?>
                                <button
                                    class="mt-1 btn btn-sm btn-outline-primary edit-transaction"
                                    data-id="<?php echo e($t->id); ?>"
                                    data-type="<?php echo e($t->type); ?>"
                                    data-edit-url="<?php echo e(route('transactions.edit', [$t->type, $t->id])); ?>">
                                    Edit
                                </button>

                                <button
                                    class="mt-1 btn btn-sm btn-outline-danger  delete-transaction"
                                    data-url="<?php echo e(route('transactions.destroy', ['type' => $t->type, 'id' => $t->id])); ?>">
                                    Delete
                                </button>

                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted">
                                No Transactions Found
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        
        <div class="mt-3">
            <?php echo e($transactions->appends(request()->query())->links('pagination::bootstrap-5')); ?>

        </div>
    </div>
</div>
<?php /**PATH /var/www/html/school-ramkrishna/resources/views/transactions/list.blade.php ENDPATH**/ ?>