@extends('layouts.app')

@section('title','Staff')

@section('breadcrumb')
<li class="breadcrumb-item active">Staff</li>
@endsection

@section('content')
<!-- Staff Management Page -->
    <div id="staff-page" class="page-content">
        <h1 class="mb-4">Staff Management</h1>
        <ul class="nav nav-tabs mb-4" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active c-tab" id="list" data-bs-toggle="tab" data-bs-target="#staff-list" type="button" role="tab">Staff List</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link c-tab"  id="add_staff" data-bs-toggle="tab" data-bs-target="#add-staff" type="button" role="tab">Add Staff</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link c-tab" id="salary" data-bs-toggle="tab" data-bs-target="#salary-management" type="button" role="tab">Salary Management</button>
            </li>
        </ul>

        <div class="tab-content">
            <div class="tab-pane fade show active"
                id="staff-list" role="tabpanel">
                @include('staff.list')
            </div>

            <div class="tab-pane fade"
                id="add-staff" role="tabpanel">
                @include('staff.create')
            </div>

            <div class="tab-pane fade"
                id="salary-management" role="tabpanel">
                @include('staff.salary')
            </div>
        </div>

    </div>
@endsection

@section('script')

<script>
    $(document).ready(function () {

        /* ================= STAFF STATUS TOGGLE ================= */
        $(document).on('change', '.staff-status', function () {
            let checkbox = $(this);
            let status = checkbox.prop('checked') ? 1 : 0;

            $.ajax({
                type: "PUT",
                dataType: "json",
                url: checkbox.data('url'),
                data: {
                    _token: "{{ csrf_token() }}",
                    status: status
                },
                success: function (data) {
                    Swal.fire('Success', data.message, 'success');
                },
                error: function () {
                    Swal.fire('Error', 'Something went wrong', 'error');
                    checkbox.prop('checked', !checkbox.prop('checked'));
                }
            });
        });

        /* ================= SEARCH ESC KEY ================= */
        const nameInput = document.querySelector('input[name="name"]');
        const form = nameInput?.closest('form');

        toastr.options = {
            closeButton: true,
            progressBar: true,
            positionClass: "toast-top-right",
            timeOut: "3000",
            extendedTimeOut: "1000",
            showDuration: "300",
            hideDuration: "300",
            showMethod: "fadeIn",
            hideMethod: "fadeOut"
        };

        if (nameInput) {

            /* ESC → Back to staff list */
            nameInput.addEventListener('keydown', function (e) {
                if (e.key === 'Escape') {
                    window.location.href = "{{ route('staff.index') }}";
                }

                /* ❌ Prevent space as first character */
                if (e.key === ' ' && this.value.length === 0) {
                    e.preventDefault();
                }
            });

            /* ❌ Prevent only-space input */
            nameInput.addEventListener('input', function () {
                // Replace multiple spaces with single space
                this.value = this.value.replace(/\s{2,}/g, ' ');
            });
        }

        /* ❌ BLOCK SUBMIT IF NAME IS BLANK AFTER TRIM */
        if (form) {
            form.addEventListener('submit', function (e) {
                if (nameInput) {
                    nameInput.value = nameInput.value.trim();

                    if (nameInput.value === '') {
                        e.preventDefault();
                        //alert('Name cannot be blank or spaces only');
                        toastr.error(
                            'Name cannot be blank or spaces only',
                            'Error'
                        );
                        nameInput.focus();
                    }
                }
            });
        }

        /* ================= CATEGORY AUTO SUBMIT ================= */
        const categorySelect = document.getElementById('category_id');
        if (categorySelect) {
            categorySelect.addEventListener('change', function () {
                this.form.submit();
            });
        }

    });
</script>

<script>
    $(document).on('click', '.pay-btn', function () {

        let form = $(this).closest('.pay-form');

        Swal.fire({
            title: 'Confirm Salary Payment',
            text: 'Are you sure you want to pay salary for this month?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Pay',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });

    });

    $(document).on('click', '.bluk-pay-form', function (e) {
        e.preventDefault();
        let form = $(this).closest('.bluk-pay-form');

        Swal.fire({
            title: 'Confirm Salary Payment',
            text: 'Are you sure you want to pay salary for this month?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Pay',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });

    });
</script>

<script>
    function formatCurrency(el) {
        let value = el.value;

        // Remove invalid characters
        value = value.replace(/[^0-9.]/g, '');

        // Prevent multiple dots
        const parts = value.split('.');
        if (parts.length > 2) {
            value = parts[0] + '.' + parts[1];
        }

        let [intPart, decPart] = value.split('.');

        // Limit integer part to 8 digits (DECIMAL 10,2)
        if (intPart.length > 8) {
            intPart = intPart.slice(0, 8);
        }

        // Limit decimal to 2 digits
        if (decPart !== undefined) {
            decPart = decPart.slice(0, 2);
        }

        // Add thousand separators
        intPart = intPart.replace(/\B(?=(\d{3})+(?!\d))/g, ',');

        el.value = decPart !== undefined
            ? `${intPart}.${decPart}`
            : intPart;
    }

    function preventInvalidPaste(e, el) {
        e.preventDefault();

        let paste = (e.clipboardData || window.clipboardData).getData('text');
        paste = paste.replace(/[^0-9.]/g, '');

        if (!paste) return false;

        el.value = paste;
        formatCurrency(el);
        return false;
    }
</script>

<script>
    $(document).ready(function () {

        let today = new Date();

        // Max = today (disable future)
        let maxDate = today.toISOString().split('T')[0];

        // Min = today - 1 month
        let minDate = new Date(
            today.getFullYear(),
            today.getMonth() - 3,
            today.getDate()
        ).toISOString().split('T')[0];

        $('#join_date').attr({
            min: minDate,
            max: maxDate
        });



        document.getElementById('profile_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = input.files[0];
            let preview = document.getElementById('profilePreview');
            // Clear old preview

            let dt = new DataTransfer(); // For rebuilding file list

            if (file && file.type.startsWith('image/')) {
                dt.items.add(file); // Keep valid file

                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-3', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = "";
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }

            // Replace with filtered file list (empty if invalid)
            input.files = dt.files;
        });

        

    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {

        const urlParams = new URLSearchParams(window.location.search);
        const tab = urlParams.get('tab') || 'list';

        const tabMap = {
            list: 'list',
            add_staff: 'add_staff',
            salary: 'salary'
        };

        if (tabMap[tab]) {
            const triggerEl = document.getElementById(tabMap[tab]);
            if (triggerEl) {
                new bootstrap.Tab(triggerEl).show();
            }
        }
    });
</script>






@endsection

