<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TransactionExpense extends Model
{
    protected $table = 'transaction_expense';

    protected $fillable = [
        'transaction_id',
        'transaction_ref_id',
        'financial_year_id',
        'transaction_amount',
        'transaction_date',
        'transaction_details',
        'payment_method',
        'expense_head_id',
        'transaction_reference_photo',
        'source_type',   // staff / vendor
        'source_id',
        'source_name'
    ];

    public function staff()
    {
        return $this->belongsTo(Staff::class, 'source_id');
    }

    public function vendor()
    {
        return $this->belongsTo(Vendor::class, 'source_id');
    }

    public function expenseHead()
    {
        return $this->belongsTo(ExpenseHead::class, 'expense_head_id');
    }

    public function financialYear()
    {
        return $this->belongsTo(AcademicYear::class, 'financial_year_id');
    }
}

