<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StaffSalary extends Model
{
    protected $table = 'staff_salary';

    protected $fillable = [
        'staff_id',

        // Earnings
        'basic',
        'hra',
        'da',
        'ta',
        'medical_allowance',
        'conveyance',
        'washing_allowance',
        'special_allowance',
        'total_earnings',

        // Deductions
        'pf',
        'esi',
        'p_tax',
        'tds',
        'others_deduction',
        'total_deductions',

        // Net & Employer
        'net_salary',
        'employer_pf',
        'employer_esi',
        'ctc',

        'financial_year_id',
        'status',
    ];

    public function staff()
    {
        return $this->belongsTo(Staff::class);
    }

    public function financialYear()
    {
        return $this->belongsTo(AcademicYear::class, 'financial_year_id');
    }
}
