<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    use HasFactory;

    protected $primaryKey = 'project_id';

    protected $fillable = [
        'project_name',
        'project_manager_id',
        'project_TL_id',
        'project_type',
        'project_type_note',
        'client_name',
        'description',
        'technology',
        'assigned_employee',
        'start_date',
        'end_date',
        'status',
        'total_resource_cost',
        'operational_cost',
        'pm_cost',
        'profit_margin',
        'marketing_cost',
        'sales_cost',
        'total_project_cost',
        'billing_type',
        'other_costs',
    ];


    public function teamLead()
    {
        return $this->belongsTo(User::class, 'project_TL_id', 'id');
    }
    public function projectManager()
    {
        return $this->belongsTo(User::class, 'project_manager_id', 'id');
    }
    public function billingModules()
    {
        return $this->hasMany(ProjectBillingModule::class, 'project_id', 'project_id');
    }
    public function resources()
    {
        return $this->hasMany(ProjectResourceMapping::class, 'project_id', 'project_id');
    }
}
