

<?php $__env->startSection('content'); ?>
<main class="content">
  <div class="g-color"></div>
  <div class="table-header position-relative">
    <div class="row justify-content-between">
      <form class="mt-5" action="<?php echo e(route('tanksummary')); ?>" method="post">
        <?php echo csrf_field(); ?>
        <div class="col-md-12">
          <ul class="d-flex align-items-center p-0">
            <li class="">
              <div class="d-flex align-items-center position-relative"><b class="me-3">Date Range:</b>
                <input class="form-control w-50" value="<?php if ($fdate == "") {
                                                          echo "";
                                                        } else {
                                                          echo date('d-m-Y', strtotime($fdate));
                                                        } ?>" name="fromdate" id="device_purchased_on" type="text" autocomplete="off">
              </div>
            </li>
            <li class="">
              <div class="d-flex align-items-center position-relative"><b class="me-2">To :</b>
                <input class="form-control w-75" type="text" value="<?php if ($fdate == "") {
                                                                      echo "";
                                                                    } else {
                                                                      echo date('d-m-Y', strtotime($tdate));
                                                                    } ?>" id="device_purchased_on1" name="todate" autocomplete="off">
              </div>
            </li>
            <li class="">
              <div class="d-flex align-items-center position-relative"><b class="me-3">Select Tank:</b>
                <select class="form-select w-75" name="tank_list" id="tank_list" aria-label="Default select example">
                  <option value="">Select Tank</option>
                  <?php $__currentLoopData = $tanks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($tank->tank_uid); ?>" <?php if($tank_uid==$tank->tank_uid): ?><?php echo e('selected'); ?> <?php endif; ?> ><?php echo e($tank->tank_name.'('.$tank->tank_uid.')'); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <input type="hidden" name="sval" value="1" />
              </div>
            </li>
            <li class="">
              <div class="btn-sec m-2">
                <button type="submit" class="btn btn-primary" onClick="return validation();">Submit</button>
              </div>
            </li>
          </ul>
        </div>
      </form>
    </div>
  </div>
  <div class="position-relative">
    <div class="container-sec">
      <div class="cotainer-body p-4">
        <?php if($tank_uid != ''): ?>
        <div class="page-hading">
          <div class="d-flex align-items-center position-relative">
            <h2 class="mt-3 mb-3 align-items-center d-flex"> Daily Summary Of Tank Data</h2>
            <div class="detasheet-graph-icon ms-auto">
              <a href="#" class="active">Datasheet</a>
              <a href="<?php echo e(route('dailytankchart',$enc_data)); ?>" class="">Graph</a>
            </div>
            <form method="get" action="<?php echo e(route('dailysummaryexcel',$enc_data)); ?>">
              <button class="btn download-btn ms-2"><i class="ri-folder-download-fill"></i> Download
              </button>
            </form>
          </div>
        </div>
        <div class="tank-wise-sec">

          <div class="row">
            <div class="table-ar">
              <table class="table table-striped table-bordered">
                <thead>
                  <tr>
                    <th scope="col" style="text-align: left;">Time </th>
                    <th scope="col">pH </th>
                    <th scope="col">Turbidity (NTU)</th>
                    <th scope="col">Chlorine (mg/L)</th>
                    <th scope="col">TDS (mg/L)</th>
                    <th scope="col">Water Level (mtr) </th>
                    <th scope="col">Iron Level (mg/L) </th>

                  </tr>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $readings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reading): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td style="text-align: left;"><?php echo e(\Carbon\Carbon::parse($reading->read_date)->format('d-m-Y'). \Carbon\Carbon::createFromTime($reading->read_hour)->format(' g A')); ?></td>
                    <td><?php echo number_format((float)($reading->phval), 2); ?></td>
                    <td><?php echo number_format((float)($reading->turval), 2); ?></td>
                    <td><?php echo number_format((float)($reading->clval), 2); ?></td>
                    <td><?php echo number_format((float)($reading->tdsval), 2); ?></td>
                    <td><?php echo number_format((float)($reading->wtrval), 2); ?></td>
                    <td><?php echo number_format((float)($reading->oprval), 2); ?></td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </tbody>
              </table>
            </div>
          </div>

        </div>
        <?php else: ?>
        <div class="page-hading">
          <div class="d-flex align-items-center justify-content-between">
            <div class="d-flex align-items-center position-relative">
              <!--<a href="<?php echo e(route('tankdetails')); ?>" class="d-flex align-items-center me-4 mb-0">
                                <i class="ri-arrow-left-line"></i>Tank 1
                            </a>
                            <div class="detasheet-graph-icon">
                                <a href="#" class="active">Datasheet</a>
                                <a href="<?php echo e(route('tankchart', $tank_uid)); ?>"
                                    class="">Graph</a>
                            </div>-->
              <div align="center">
                <h2>Please Select Date and Tank To Generate Report</h2>
              </div>
            </div>
          </div>
        </div>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <!-- <footer class="footer">
          <small style="margin-bottom: 20px; display: inline-block">
            © 2022 made with
            <span style="color: red; font-size: 18px">&#10084;</span> by -
            <a target="_blank" href="#"> Mohamed Azouaoui </a>
          </small>
          <br />
          <div>
            <a href="#" target="_blank" rel="noopener noreferrer">
              <img alt="GitHub followers" src="#" />
            </a>
            <a href="#" target="_blank" rel="noopener noreferrer">
              <img alt="Twitter Follow" src="#" />
            </a>
          </div>
        </footer> -->
</main>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
  $(function() {
    $("#device_purchased_on").datepicker({
      dateFormat: 'dd-mm-yy' // Example format
    });
  });

  $(function() {
    $("#device_purchased_on1").datepicker({
      dateFormat: 'dd-mm-yy' // Example format
    });
  });
</script>
<?php $__env->stopPush(); ?>

<script>
  function validation() {
    if (document.getElementById('device_purchased_on').value == "") {
      $('#error-fdt').html('* From Date Is Required');
      $('#error-fdt').css('color', 'red');
      $('#device_purchased_on').focus();
      return false;
    }
    if (document.getElementById('device_purchased_on1').value == "") {
      $('#error-tdt').html('* To Date Is Required');
      $('#error-tdt').css('color', 'red');
      $('#device_purchased_on1').focus();
      return false;
    }

    if (document.getElementById('tank_list').value == "") {
      $('#error-tl').html('* Select A Tank');
      $('#error-tl').css('color', 'red');
      $('#tank_list').focus();
      return false;
    }

    return true;
  }
</script>
</body>

</html>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/asansolphe/dev/resources/views/report/dailytankdata.blade.php ENDPATH**/ ?>