@extends('layouts.main')

@section('content')
<main class="content">
    <div class="g-color"></div>
    <div class="position-relative">
        <div class="container-sec">
            <div class="cotainer-body p-4">
                <div class="page-hading">
                    <a href="#" class="d-flex align-items-center">
                        <i class="ri-arrow-left-line"></i> Add New User
                    </a>
                </div>
                <div class="add-user">
                    <form class="mt-5" action="{{ route('users.store') }}" method="POST" id="userForm">
                        @csrf
                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label" for="name"><b>Name</b></label>
                                    <input type="text" id="name" name="name" class="form-control" required maxlength="255" pattern="[A-Za-z\s]+" title="Please enter only letters and spaces">
                                    @error('name')
                                    <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label" for="email"><b>Email</b></label>
                                    <input type="email" id="email" name="email" class="form-control" required>
                                    @error('email')
                                    <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
							<?php 
								$userId = auth('web')->user()->id;
								$user = DB::table('users')->where('id', $userId)->first();
								$current_role = $user->role_id;
							?>
                                <div class="mb-3">
                                    <label class="form-label" for="role"><b>Role</b></label>
                                    <select id="role" name="roles" class="form-control">
                                        <option value="">Select Role</option>
                                         <?php if($current_role == 0){ ?><option value="AE">AE</option><?php } ?>
                                         <?php if($current_role == 0 || $current_role == 2){ ?><option value="JE">JE</option><?php } ?>
                                         <?php if($current_role == 0 || $current_role == 2 || $current_role == 3){ ?><option value="PO">PO</option><?php } ?>
                                    </select>
                                    @error('role')
                                    <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="password"><b>Password</b></label>
                                    <input type="password" id="password" name="password" class="form-control" required>
                                    @error('password')
                                    <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="password_confirmation"><b>Confirm Password</b></label>
                                    <input type="password" id="password_confirmation" name="confirm-password" class="form-control" required>
                                </div>
                            </div>
                        </div>
						<div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <strong>Tank List:</strong>
                                    <br />
                                    @foreach($tanks as $row)
                                    <label><input type="checkbox" name="tank_ids[]" value="{{$row->id}}" class="name">
                                        {{ $row->tank_name }}</label>
                                    <br />
                                    @endforeach
                                </div>
                            </div>                            
                        </div>
                        <div class="row p-5">
                            <div class="btn-footer">
                                <div class="btn-sec m-2">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</main>

@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/jquery.validation/1.19.3/jquery.validate.min.js"></script>

<script>
    $(document).ready(function() {
        $('#userForm').validate({
            rules: {
                name: {
                    required: true,
                    maxlength: 255
                },
                email: {
                    required: true,
                    email: true
                },
                password: {
                    required: true,
                    minlength: 8
                },
                password_confirmation: {
                    required: true,
                    equalTo: "#password"
                },
                role: {
                    required: true
                }
            },
            messages: {
                name: {
                    required: "Please enter your name",
                    maxlength: "Name cannot exceed 255 characters"
                },
                email: {
                    required: "Please enter your email",
                    email: "Please enter a valid email address"
                },
                password: {
                    required: "Please provide a password",
                    minlength: "Your password must be at least 8 characters long"
                },
                password_confirmation: {
                    required: "Please confirm your password",
                    equalTo: "Passwords do not match"
                },
                role: {
                    required: "Please select a role"
                }
            },
            errorElement: 'div',
            errorPlacement: function(error, element) {
                error.addClass('text-danger'); // Add custom styling to error messages
                error.insertAfter(element);
            }
        });
    });
</script>