@extends('layouts.main')

@section('content')
<main class="content">
        <div class="g-color"></div>
        <div class="position-relative">
          <div class="container-sec">
            <div class="cotainer-body p-4">
              <div class="page-hading">
                <a href="#" class="d-flex align-items-center">
                  <i class="ri-arrow-left-line"></i> Tank Data Graph
                </a>
              </div>
              <div class="add-tank">
                <div class="row">
                    <div class="col-md-6">
                      <div id="container"></div>
                    </div>
					
                    <div class="col-md-6">
                      <div id="container1"></div>
                    </div>
                    
                  </div>
				  
				<div class="row">
                    <div class="col-md-6">
                      <div id="container2"></div>
                    </div>
					
                    <div class="col-md-6">
                      <div id="container3"></div>
                    </div>
                    
                  </div>
				  
				<div class="row">
                    <div class="col-md-6">
                      <div id="container4"></div>
                    </div>
					
                    <div class="col-md-6">
                      <div id="container5"></div>
                    </div>
                    
                  </div>                

              </div>
            </div>
          </div>
        </div>

        
      </main>

@endsection	 

<script src="https://code.highcharts.com/highcharts.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    var chart = Highcharts.chart('container', {
        chart: {
            type: 'column'  // Use 'column' for vertical bars
        },
        title: {
            text: 'pH Levels'
        },
        xAxis: {
            type: 'datetime',  // X-axis is time-based
            title: {
                text: 'Time'
            }
        },
        yAxis: {
            title: {
                text: 'pH Value'
            }
        },
        series: [{
            name: 'pH',
            data: [
                @foreach($phdata as $point)
                    [{{ strtotime($point->time_column) * 1000 }}, {{ $point->ph_value_column }}],
                @endforeach
            ],
			color: '#71f093'
        }]
    });
});

document.addEventListener('DOMContentLoaded', function () {
    var chart = Highcharts.chart('container1', {
        chart: {
            type: 'column'  // Use 'column' for vertical bars
        },
        title: {
            text: 'OPR Levels'
        },
        xAxis: {
            type: 'datetime',  // X-axis is time-based
            title: {
                text: 'Time'
            }
        },
        yAxis: {
            title: {
                text: 'OPR Value'
            }
        },
        series: [{
            name: 'OPR',
            data: [
                @foreach($oprdata as $point)
                    [{{ strtotime($point->time_column) * 1000 }}, {{ $point->opr_value_column }}],
                @endforeach
            ],
			color: '#71a880'
        }]
    });
});

document.addEventListener('DOMContentLoaded', function () {
    var chart = Highcharts.chart('container2', {
        chart: {
            type: 'column'  // Use 'column' for vertical bars
        },
        title: {
            text: 'Chlorine Levels'
        },
        xAxis: {
            type: 'datetime',  // X-axis is time-based
            title: {
                text: 'Time'
            }
        },
        yAxis: {
            title: {
                text: 'Chlorine Value'
            }
        },
        series: [{
            name: 'Chlorine',
            data: [
                @foreach($chlrndata as $point)
                    [{{ strtotime($point->time_column) * 1000 }}, {{ $point->chlrn_value_column }}],
                @endforeach
            ],
			color: '#b8dbc2'
        }]
    });
});

document.addEventListener('DOMContentLoaded', function () {
    var chart = Highcharts.chart('container3', {
        chart: {
            type: 'column'  // Use 'column' for vertical bars
        },
        title: {
            text: 'TDS Levels'
        },
        xAxis: {
            type: 'datetime',  // X-axis is time-based
            title: {
                text: 'Time'
            }
        },
        yAxis: {
            title: {
                text: 'TDS Value'
            }
        },
        series: [{
            name: 'TDS',
            data: [
                @foreach($tdsdata as $point)
                    [{{ strtotime($point->time_column) * 1000 }}, {{ $point->tds_value_column }}],
                @endforeach
            ],
			color: '#706e10'
        }]
    });
});

document.addEventListener('DOMContentLoaded', function () {
    var chart = Highcharts.chart('container4', {
        chart: {
            type: 'column'  // Use 'column' for vertical bars
        },
        title: {
            text: 'Turbudity Levels'
        },
        xAxis: {
            type: 'datetime',  // X-axis is time-based
            title: {
                text: 'Time'
            }
        },
        yAxis: {
            title: {
                text: 'Turbudity Value'
            }
        },
        series: [{
            name: 'Turbudity',
            data: [
                @foreach($turdata as $point)
                    [{{ strtotime($point->time_column) * 1000 }}, {{ $point->tur_value_column }}],
                @endforeach
            ],
			color: '#1e118f'
        }]
    });
});

document.addEventListener('DOMContentLoaded', function () {
    var chart = Highcharts.chart('container5', {
        chart: {
            type: 'column'  // Use 'column' for vertical bars
        },
        title: {
            text: 'Water Levels'
        },
        xAxis: {
            type: 'datetime',  // X-axis is time-based
            title: {
                text: 'Time'
            }
        },
        yAxis: {
            title: {
                text: 'Water Value'
            }
        },
        series: [{
            name: 'Water Levels',
            data: [
                @foreach($water_lvldata as $point)
                    [{{ strtotime($point->time_column) * 1000 }}, {{ $point->water_lvl_value_column }}],
                @endforeach
            ]
        }]
    });
});
</script>