@extends('layouts.main')

@section('content')
<main class="content">
    <div class="g-color"></div>
    <div class="table-header position-relative">
        <!-- <div class="row justify-content-between ">
            <div class="col-md-4">
                <ul class="row align-items-center p-0">
                    <li class="col"><b>Date :</b>04/09/2024</li>
                    <li class="col"><b>Last Phased :</b>12:00 PM</li>
                    <li class="col-6">
                        <div class="d-flex align-items-center position-relative"><b class="me-2">Search Tank :</b>
                            <div class="serach-ar d-flex align-items-center">
                                <input class="form-control" type="search" placeholder="Search" aria-label="Search">
                                <button class="search-icon" type="submit"><i class="ri-search-2-line"></i></button>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div> -->
        <div class="row justify-content-between">
            <form class="mt-5" action="{{ route('tankDateReport') }}" method="post">
                @csrf
                <div class="col-md-12">
                    <ul class="d-flex align-items-center p-0">
                        <li class="">
                            <div class="d-flex align-items-center position-relative"><b class="me-3">Date From:</b>
                                <input class="form-control w-50" type="text" name="fromdate" id="device_purchased_on" autocomplete="off">
                            </div>
                        </li>
                        <li class="">
                            <div class="d-flex align-items-center position-relative"><b class="me-2">To :</b>
                                <input class="form-control w-75" type="text" name="todate" id="device_purchased_on1" autocomplete="off">
                            </div>
                        </li>
                        <li>
                            <div class="d-flex align-items-center position-relative"><b class="me-2">Search By :</b>
                                <select class="form-select" name="view_by" id="view_by"
                                    aria-label="Default select example">
                                    <option value="">Select View Type</option>
                                    <option value="1">Tank Wise</option>
                                    <option value="2">KPI Wise</option>
                                </select>
                            </div>
                        </li>
                        <li style="padding-left:40px;">

                            <div class="align-items-center position-relative" id="tank_wise" style="display: none;"><b
                                    class="me-2">Tank List :</b>
                                <select class="form-select" name="tank_list" id="tank_list"
                                    aria-label="Default select example">
                                    <option value="">Select Tank</option>
                                    @foreach ($tanks as $tank)
                                    <option value="{{ $tank->tank_uid }}">
                                        {{ $tank->tank_name.'('.$tank->tank_uid.')' }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="align-items-center position-relative" id="KPI_wise" style="display: none;"><b
                                    class="me-2">Parameter Type :</b>
                                <select class="form-select" name="device_type_id" id="device_type_id"
                                    aria-label="Default select example">
                                    <option value="">Select Parameter Type</option>
                                    <option value="chlrn">CL Sensor</option>
                                    <option value="ph">PH Sensor</option>
                                    <option value="opr">ORP Sensor</option>
                                    <option value="tds">TDS Sensor</option>
                                    <option value="tur">Turbidity Sensor</option>
                                    <!-- <option value="6">Temperature Sensor</option>-->
                                    <option value="water_lvl">Water Sensor</option>
                                </select>
                            </div>
                        </li>
                        <li>
                            <div class="d-flex align-items-center position-relative"><b class="me-2"></b>
                                <button type="submit" class="btn btn-primary"
                                    onClick="return validation();">Submit</button>
                            </div>
                        </li>
                    </ul>
                </div>

            </form>
        </div>
    </div>
    <div class="position-relative">
        <div class="container-sec">
            <div class="cotainer-body p-4">
                <div class="page-hading">
                    <div class="d-flex align-items-center position-relative">

                    </div>
                </div>

                <!--<div class="tank-wise-sec">
                    <div align="center"><h2>Please Select Date and Tank To Generate Report</h2></div>                    
                </div>-->
                <div class="add-tank">
                    <div class="row">
                        <div class="col-md-12">
                            <div id="container88">
                                <div align="center">
                                    <h2>Please Select Date and Tank To Generate Report</h2>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row row-spacing">
                        <div class="col-md-12">&nbsp;</div>
                    </div>
                </div>
            </div>
        </div>
    </div>


</main>
@endsection
@push('scripts')
 <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css"> 
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
        $(function() {
            // Initialize datepickers with format dd-mm-yy
            $('#device_purchased_on, #device_purchased_on1').datepicker({
                dateFormat: 'dd-mm-yy'
            });

            // Event handler for fromdate selection
            $('#device_purchased_on').on('change', function() {
                var fromDate = $(this).datepicker('getDate');

                // Set maxDate on todate (fromDate + 7 days)
                if (fromDate) {
                    var maxDate = new Date(fromDate);
                    maxDate.setDate(maxDate.getDate() + 29);

                    $('#device_purchased_on').datepicker('option', 'minDate', fromDate);
                    $('#device_purchased_on1').datepicker('option', 'maxDate', maxDate);
                }
            });

            // Event handler for todate selection
            $('#device_purchased_on1').on('change', function() {
                var fromDate = $('#fromdate').datepicker('getDate');
                var toDate = $(this).datepicker('getDate');

                if (fromDate && toDate) {
                    var diffDays = (toDate - fromDate) / (1000 * 60 * 60 * 24); // Difference in days

                    if (diffDays > 29) {
                        alert('The date range cannot exceed 15 days.');
                        $(this).val(''); // Reset todate value
                    }
                }
            });
        });
    </script>

@endpush
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Get the elements
    var viewBy = document.getElementById('view_by');
    var tankWiseDiv = document.getElementById('tank_wise');
    var KPIWiseDiv = document.getElementById('KPI_wise');

    // Add event listener to the select element
    viewBy.addEventListener('change', function() {
        var selectedValue = this.value;

        // Reset both divs to hidden initially
        tankWiseDiv.style.display = 'none';
        KPIWiseDiv.style.display = 'none';

        // Show the relevant div based on the selected option
        if (selectedValue === '1') {
            tankWiseDiv.style.display = 'block'; // Show Tank Wise div
        } else if (selectedValue === '2') {
            KPIWiseDiv.style.display = 'block'; // Show KPI Wise div
        }
    });
});
</script>
</body>

</html>