@extends('layouts.main')

@section('content')
<main class="content">
        <div class="g-color"></div>
        <div class="position-relative">
          <div class="container-sec">
            <div class="cotainer-body p-4">
              <div class="page-hading">
                <a href="#" class="d-flex align-items-center">
                  <i class="ri-arrow-left-line"></i> Add Device Mapping (Tank and Sensor)
                </a>
              </div>
              <div class="add-tank">
                <form class="mt-5" action="{{ route('store_mapping') }}" method="post">
				@csrf
                  <div class="row">
                    <div class="col-md-6">
                      <div class="mb-3">
                        <label class="form-label"><b>Tank Name</b></label>
						<select class="form-select" name="tank_id" id="tank_id">
                          <option value="">Select Tank</option>
						  @foreach ($tanks as $tank)						  
                          <option value="{{ $tank->id }}">{{ $tank->tank_name }}</option>
                          @endforeach
                        </select>
						<div id='error-tank' style="color: red;"></div>
                      </div>
                    </div>					
                  </div>
				  <div class="row">				
                    <div class="col-md-3">
                      <div class="mb-3">
                        <label class="form-label"><b>PH Sensor</b></label>
						<select class="form-select" name="ph_sensor" id="ph_sensor">
                          <option value="">Select Device</option>
                           @foreach ($phdevice as $phd)						  
                          <option value="{{ $phd->id }}">{{ $phd->device_uid.' ('.$phd->device_brand.')' }}</option>
                          @endforeach
                        </select>
						<div id='error-device' style="color: red;"></div>
                      </div>
                    </div>
					<div class="col-md-3">
                      <div class="mb-3">
                        <label class="form-label"><b>TDS Sensor</b></label>
						<select class="form-select" name="tds_sensor" id="tds_sensor">
                          <option value="">Select Device</option>
                           @foreach ($tdsdevice as $tdsd)
						  <option value="{{ $tdsd->id }}">{{ $tdsd->device_uid.' ('.$tdsd->device_brand.')' }}</option>
                          @endforeach
                        </select>
						<div id='error-device' style="color: red;"></div>
                      </div>
                    </div>
					<div class="col-md-3">
                      <div class="mb-3">
                        <label class="form-label"><b>Turbidity Sensor</b></label>
						<select class="form-select" name="turbidity_sensor" id="turbidity_sensor">
                          <option value="">Select Device</option>
                           @foreach ($turbiditydevice as $tdd)
						  <option value="{{ $tdd->id }}">{{ $tdd->device_uid.' ('.$tdd->device_brand.')' }}</option>
                          @endforeach
                        </select>
						<div id='error-device' style="color: red;"></div>
                      </div>
                    </div>
					<div class="col-md-3">
                      <div class="mb-3">
                        <label class="form-label"><b>Chlorine Sensor</b></label>
						<select class="form-select" name="cl_sensor" id="cl_sensor">
                          <option value="">Select Device</option>
                           @foreach ($cldevice as $cld)
						  <option value="{{ $cld->id }}">{{ $cld->device_uid.' ('.$cld->device_brand.')' }}</option>
                          @endforeach
                        </select>
						<div id='error-device' style="color: red;"></div>
                      </div>
                    </div>					
                  </div>
				  <div class="row">				
                   	<div class="col-md-3">
                      <div class="mb-3">
                        <label class="form-label"><b>Temperature Sensor</b></label>
						<select class="form-select" name="temp_sensor" id="temp_sensor">
                          <option value="">Select Device</option>
                           @foreach ($tempdevice as $tmpd)
						  <option value="{{ $tmpd->id }}">{{ $tmpd->device_uid.' ('.$tmpd->device_brand.')' }}</option>
                          @endforeach
                        </select>
						<div id='error-device' style="color: red;"></div>
                      </div>
                    </div>
					<div class="col-md-3">
                      <div class="mb-3">
                        <label class="form-label"><b>OPR Sensor</b></label>
						<select class="form-select" name="opr_sensor" id="opr_sensor">
                          <option value="">Select Device</option>
                           @foreach ($oprdevice as $oprd)
						  <option value="{{ $oprd->id }}">{{ $oprd->device_uid.' ('.$oprd->device_brand.')' }}</option>
                          @endforeach
                        </select>
						<div id='error-device' style="color: red;"></div>
                      </div>
                    </div>
					<div class="col-md-3">
                      <div class="mb-3">
                        <label class="form-label"><b>Water Level Sensor</b></label>
						<select class="form-select" name="water_sensor" id="water_sensor">
                          <option value="">Select Device</option>
                           @foreach ($waterdevice as $wtrd)
						  <option value="{{ $wtrd->id }}">{{ $wtrd->device_uid.' ('.$wtrd->device_brand.')' }}</option>
                          @endforeach
                        </select>
						<div id='error-device' style="color: red;"></div>
                      </div>
                    </div>
                  </div>        
					
				<div class="row p-5">
				<div class="btn-footer">
                  <div class="btn-sec m-2">
                    <button type="submit" class="btn btn-primary"  onClick="return validation();">Submit</button>
                  </div>
                </div>
				</div>

                </form>

                

              </div>
            </div>
          </div>
        </div>

        
      </main>

@endsection	 
@push('scripts')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
  $(function() {
    $("#device_purchased_on").datepicker({
      dateFormat: 'dd-mm-yy' // Example format
    });
  });
</script>
@endpush
  
<script>  
    function validation() {		
        if (document.getElementById('tank_id').value == "") {
            $('#error-tank').html('* Tank is required');
            $('#error-tank').css('color', 'red');
            $('#tank_id').focus();
            return false;
        }
		if (document.getElementById('device_id').value == "") {
            $('#error-device').html('* Device is required');
            $('#error-device').css('color', 'red');
            $('#device_id').focus();
            return false;
        }		
        return true;
    }
</script>
