@extends('layouts.main')

@section('content')
<main class="content">
    <div class="g-color"></div>
    <div class="position-relative">
        <div class="container-sec">
            <div class="cotainer-body p-4">
                <div class="page-hading">
                    <a href="#" class="d-flex align-items-center">
                        <i class="ri-arrow-left-line"></i> Add New Tank
                    </a>
                </div>
                <div class="add-tank">
                    <form class="mt-5" action="{{ route('store_tank') }}" method="post" name="tank_form">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label"><b>Tank Name</b> <span
                                            style="color:#FF0000;">*</span></label>
                                    <input type="text" class="form-control" name="tank_name" id="tank_name"
                                        aria-describedby="">
                                    <div id='error-name' style="color: red;"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label"><b>Tank Location</b></label>
                                    <input type="text" class="form-control" name="tank_loc" id="tank_loc">

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label"><b>Tank Address</b></label>
                                    <input type="text" class="form-control" name="address1" id="address1"
                                        aria-describedby="">
                                    <!-- <div class="form-text red-text">We'll never share your email with anyone else.</div> -->
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label class="form-label"><b>City</b></label>
                                            <input type="text" class="form-control" name="city" id="city">

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label class="form-label"><b>State</b></label>
                                            <input type="text" class="form-control" name="state" id="state">

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label class="form-label"><b>Zip</b></label>
                                            <input type="text" class="form-control" name="zip" id="zip"
                                                aria-describedby="">
                                            <!-- <div class="form-text red-text">We'll never share your email with anyone else.</div> -->
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="row">

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label"><b>Tank Latitude</b></label>
                                    <input type="text" class="form-control" name="tank_lat_loc" id="tank_lat_loc">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label"><b>Tank Longitude</b></label>
                                    <input type="text" class="form-control" name="tank_long_loc" id="tank_long_loc">

                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label"><b>Description</b></label>
                                    <input type="text" class="form-control" name="description" id="description"
                                        aria-describedby="">
                                    <!-- <div class="form-text red-text">We'll never share your email with anyone else.</div> -->
                                </div>
                            </div>
                        </div>
                        <div class="row">

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label"><b>Contact Person Name</b></label>
                                    <input type="text" class="form-control" name="contact_person_name"
                                        id="contact_person_name">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label"><b>Contact Person Contact No</b></label>
                                    <input type="text" class="form-control" name="contact_person_contact_no"
                                        id="contact_person_contact_no">

                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label"><b>Contact Person Email</b></label>
                                    <input type="email" class="form-control" name="contact_person_email"
                                        id="contact_person_email">
                                    <input type="hidden" name="created_by" value="1" />
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3 datainputs" id="req_input">
                                    <div class="row align-items-center">
                                        <div class="col-md-4">
                                            <label class="form-label"><b>IMEI</b></label>
                                            <input type="text" class="form-control iimeie" name="imei[0][no]" id="imei_0" >
                                            <span style="color:red" id="l_imei_0" >&nbsp;</span>
                                        </div>
                                        <div class="col-md-4 ps-0">
                                            <a href="#" id="addmore" class="add_input btn btn-primary mt-4">Add more</a>
                                        </div>
                                    </div>

                                </div>



                            </div>

                        </div>
                        <input type="hidden" id="ccounter" value="0" >

                        <div class="row p-5">
                            <div class="btn-footer">
                                <div class="btn-sec m-2">
                                    <!--<button type="submit" class="btn btn-brder">Cancle</button>-->
                                    <button type="button" class="btn btn-primary"
                                        onClick="return validation();">Submit</button>
                                </div>
                            </div>
                        </div>

                    </form>



                </div>
            </div>
        </div>
    </div>


</main>

@endsection
<?php  
function generateSecureAlphanumericString($length = 10) {
    // Generate random bytes and convert to hexadecimal
    $num1 = rand(100000,999999);
	$num2 = rand(100000,999999);
	$num3 = rand(100,999);
	$endString = $num1.$num2.$num3;
    
    // Trim to the desired length
    return $endString;
}
?>
<script>
    function isInt(value) 
    {
      return !isNaN(value) && 
             parseInt(Number(value)) == value && 
             !isNaN(parseInt(value, 10));
    }
    function validation() 
    {        
        if (document.getElementById('tank_name').value == "") 
        {
            $('#error-name').html('* Tank Name is required');
            $('#error-name').css('color', 'red');
            $('#tank_name').focus();
            return false;
        }
        
        const collection = document.getElementsByClassName("iimeie");
        var errorr=0;
        var send_str="";
        for (let i = 0; i < collection.length; i++) 
        {
            //console.log("l_"+collection[i].id);
            send_str+="|l_"+collection[i].id+'>'+document.getElementById(collection[i].id).value;
            document.getElementById("l_"+collection[i].id).innerHTML='&nbsp;';
            

            if(document.getElementById(collection[i].id).value=="")
            {
                document.getElementById("l_"+collection[i].id).innerHTML='Requered';
                errorr=1;
            }
            else if(!(isInt(document.getElementById(collection[i].id).value)))
            {
                document.getElementById("l_"+collection[i].id).innerHTML='Must be Number';
                errorr=1;
            }
            else if(((document.getElementById(collection[i].id).value).length)!=15)
            {
                document.getElementById("l_"+collection[i].id).innerHTML='Must be 15 digit';
                errorr=1;
            }
            //console.log(((document.getElementById(collection[i].id).value).length));

        }

        for (let i = 0; i < collection.length; i++) 
        {
            //console.log(collection[i].id);
            for (let j = 0; j < collection.length; j++) 
            {
                if(i!=j)
                {

                    if(document.getElementById(collection[i].id).value!="" && 
                        document.getElementById(collection[j].id).value!="" && 
                        document.getElementById(collection[i].id).value==document.getElementById(collection[j].id).value)
                    {
                        errorr=1;
                        //console.log(collection[i].id+'='+collection[j].id);
                        //console.log(collection[i].id);
                        //console.log(collection[i].value+'='+collection[j].value);
                        //console.log(i+'='+j);
                        document.getElementById("l_"+collection[i].id).innerHTML='Duplicate';
                        document.getElementById("l_"+collection[j].id).innerHTML='Duplicate';
                    }
                }
            }
        }
        //return false;
        if(errorr)
        {
            return false;
        }
        //console.log(errorr);
        //console.log(send_str);
        var tank_id=0;
        $.ajax({
          url: '/tank-master/tank-imei-check',
          async: false, // set the property here
          method: "GET",
          data: { send_str: send_str, tank_id: tank_id },
          success: function(data) {
            var arr_ret=data.split('|');
            for (let i = 0; i < arr_ret.length; i++) 
            {
                //if(document.getElementById(arr_ret[i]))
                {
                    document.getElementById(arr_ret[i]).innerHTML='Already Exists';
                }
                errorr=1;
            }
            console.log(data);
          },
          error: function(xhr, error) {
            alert('error in ajax');
          }
        });
        if(errorr)
        {
            return false;
        }
        //alert('ok'); return false;
        document.tank_form.submit();
    }
</script>