<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreTankRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'tank_uid' => 'required|string|max:255|unique:tank_master,tank_uid',
            'tank_name' => 'required|string|max:255',
            'tank_loc' => 'required|string',
            'tank_lat_loc' => 'required|numeric',
            'tank_long_loc' => 'required|numeric',
            'address1' => 'required|string|max:255',
            'address2' => 'nullable|string|max:255',
            'city' => 'required|string|max:255',
            'state' => 'required|string|max:255',
            'zip' => 'required|string|max:255',
            'description' => 'nullable|string',
            'contact_person_name' => 'required|string|max:255',
            'contact_person_contact_no' => 'required|string|max:255',
            'contact_person_email' => 'required|email|max:255',
            'tank_status_id' => 'required|integer',
            'created_by' => 'required|integer',
            'updated_by' => 'nullable|integer'
        ];
    }
}
