<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cookie;
use App\Models\TankMaster;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\Excel as ExcelType;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class WebController extends Controller
{
    //
    public function userdashboard()
    {
        $water_measures = DB::table('water_health_measures')->where('is_deleted', 0)->select('param_name', 'param_max_value', 'param_min_value')->get()->toArray();
        $measures = [];
        foreach ($water_measures as $item) {
            $measures[$item->param_name] = $item;
        }
        $tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
		
		$userId = auth('web')->user()->id;
		$user = DB::table('users')->where('id', $userId)->first();	
		if($user->role_id == 2 || $user->role_id == 3 || $user->role_id == 4) {
			if ($user && $user->tank_ids) {
				$tankIds = json_decode($user->tank_ids, true);
				
				$tanks = DB::table('tank_masters')->whereIn('id', $tankIds)->select('id', 'tank_name')->get();
			}
		} else {
			$tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
		}
		
        $results = [];
        foreach ($tanks as $table) {
            $tname = strtolower(str_replace(' ', '', $table->tank_name));
            $ctable = 'tank_' . $tname . '_' . $table->id;
            // Query each table dynamically
            DB::statement("SET sql_mode=''");
            $results[$tname]['tank_name'] = $table->tank_name;
            /*$latestReading = DB::table("$ctable AS tr")
			->selectRaw('DATE(tr.created_at) AS read_date')
			->selectRaw('HOUR(tr.created_at) AS read_hour')
			->selectRaw("REPLACE(GROUP_CONCAT(IFNULL(tr.chlrn, '')), ',', '') AS clval")
			->selectRaw("REPLACE(GROUP_CONCAT(IFNULL(tr.opr, '')), ',', '') AS oprval")
			->selectRaw("REPLACE(GROUP_CONCAT(IFNULL(tr.tds, '')), ',', '') AS tdsval")
			->selectRaw("REPLACE(GROUP_CONCAT(IFNULL(tr.ph, '')), ',', '') AS phval")
			->selectRaw("REPLACE(GROUP_CONCAT(IFNULL(tr.tur, '')), ',', '') AS turval")
			->selectRaw("REPLACE(GROUP_CONCAT(IFNULL(tr.iron_lvl, '')), ',', '') AS ironval")
			->selectRaw("REPLACE(GROUP_CONCAT(IFNULL(tr.temp, '')), ',', '') AS tempval")
			->leftJoinSub(
				DB::table($ctable)
					->select('water_lvl', 'created_at')
					->whereNotNull('water_lvl')
					->orderBy('created_at', 'desc')
					->limit(1),
				'tr1',
				'tr.created_at',
				'=',
				'tr1.created_at'
			)
			->addSelect('tr1.water_lvl')
			->groupBy('tr.created_at')
			->orderBy('tr.created_at', 'desc')
			->limit(1)
			->first();*/
			
			$latestReading = DB::table("$ctable AS tr")
			->selectRaw('DATE(tr.created_at) AS read_date')
			->selectRaw('HOUR(tr.created_at) AS read_hour')
			->selectRaw("REPLACE(GROUP_CONCAT(IFNULL(tr.chlrn, '')), ',', '') AS clval")
			->selectRaw("REPLACE(GROUP_CONCAT(IFNULL(tr.opr, '')), ',', '') AS oprval")
			->selectRaw("REPLACE(GROUP_CONCAT(IFNULL(tr.tds, '')), ',', '') AS tdsval")
			->selectRaw("REPLACE(GROUP_CONCAT(IFNULL(tr.ph, '')), ',', '') AS phval")
			->selectRaw("REPLACE(GROUP_CONCAT(IFNULL(tr.tur, '')), ',', '') AS turval")
			->selectRaw("REPLACE(GROUP_CONCAT(IFNULL(tr.iron_lvl, '')), ',', '') AS ironval")
			->selectRaw("REPLACE(GROUP_CONCAT(IFNULL(tr.temp, '')), ',', '') AS tempval")
			->leftJoinSub(
				DB::table($ctable)
					->select('water_lvl')
					->whereNotNull('water_lvl')
					->orderBy('created_at', 'desc')
					->limit(1),
				'tr1',
				DB::raw('1'),
				DB::raw('1') // Ensures the latest `water_lvl` is always joined
			)
			->addSelect('tr1.water_lvl')
			->groupBy('tr.created_at')
			->orderBy('tr.created_at', 'desc')
			->limit(1)
			->first();

            $results[$tname]['result'] = $latestReading;			
        }
		//dd($results);
        return view('viewdashboard', compact('results', 'measures'));
    }

    public function tankwisewaterturbudity(Request $request)
    {
        if ($request->input('sval') == 1) {
            $fdate = date('Y-m-d H:i:s', strtotime($request->input('fromdate') . ' 00:00:00'));
            $tdate = date('Y-m-d H:i:s', strtotime($request->input('todate') . ' 23:59:59'));
            $tid = $request->input('tank_list');
            $tank_details = DB::table('tank_masters')->where('id', $tid)->select('id', 'tank_name')->first();
            $tname = strtolower(str_replace(' ', '', $tank_details->tank_name));
            $ctable = 'tank_' . $tname . '_' . $tank_details->id;
            $tableName = 'tank_' . $tname . '_' . $tank_details->id;
            //$ctable = 'tank_' . $request->input('tank_list') . '_readings';
            $sval = 1;

            $tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
            /*$water_measures = DB::table('water_health_measures')->where('is_deleted', 0)->select('param_name', 'param_max_value', 'param_min_value')->get()->toArray();
            $measures = [];
            foreach ($water_measures as $item) {
                $measures[$item->param_name] = $item;
            }*/


            $tankDataQuery = "SELECT DATE(created_at) AS read_date, HOUR(created_at) AS read_hour, REPLACE(GROUP_CONCAT(IFNULL(`tur`,'')),',','') AS turval, REPLACE(GROUP_CONCAT(IFNULL(`water_lvl`,'')),',','') AS wtrval FROM `" . $tableName . "` WHERE created_at BETWEEN '" . $fdate . "' AND '" . $tdate . "' GROUP BY tank_id, DATE(created_at), HOUR(created_at) ORDER BY DATE(created_at) DESC, HOUR(created_at) DESC";

            $data = DB::select($tankDataQuery);

            $chartdata = [
                'from_date' => $fdate,
                'to_date' => $tdate,
                'tank_uid' => $tid
            ];

            $jsonData = json_encode($chartdata);
            $enc_data = base64_encode($jsonData);


            return view('report.watervsturbchartview', ['data' => $data, 'fdate' => $fdate, 'tdate' => $tdate, 'tname' => $tid, 'tanks' => $tanks, 'sval' => $sval, 'encData' => $enc_data]);
        } else {
            $fdate = '2024-10-03 00:00:00';
            $tdate = '2024-10-03  23:59:59';
            $tname = '57';
            $tableName = 'tank_nayapatti_57';
            $ctable = 'tank_nayapatti_57';
            $sval = 0;

            $tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
            /*$water_measures = DB::table('water_health_measures')->where('is_deleted', 0)->select('param_name', 'param_max_value', 'param_min_value')->get()->toArray();
            $measures = [];
            foreach ($water_measures as $item) {
                $measures[$item->param_name] = $item;
            }*/


            $tankDataQuery = "SELECT DATE(created_at) AS read_date, HOUR(created_at) AS read_hour, REPLACE(GROUP_CONCAT(IFNULL(`tur`,'')),',','') AS turval, REPLACE(GROUP_CONCAT(IFNULL(`water_lvl`,'')),',','') AS wtrval FROM `" . $tableName . "` WHERE created_at BETWEEN '" . $fdate . "' AND '" . $tdate . "' GROUP BY tank_id, DATE(created_at), HOUR(created_at) ORDER BY DATE(created_at) DESC, HOUR(created_at) DESC";

            $data = DB::select($tankDataQuery);

            $chartdata = [
                'from_date' => $fdate,
                'to_date' => $tdate,
                'tank_uid' => $tname
            ];

            $jsonData = json_encode($chartdata);
            $enc_data = base64_encode($jsonData);

            return view('report.watervsturbchartview', ['data' => $data, 'fdate' => $fdate, 'tdate' => $tdate, 'tname' => $tname, 'tanks' => $tanks, 'sval' => $sval, 'encData' => $enc_data]);
        }
    }

    public function tankwisewatervsturbreport($encData)
    {
        $cookieData = base64_decode($encData);
        if ($cookieData) {
            $data = json_decode($cookieData, true);
            $fdate = $data['from_date'] ?? null;
            $tdate = $data['to_date'] ?? null;
            $tid = $data['tank_uid'] ?? null;

            $tank_details = DB::table('tank_masters')->where('id', $tid)->select('id', 'tank_name')->first();
            $tname = strtolower(str_replace(' ', '', $tank_details->tank_name));
            $tableName = 'tank_' . $tname . '_' . $tank_details->id;

            $tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();

            $tankDataQuery = "SELECT DATE(created_at) AS read_date, HOUR(created_at) AS read_hour, REPLACE(GROUP_CONCAT(IFNULL(`tur`,'')),',','') AS turval, REPLACE(GROUP_CONCAT(IFNULL(`water_lvl`,'')),',','') AS wtrval FROM `" . $tableName . "` WHERE created_at BETWEEN '" . $fdate . "' AND '" . $tdate . "' GROUP BY tank_id, DATE(created_at), HOUR(created_at) ORDER BY DATE(created_at) DESC, HOUR(created_at) DESC";

            $data = DB::select($tankDataQuery);

            return view('report.watervsturbreport', ['data' => $data, 'from_date' => $fdate, 'to_date' => $tdate, 'tname' => $tid, 'tanks' => $tanks, 'encdata' => $encData]);
        } else {
            return redirect()->route('watervsturb')->with('success', 'Please select parameters for the report.');
        }
    }

    public function tankwisewatervsturbexcel($encData)
    {
        $cookieData = base64_decode($encData);
        if ($cookieData) {
            $data = json_decode($cookieData, true);
            $data = json_decode($cookieData, true);
            $fdate = $data['from_date'] ?? null;
            $tdate = $data['to_date'] ?? null;
            $tid = $data['tank_uid'] ?? null;
            $tank_details = DB::table('tank_masters')->where('id', $tid)->select('id', 'tank_name')->first();
            $tname = strtolower(str_replace(' ', '', $tank_details->tank_name));
            $tableName = 'tank_' . $tname . '_' . $tank_details->id;

            $tankDataQuery = "SELECT DATE(created_at) AS read_date, HOUR(created_at) AS read_hour, REPLACE(GROUP_CONCAT(IFNULL(`tur`,'')),',','') AS turval, REPLACE(GROUP_CONCAT(IFNULL(`water_lvl`,'')),',','') AS wtrval FROM `" . $tableName . "` WHERE created_at BETWEEN '" . $fdate . "' AND '" . $tdate . "' GROUP BY tank_id, DATE(created_at), HOUR(created_at) ORDER BY DATE(created_at) DESC, HOUR(created_at) DESC";

            $data = DB::select($tankDataQuery);

            // Create a new spreadsheet instance
            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Add Report File Information
            $sheet->mergeCells('A1:D1');
            $sheet->setCellValue('A1', 'Tank wise Water vs Turbidity report for : ' . $tank_details->tank_name);
            $sheet->mergeCells('A3:D3');
            $sheet->setCellValue('A3', 'Date range From: ' . \Carbon\Carbon::parse($fdate)->format("d-m-Y") . ' To: ' . \Carbon\Carbon::parse($tdate)->format('d-m-Y'));

            $rowNumber = 4;
            //$rowNumber++;

            $rowNumber++;  // Start from the second row after headers
            $sheet->setCellValue('A' . $rowNumber, 'Time');
            $sheet->setCellValue('B' . $rowNumber, 'Water Level (Ft)');
            $sheet->setCellValue('C' . $rowNumber, 'Trubidity (NTU)');
            $rowNumber++;

            if (!empty($data)) {
                foreach ($data as $rowData) {
                    $sheet->setCellValue('A' . $rowNumber, \Carbon\Carbon::parse($rowData->read_date)->format("d-m-Y ") . $rowData->read_hour . ':00');
                    $sheet->setCellValue('B' . $rowNumber, number_format((float)($rowData->wtrval), 2));
                    $sheet->setCellValue('C' . $rowNumber, number_format((float)($rowData->turval), 2));
                    $sheet->getStyle('B' . $rowNumber . ':C' . $rowNumber)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_00);
                    $rowNumber++;
                }
            } else {
                $sheet->mergeCells('A' . $rowNumber . ':D' . $rowNumber);
                $sheet->setCellValue('A' . $rowNumber, 'No data available for tank ' . $tank_details->tank_name);
                $rowNumber++;
            }

            // Create the writer to export to Excel
            $writer = new Xlsx($spreadsheet);

            // Prepare the response
            $fileName = 'Tank_wise_Water_vs_Turbidity_report_of_Tank ' . $tank_details->tank_name . '_' . \Carbon\Carbon::now() . '.xlsx';

            // Set headers for download
            $response = response()->streamDownload(function () use ($writer) {
                $writer->save('php://output');
            }, $fileName);

            // Return the file as a download
            return $response;
        } else {
            return redirect()->route('watervsturb')->with('success', 'Please select parameters for the report.');
        }
    }

    public function outlier(Request $request)
    {
        if ($request->input('sval') == 1) {
            $fdate = date('Y-m-d H:i:s', strtotime($request->input('fromdate') . ' 00:00:00'));
            $tdate = date('Y-m-d H:i:s', strtotime($request->input('todate') . ' 23:59:59'));
            $sval = 1;
            $phColumn = $request->input('device_type_id');
            if ($phColumn == 'ph') {
                $paramName = 'PH';
            }
            if ($phColumn == 'chlrn') {
                $paramName = 'CL';
            }
            if ($phColumn == 'tds') {
                $paramName = 'TDS';
            }
            if ($phColumn == 'tur') {
                $paramName = 'TUR';
            }
            if ($phColumn == 'iron_lvl') {
                $paramName = 'FE';
            }
            if ($phColumn == 'water_lvl') {
                $paramName = 'WL';
            }

            $water_measures = DB::table('water_health_measures')->where('is_deleted', 0)->where('param_name', $paramName)->select('param_name', 'param_max_value', 'param_min_value')->first();

            $tanks = DB::table('tank_masters')
                ->where('tank_status_id', 1)
                //->pluck('tank_uid');
                ->select('id', 'tank_name')
                ->get();
            $results = [];
            foreach ($tanks as $table) {
                $tname = strtolower(str_replace(' ', '', $table->tank_name));
                $ctable = 'tank_' . $tname . '_' . $table->id;
                //$ctable = 'tank_' . $table->tank_uid . '_readings';
                // Query each table dynamically
                $results[$table->tank_name]['tank_name'] = $table->tank_name;
                //-----------------------For PH-----------------------------------------------------
                $paramval = DB::table($ctable . ' as t')
                    ->join('water_health_measures as whm', function ($join) use ($paramName) {
                        $join->on('whm.param_name', '=', DB::raw("'$paramName'"));
                    })
                    ->select(
                        DB::raw("DATE_FORMAT(t.created_at, '%d-%b-%y %H:%i:%s') as created_at"),  // Date formatting
                        't.' . $phColumn . ' as paramval'  // Alias for the selected column
                    )
                    ->whereNotNull('t.' . $phColumn)  // Use the actual column name here
                    ->whereBetween('t.created_at', [$fdate, $tdate])  // Date range filter
                    ->where(function ($query) use ($phColumn) {
                        $query->whereColumn('t.' . $phColumn, '<', 'whm.param_min_value')  // Use the actual column name
                            ->orWhereColumn('t.' . $phColumn, '>', 'whm.param_max_value');  // Use the actual column name
                    })
                    ->orderBy('t.created_at', 'DESC')
                    ->get();
                $results[$table->tank_name]['result'] = $paramval;
            }

            $data = [
                'fdate' => $fdate,
                'tdate' => $tdate,
                'phColumn' => $phColumn
            ];
            $jsonData = json_encode($data);
            $enc_data = base64_encode($jsonData);
            return view('report.outlierchartview', ['measures' => $water_measures, 'data' => $results, 'fdate' => $fdate, 'tdate' => $tdate, 'phColumn' => $phColumn, 'sval' => $sval, 'enc_data' => $enc_data, 'paramName' => $paramName]);
        } else {
            $fdate = date('Y-m-d'.' 00:00:00');
            $tdate = date('Y-m-d'.' 23:59:59');
            $sval = 0;
            $phColumn = 'tds';
            if ($phColumn == 'tds') {
                $paramName = 'TDS';
            }

            $water_measures = DB::table('water_health_measures')->where('is_deleted', 0)->where('param_name', $paramName)->select('param_name', 'param_max_value', 'param_min_value')->first();

            $tanks = DB::table('tank_masters')
                ->where('tank_status_id', 1)
                ->select('id', 'tank_name')
                ->get();
            $results = [];
            foreach ($tanks as $table) {
                $tname = strtolower(str_replace(' ', '', $table->tank_name));
                $ctable = 'tank_' . $tname . '_' . $table->id;

                //$ctable = 'tank_' . $table->tank_uid . '_readings';
                // Query each table dynamically
                $results[$table->tank_name]['tank_name'] = $table->tank_name;
                //-----------------------For PH-----------------------------------------------------
                $paramval = DB::table($ctable . ' as t')
                    ->join('water_health_measures as whm', function ($join) use ($paramName) {
                        $join->on('whm.param_name', '=', DB::raw("'$paramName'"));
                    })
                    ->select(
                        DB::raw("DATE_FORMAT(t.created_at, '%d-%b-%y %H:%i:%s') as created_at"),  // Date formatting
                        't.' . $phColumn . ' as paramval'  // Alias for the selected column
                    )
                    ->whereNotNull('t.' . $phColumn)  // Use the actual column name here
                    ->whereBetween('t.created_at', [$fdate, $tdate])  // Date range filter
                    ->where(function ($query) use ($phColumn) {
                        $query->whereColumn('t.' . $phColumn, '<', 'whm.param_min_value')  // Use the actual column name
                            ->orWhereColumn('t.' . $phColumn, '>', 'whm.param_max_value');  // Use the actual column name
                    })
                    ->orderBy('t.created_at', 'DESC')
                    ->get();
                $results[$table->tank_name]['result'] = $paramval;
            }

            $data = [
                'fdate' => $fdate,
                'tdate' => $tdate,
                'phColumn' => $phColumn
            ];
            $jsonData = json_encode($data);
            $enc_data = base64_encode($jsonData);
            return view('report.outlierchartview', ['measures' => $water_measures, 'data' => $results, 'fdate' => $fdate, 'tdate' => $tdate, 'phColumn' => $phColumn, 'sval' => $sval, 'enc_data' => $enc_data, 'paramName' => $paramName]);
        }
    }

    public function outlierexcel($encdata)
    {
        $cookieData = base64_decode($encdata);

        if ($cookieData) {
            $data = json_decode($cookieData, true);
            $from_date = $data['fdate'] ?? null;
            $to_date = $data['tdate'] ?? null;
            $phColumn = $data['phColumn'] ?? null;

            if ($phColumn == 'ph') {
                $paramName = 'PH';
            }
            if ($phColumn == 'chlrn') {
                $paramName = 'CL';
            }
            if ($phColumn == 'tds') {
                $paramName = 'TDS';
            }
            if ($phColumn == 'tur') {
                $paramName = 'TUR';
            }
            if ($phColumn == 'iron_lvl') {
                $paramName = 'FE';
            }
            if ($phColumn == 'water_lvl') {
                $paramName = 'WL';
            }
            $unit = (in_array($paramName, ['TDS', 'CL', 'FE'])) ? '(mg/L)' : (($paramName == 'TUR') ? '(NTU)' : (($paramName == 'OPR') ? '(mV)' : ''));

            $measures = DB::table('water_health_measures')->where('is_deleted', 0)->where('param_name', $paramName)->select('param_name', 'param_max_value', 'param_min_value')->first();

            $tanks = DB::table('tank_masters')
                ->where('tank_status_id', 1)
                //->pluck('tank_uid');
                ->select('id', 'tank_name')
                ->get();
            $results = [];
            foreach ($tanks as $table) {
                $tname = strtolower(str_replace(' ', '', $table->tank_name));
                $ctable = 'tank_' . $tname . '_' . $table->id;
                //$ctable = 'tank_' . $table->tank_uid . '_readings';
                // Query each table dynamically
                $results[$table->tank_name]['tank_name'] = $table->tank_name;
                //-----------------------For PH-----------------------------------------------------
                $paramval = DB::table($ctable . ' as t')
                    ->join('water_health_measures as whm', function ($join) use ($paramName) {
                        $join->on('whm.param_name', '=', DB::raw("'$paramName'"));
                    })
                    ->select(
                        DB::raw("DATE_FORMAT(t.created_at, '%d-%b-%y %H:%i:%s') as created_at"),  // Date formatting
                        't.' . $phColumn . ' as paramval'  // Alias for the selected column
                    )
                    ->whereNotNull('t.' . $phColumn)  // Use the actual column name here
                    ->whereBetween('t.created_at', [$from_date, $to_date])  // Date range filter
                    ->where(function ($query) use ($phColumn) {
                        $query->whereColumn('t.' . $phColumn, '<', 'whm.param_min_value')  // Use the actual column name
                            ->orWhereColumn('t.' . $phColumn, '>', 'whm.param_max_value');  // Use the actual column name
                    })
                    ->orderBy('t.created_at', 'DESC')
                    ->get();
                $results[$table->tank_name]['result'] = $paramval;
            }

            // Create a new spreadsheet instance
            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Add Report File Information
            $sheet->mergeCells('A1:E1');
            $sheet->setCellValue('A1', 'Outlier Report for parameter: ' . $paramName);
            $sheet->mergeCells('A3:E3');
            $sheet->setCellValue('A3', 'Date range From: ' . \Carbon\Carbon::parse($from_date)->format("d-m-Y") . ' To: ' . \Carbon\Carbon::parse($to_date)->format('d-m-Y'));

            $sheet->mergeCells('A5:E5');
            $sheet->setCellValue('A5', 'Parameter Max Threshold: ' . $measures->param_max_value . $unit . ' Min Threshold: ' . $measures->param_min_value . $unit);
            $rowNumber = 6;
            //$rowNumber++;

            $rowNumber++;  // Start from the second row after headers
            $sheet->setCellValue('A' . $rowNumber, 'Time');
            $sheet->setCellValue('B' . $rowNumber, 'Tank Name');
            $sheet->setCellValue('C' . $rowNumber, 'Parameter');
            $sheet->setCellValue('D' . $rowNumber, 'Unit');
            $sheet->setCellValue('E' . $rowNumber, 'Reading');
            $rowNumber++;

            foreach ($results as $tankId => $tank_data) {
                $tankName = $tank_data['tank_name'];
                $tankResults = $tank_data['result'];
                //$rowNumber++;
                if (!empty($tankResults)) {
                    foreach ($tankResults as $rowData) {
                        $sheet->setCellValue('A' . $rowNumber, $rowData->created_at);
                        $sheet->setCellValue('B' . $rowNumber, $tankName);
                        $sheet->setCellValue('C' . $rowNumber, $paramName);
                        $sheet->setCellValue('D' . $rowNumber, $unit);
                        $sheet->setCellValue('E' . $rowNumber, number_format((float)$rowData->paramval, 2));
                        $sheet->getStyle('E' . $rowNumber)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_00);
                        $rowNumber++;
                    }
                } else {
                    $sheet->mergeCells('A' . $rowNumber . ':E' . $rowNumber);
                    $sheet->setCellValue('A' . $rowNumber, 'No data available for tank' . $tankName);
                    $rowNumber++;
                }
            }

            // Create the writer to export to Excel
            $writer = new Xlsx($spreadsheet);

            // Prepare the response
            $fileName = 'Outlier_report_' . $paramName . '_' . \Carbon\Carbon::now() . '.xlsx';

            // Set headers for download
            $response = response()->streamDownload(function () use ($writer) {
                $writer->save('php://output');
            }, $fileName);

            // Return the file as a download
            return $response;
        } else {
            return redirect()->route('selectrange')->with('success', 'Please select parameters for the report.');
        }
    }

    public function comparative(Request $request)
    {
        if ($request->input('sval') == 1) {
            $fdate = date('Y-m-d H:i:s', strtotime($request->input('fromdate') . ' 00:00:00'));
            $tdate = date('Y-m-d H:i:s', strtotime($request->input('todate') . ' 23:59:59'));
            $param = $request->input('device_type_id');
            $sval = 1;

            DB::statement("SET sql_mode=''");

            $water_measures = DB::table('water_health_measures')->where('is_deleted', 0)->select('param_name', 'param_max_value', 'param_min_value')->get()->toArray();
            $measures = [];
            foreach ($water_measures as $item) {
                $measures[$item->param_name] = $item;
            }

            $tanks = DB::table('tank_masters')
                ->where('tank_status_id', 1)
                //->pluck('tank_uid');
                ->select('id', 'tank_name')
                ->get();
            $tbl_results = [];
            $query = null;
            foreach ($tanks as $table) {
                $tname = strtolower(str_replace(' ', '', $table->tank_name));
                $ctable = 'tank_' . $tname . '_' . $table->id;
                //$ctable = 'tank_' . $table->tank_uid . '_readings';
                $results = [];
                $results = DB::table($ctable)
                    ->select(
                        DB::raw('DATE(created_at) as date'), // Group by date
                        DB::raw('AVG(' . $param . ') as avg_val')        // Calculate the average of the `ph` column
                    )
                    ->whereNotNull($param) // Ensure that ph values are not null
                    ->whereBetween(DB::raw('DATE(created_at)'), [$fdate, $tdate]) // Date range filter
                    ->groupBy(DB::raw('DATE(created_at)')) // Group by day
                    ->orderBy(DB::raw('DATE(created_at)'))
                    ->get();
                $tbl_results[$table->tank_name] = $results;
            }

            $transformedArray = [];

            foreach ($tbl_results as $tankUID => $data) {
                foreach ($data as $record) {
                    $date = $record->date;
                    $avg_val = $record->avg_val;

                    // Initialize date key if not present
                    if (!isset($transformedArray[$date])) {
                        $transformedArray[$date] = [];
                    }

                    // Assign the tankUID and avg_ph under the date
                    $transformedArray[$date][$tankUID] = $avg_val;
                }
            }

            return view('report.comparativeanay', ['measures' => $measures, 'results' => $transformedArray, 'fdate' => $fdate, 'tdate' => $tdate, 'sval' => $sval, 'param' => $param]);
        
		} else {
			$tanks = TankMaster::all();
            $water_measures = DB::table('water_health_measures')->where('is_deleted', 0)->select('param_name', 'param_max_value', 'param_min_value')->get()->toArray();
            $measures = [];
            foreach ($water_measures as $item) {
                $measures[$item->param_name] = $item;
            }
            $results = array();
           	$fdate = date('Y-m-d'.' 00:00:00');
            $tdate = date('Y-m-d'.' 23:59:59');
            $sval = 0;
            $param = "";

            return view('report.comparativeanay', ['measures' => $measures, 'results' => $results, 'fdate' => $fdate, 'tdate' => $tdate, 'sval' => $sval, 'param' => $param]);
        }
    }

    public function phlevelmonitor(Request $request)
    {
        if ($request->input('sval') == 1) {
            $fdate = date('Y-m-d H:i:s', strtotime($request->input('fromdate') . ' 00:00:00'));
            $tdate = date('Y-m-d H:i:s', strtotime($request->input('todate') . ' 23:59:59'));
            $sval = 1;
            $paramName = 'PH';
            $water_measures = DB::table('water_health_measures')->where('is_deleted', 0)->where('param_name', $paramName)->select('param_name', 'param_max_value', 'param_min_value')->first();

            $tanks = DB::table('tank_masters')
                ->where('tank_status_id', 1)
                ->select('id', 'tank_name')
                ->get();
            $results = [];
            foreach ($tanks as $table) {
                $ctable = 'tank_' . $table->tank_uid . '_readings';
                // Query each table dynamically
                $results[$table->tank_name]['tank_name'] = $table->tank_name;
                //-----------------------For PH-----------------------------------------------------
                $paramval =  DB::table($ctable)
                    ->select(
                        'ph',
                        DB::raw("DATE_FORMAT(created_at, '%d-%b-%y %H:%i') as created_at")  // Format created_at
                    )
                    ->whereNotNull('ph')
                    ->whereBetween('created_at', [$fdate, $tdate])
                    ->orderBy('created_at', 'ASC')  // Order by created_at in ascending order
                    ->get();
                $results[$table->tank_name]['result'] = $paramval;
            }

            return view('report.phlevelmonitor', ['measures' => $water_measures, 'data' => $results, 'fdate' => $fdate, 'tdate' => $tdate, 'sval' => $sval]);
        } else {
            $fdate = '2024-09-11 00:00:00';
            $tdate = '2024-09-17 23:59:59';
            $sval = 0;
            $paramName = 'PH';
            $water_measures = DB::table('water_health_measures')->where('is_deleted', 0)->where('param_name', $paramName)->select('param_name', 'param_max_value', 'param_min_value')->first();

            $tanks = DB::table('tank_masters')
                ->where('tank_status_id', 1)
                ->select('tank_uid', 'tank_name')
                ->get();
            $results = [];
            foreach ($tanks as $table) {
                $ctable = 'tank_' . $table->tank_uid . '_readings';
                // Query each table dynamically
                $results[$table->tank_uid]['tank_name'] = $table->tank_name;
                //-----------------------For PH-----------------------------------------------------
                $paramval =  DB::table($ctable)
                    ->select(
                        'ph',
                        DB::raw("DATE_FORMAT(created_at, '%d-%b-%y %H:%i') as created_at")  // Format created_at
                    )
                    ->whereNotNull('ph')
                    ->whereBetween('created_at', [$fdate, $tdate])
                    ->orderBy('created_at', 'ASC')  // Order by created_at in ascending order
                    ->get();
                $results[$table->tank_uid]['result'] = $paramval;
            }

            return view('report.phlevelmonitor', ['measures' => $water_measures, 'data' => $results, 'fdate' => $fdate, 'tdate' => $tdate, 'sval' => $sval]);
        }
    }



    public function detailedtankwise(Request $request)
    {
        if ($request->input('sval') == 1) {
			$userId = auth('web')->user()->id;
			$user = DB::table('users')->where('id', $userId)->first();
			if($user->role_id == 2 || $user->role_id == 3 || $user->role_id == 4) {
				if ($user && $user->tank_ids) {
					$tankIds = json_decode($user->tank_ids, true);
				
					$tanks = DB::table('tank_masters')
						->whereIn('id', $tankIds)
						->select('id', 'tank_name')
						->get();
				}
			} else {
				$tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
			}
            $fdate = date('Y-m-d H:i:s', strtotime($request->input('fromdate') . ' 00:00:00'));
            $tdate = date('Y-m-d H:i:s', strtotime($request->input('todate') . ' 23:59:59'));
            $sval = 1;
            $tank_id = $request->input('tank_list');
            $device_type_id = $request->input('device_type_id');

            if ($device_type_id == 'ph') {
                $paramName = 'PH';
				$pName = 'PH';
				$unit = '';
            }
            if ($device_type_id == 'chlrn') {
                $paramName = 'CHLORINE';
				$pName = 'CL';
				$unit = 'mg/L';
            }
            if ($device_type_id == 'tds') {
                $paramName = 'TDS';
				$pName = 'TDS';
				$unit = 'ppm';
            }
            if ($device_type_id == 'tur') {
                $paramName = 'TURBIDITY';
				$pName = 'TUR';
				$unit = 'NTU';
            }
            if ($device_type_id == 'iron_lvl') {
                $paramName = 'IRON';
				$pName = 'FE';
				$unit = 'mg/L';
            }
            if ($device_type_id == 'water_lvl') {
                $paramName = 'WATER LEVEL';
				$pName = 'WL';
				$unit = 'Ft';
            }
            if ($device_type_id == 'temp') {
                $paramName = 'TEMPERATURE';
				$pName = 'TEM';
				$unit = 'C';
            }

            $tank_details = DB::table('tank_masters')->where('id', $tank_id)->select('id', 'tank_name')->first();
            $tname = strtolower(str_replace(' ', '', $tank_details->tank_name));
			
			$water_measures = DB::table('water_health_measures')->where('is_deleted', 0)->where('param_name', $pName)->select('param_name', 'param_max_value', 'param_min_value')->first();

            $results = [];
            /*if ($device_type_id == 'temp') {
                $paramval =  DB::table('tank_temp_readings')
                    ->select(
                        "reading_value as parval",
                        DB::raw("DATE_FORMAT(created_at, '%d-%b-%y %H:%i') as created_at")  // Format created_at
                    )
                    ->whereBetween('created_at', [$fdate, $tdate])
                    ->orderBy('created_at', 'DESC')  // Order by created_at in ascending order
                    ->get();
            } else {*/
                $ctable = 'tank_' . $tname . '_' . $tank_details->id;
                //$ctable = 'tank_'.$tank_uid.'_readings';
                // Query each table dynamically
                //-----------------------For PH-----------------------------------------------------
                $paramval = DB::table($ctable)
							->select(
								"$device_type_id as parval",
								DB::raw("DATE_FORMAT(created_at, '%d-%b-%y %H:%i') as created_at_display")  // Format for display
							)
							->whereNotNull($device_type_id)
							->whereBetween('created_at', [$fdate, $tdate])
							->orderBy('created_at', 'DESC')  // Order by the actual datetime column
							->get();
            //}
            $results = $paramval;
			
			//dd($results);

            $data = [
                'data' => $results,
                'param_val' => $device_type_id,
                'from_date' => $fdate,
                'to_date' => $tdate,
                'all_tanks' => $tanks,
                'paramName' => $paramName,
				'water_measures' => $water_measures,
                'tank_uid' => $tank_id,
				'unit' => $unit
            ];
            $chartdata = [
                'param_val' => $device_type_id,
                'from_date' => $fdate,
                'to_date' => $tdate,
                'tank_uid' => $tank_id
            ];

            $jsonData = json_encode($chartdata);
            $enc_data = base64_encode($jsonData);
            $data['enc_data'] = $enc_data;


            return view('report.detailedreport', $data);
        } else {
            $fdate = date('Y-m-d'.' 00:00:00');
            $tdate = date('Y-m-d'.' 23:59:59');
            $sval = 0;
			
			$userId = auth('web')->user()->id;
			$user = DB::table('users')->where('id', $userId)->first();
			if($user->role_id == 2 || $user->role_id == 3 || $user->role_id == 4) {
				if ($user && $user->tank_ids) {
					$tankIds = json_decode($user->tank_ids, true);
				
					$tanks = DB::table('tank_masters')
						->whereIn('id', $tankIds)
						->select('id', 'tank_name')
						->get();
				}
			} else {
				$tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
			}
			if($user->role_id == 2 || $user->role_id == 3 || $user->role_id == 4) {
				//echo "11"; die;
            	$tank_uid = $tankIds[0];
				$tank_details = DB::table('tank_masters')->where('id', $tank_uid)->select('id', 'tank_name')->first();
            	$tname = strtolower(str_replace(' ', '', $tank_details->tank_name));
				$ctable = 'tank_' . $tname . '_' . $tank_details->id;
			}else{
				//echo "12"; die;
				$tank_uid = '38';
				$tank_details = DB::table('tank_masters')->where('id', $tank_uid)->select('id', 'tank_name')->first();
            	$tname = strtolower(str_replace(' ', '', $tank_details->tank_name));
				$ctable = 'tank_' . $tname . '_' . $tank_details->id;
			}
			
            $device_type_id = 'water_lvl';

             if ($device_type_id == 'ph') {
                $paramName = 'PH';
				$pName = 'PH';
				$unit = '';
            }
            if ($device_type_id == 'chlrn') {
                $paramName = 'CHLORINE';
				$pName = 'CL';
				$unit = 'mg/L';
            }
            if ($device_type_id == 'tds') {
                $paramName = 'TDS';
				$pName = 'TDS';
				$unit = 'ppm';
            }
            if ($device_type_id == 'tur') {
                $paramName = 'TURBIDITY';
				$pName = 'TUR';
				$unit = 'NTU';
            }
            if ($device_type_id == 'iron_lvl') {
                $paramName = 'IRON';
				$pName = 'FE';
				$unit = 'mg/L';
            }
            if ($device_type_id == 'water_lvl') {
                $paramName = 'WATER LEVEL';
				$pName = 'WL';
				$unit = 'Ft';
            }
            if ($device_type_id == 'temp') {
                $paramName = 'TEMPERATURE';
				$pName = 'TEM';
				$unit = 'C';
            }
						
			$water_measures = DB::table('water_health_measures')->where('is_deleted', 0)->where('param_name', $pName)->select('param_name', 'param_max_value', 'param_min_value')->first();

            //$ctable = 'tank_shitalpurohr_38';
            // Query each table dynamically
            $paramval = DB::table($ctable)
							->select(
								"$device_type_id as parval",
								DB::raw("DATE_FORMAT(created_at, '%d-%b-%y %H:%i') as created_at_display")  // Format for display
							)
							->whereNotNull($device_type_id)
							->whereBetween('created_at', [$fdate, $tdate])
							->orderBy('created_at', 'DESC')  // Order by the actual datetime column
							->get();
            $results = $paramval;


            $data = [
                'data' => $results,
                'from_date' => $fdate,
                'param_val' => $device_type_id,
                //'from_date' => $fdate,
                'to_date' => $tdate,
                'all_tanks' => $tanks,
                'paramName' => $paramName,
				'water_measures' => $water_measures,
                'tank_uid' => $tank_uid,
				'unit' => $unit
            ];
            $chartdata = [
                'from_date' => $fdate,
                'param_val' => $device_type_id,
                'paramName' => $paramName,
                'to_date' => $tdate,
                'tank_uid' => $tank_uid
            ];

            $jsonData = json_encode($chartdata);
            $enc_data = base64_encode($jsonData);
            $data['enc_data'] = $enc_data;

            return view('report.detailedreport', $data);
        }
    }

    public function detailedtankwisechart($encdata)
    {
        $cookieData = base64_decode($encdata);

        if ($cookieData) {
            $data = json_decode($cookieData, true);
            $param_val = $data['param_val'] ?? null;
            $paramName = $data['paramName'] ?? null;
            $from_date = $data['from_date'] ?? null;
            $to_date = $data['to_date'] ?? null;
            $tank_uid = $data['tank_uid'] ?? null;
			
			$userId = auth('web')->user()->id;
			$user = DB::table('users')->where('id', $userId)->first();
			if($user->role_id == 2 || $user->role_id == 3 || $user->role_id == 4) 
				{
					if ($user && $user->tank_ids) {
						$tankIds = json_decode($user->tank_ids, true);
					
						$tanks = DB::table('tank_masters')
							->whereIn('id', $tankIds)
							->select('id', 'tank_name')
							->get();
					}
				} else {
					$tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
				}
            //$all_tanks = TankMaster::all();

            $tank_details = DB::table('tank_masters')->where('id', $tank_uid)->select('id', 'tank_name')->first();
            $tname = strtolower(str_replace(' ', '', $tank_details->tank_name));

            /*if ($param_val == 'temp') {
                $paramval =  DB::table('tank_temp_readings')
                    ->select(
                        "reading_value as parval",
                        DB::raw("DATE_FORMAT(created_at, '%d-%b-%y %H:%i') as created_at")  // Format created_at
                    )
                    ->whereBetween('created_at', [$from_date, $to_date])
                    ->orderBy('created_at', 'DESC')  // Order by created_at in ascending order
                    ->get();
            } else {*/
                $ctable = 'tank_' . $tname . '_' . $tank_details->id;
                //$ctable = 'tank_'. $tank_uid .'_readings';
                // Query each table dynamically
                //-----------------------For PH-----------------------------------------------------
                /*$paramval =  DB::table($ctable)
                    ->select(
                        "$param_val as parval",
                        DB::raw("DATE_FORMAT(created_at, '%d-%b-%y %H:%i') as created_at")  // Format created_at
                    )
                    ->whereNotNull($param_val)
                    ->whereBetween('created_at', [$from_date, $to_date])
                    ->orderBy('created_at', 'DESC')  // Order by created_at in ascending order
                    ->get();*/
					
				$paramval = DB::table($ctable)
							->select(
								"$param_val as parval",
								DB::raw("DATE_FORMAT(created_at, '%d-%b-%y %H:%i') as created_at_display")  // Format for display
							)
							->whereNotNull($param_val)
							->whereBetween('created_at', [$from_date, $to_date])
							->orderBy('created_at', 'DESC')  // Order by the actual datetime column
							->get();
            //}
            $results = $paramval;
			$dates = $results->pluck('created_at_display')->toArray();
			$parvals = $results->pluck('parval')->toArray();
            return view('report.detailedchartview', ['dates' =>$dates, 'parvals' =>$parvals, 'readings' => $results, 'param_val' => $param_val, 'from_date' => $from_date, 'to_date' => $to_date, 'tank_uid' => $tank_uid, 'all_tanks' => $tanks, 'encdata' => $encdata, 'paramName' => $paramName]);
        } else {
            return redirect()->route('selectrange')->with('success', 'Please select parameters for the report.');
        }
    }

    public function detailedTankWiseExcel($encdata)
    {
        $cookieData = base64_decode($encdata);

        if ($cookieData) {
            $data = json_decode($cookieData, true);

            $param_val = $data['param_val'] ?? null;
            $from_date = $data['from_date'] ?? null;
            $to_date = $data['to_date'] ?? null;
            $tank_uid = $data['tank_uid'] ?? null;
            //$all_tanks = TankMaster::all();
            $tank_details = DB::table('tank_masters')->where('id', $tank_uid)->select('id', 'tank_name')->first();

            if ($param_val == 'temp') {
                $paramval =  DB::table('tank_temp_readings')
                    ->select(
                        "reading_value as parval",
                        DB::raw("DATE_FORMAT(created_at, '%d-%b-%y %H:%i') as created_at")  // Format created_at
                    )
                    ->whereBetween('created_at', [$from_date, $to_date])
                    ->orderBy('created_at', 'DESC')  // Order by created_at in ascending order
                    ->get();
            } else {
                $tname = strtolower(str_replace(' ', '', $tank_details->tank_name));
                $ctable = 'tank_' . $tname . '_' . $tank_details->id;
                //$ctable = 'tank_'. $tank_uid .'_readings';
                // Query each table dynamically
                //-----------------------For PH-----------------------------------------------------
                $paramval =  DB::table($ctable)
                    ->select(
                        "$param_val as parval",
                        DB::raw("DATE_FORMAT(created_at, '%d-%b-%y %H:%i') as created_at")  // Format created_at
                    )
                    ->whereNotNull($param_val)
                    ->whereBetween('created_at', [$from_date, $to_date])
                    ->orderBy('created_at', 'DESC')  // Order by created_at in ascending order
                    ->get();
            }
            $sortedParamval = $paramval->sort(function ($a, $b) {
                // Extract month and year from `created_at`
                $monthA = date('Y-m', strtotime($a->created_at)); // Extract year-month
                $monthB = date('Y-m', strtotime($b->created_at));
            
                // Compare by month-year in descending order
                $monthComparison = strcmp($monthB, $monthA); // Reverse order for descending
                if ($monthComparison !== 0) {
                    return $monthComparison;
                }
            
                // If month-year is the same, compare by time in descending order
                return strtotime($b->created_at) <=> strtotime($a->created_at);
            });
            
            // Convert the sorted collection back to an array if needed
            $sortedParamval = $sortedParamval->values()->all();
            
            $results = $sortedParamval;
            if ($param_val == 'ph') {
                $paramName = 'PH';
            }
            if ($param_val == 'chlrn') {
                $paramName = 'CL';
            }
            if ($param_val == 'tds') {
                $paramName = 'TDS';
            }
            if ($param_val == 'tur') {
                $paramName = 'TUR';
            }
            if ($param_val == 'iron_lvl') {
                $paramName = 'IRON';
            }
            if ($param_val == 'water_lvl') {
                $paramName = 'WL';
            }
            if ($param_val == 'temp') {
                $paramName = 'TEMP';
            }
            $unit = (in_array($paramName, ['TDS', 'CL', 'IRON'])) ? 'mg/L' : (($paramName == 'TUR') ? 'NTU' : (($paramName == 'OPR') ? 'mV' : (($paramName == 'WL') ? 'Ft' : (($paramName == 'TEMP') ? '°C' : ''))));

            // Create a new spreadsheet instance
            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Add Report File Information
            $sheet->mergeCells('A1:D1');
            $sheet->setCellValue('A1', 'ASANSOL PHED DEPERTMENT');
			$sheet->mergeCells('A3:D3');
            $sheet->setCellValue('A3', 'Tank detailed report for : ' . $tank_details->tank_name);
            $sheet->mergeCells('A5:D5');
            $sheet->setCellValue('A5', 'From: ' . \Carbon\Carbon::parse($from_date)->format("d-m-Y") . ' To: ' . \Carbon\Carbon::parse($to_date)->format('d-m-Y'));
			$sheet->mergeCells('A7:D7');
            $sheet->setCellValue('A7', 'Genarated From: asansolphe.in');
			$sheet->mergeCells('A9:D9');
            $sheet->setCellValue('A9', 'Genarated At: '.  date('d-m-Y'));

            $rowNumber = 10;
            //$rowNumber++;

            $rowNumber++;  // Start from the second row after headers
            $sheet->setCellValue('A' . $rowNumber, 'Time');
            $sheet->setCellValue('B' . $rowNumber, 'Reading of ' . $paramName);
            $sheet->setCellValue('C' . $rowNumber, 'Unit');
            $rowNumber++;


            //$rowNumber++;
            if (!empty($results)) {
                foreach ($results as $rowData) {
                    $sheet->setCellValue('A' . $rowNumber, $rowData->created_at);
                    $sheet->setCellValue('B' . $rowNumber, number_format((float)$rowData->parval, 2));
                    $sheet->getStyle('B' . $rowNumber)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_00);
                    $sheet->setCellValue('C' . $rowNumber, $unit);
                    $rowNumber++;
                }
            } else {
                $sheet->mergeCells('A' . $rowNumber . ':D' . $rowNumber);
                $sheet->setCellValue('A' . $rowNumber, 'No data available for parameter ' . $paramName . ' of tank ' . $tank_details->tank_name);
                $rowNumber++;
            }

            // Create the writer to export to Excel
            $writer = new Xlsx($spreadsheet);

            // Prepare the response
            $fileName = 'Tank_wise_detailed_report_for_Prameter-' . $paramName . '_' . \Carbon\Carbon::now() . '.xlsx';

            // Set headers for download
            $response = response()->streamDownload(function () use ($writer) {
                $writer->save('php://output');
            }, $fileName);

            // Return the file as a download
            return $response;
        } else {
            return redirect()->route('selectrange')->with('success', 'Please select parameters for the report.');
        }
    }
}
