<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Spatie\Permission\Models\Role;
//use DB;
use Illuminate\Support\Facades\DB;
//use Hash;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Arr;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;

class UserController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
        $this->middleware('permission:users-list|users-create|users-edit|users-delete', ['only' => ['index', 'show']]);
        $this->middleware('permission:users-create', ['only' => ['create', 'store']]);
        $this->middleware('permission:users-edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:users-delete', ['only' => ['destroy']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request): View
{
    $userId = auth('web')->user()->id;
    $user = DB::table('users')->where('id', $userId)->first();
    $roleId = $user->role_id;

    // Get tanks assigned to the current user (AE)
    $assignedTanks = [];
    if (!empty($user->tank_ids)) {
        $assignedTanks = explode(',', $user->tank_ids); // Assuming tank IDs are stored as a comma-separated string
    }

    // Initialize the query
    $query = User::query();

    // Apply role-based conditions
    if ($roleId == 0) {
        // Super Admin: Can see all users (excluding themselves)
        $query->where('id', '!=', $userId);
    } elseif ($roleId == 2) {
        // AE: Can see JE and PO listings assigned to the same tanks
        $query->whereIn('role_id', [3, 4])
              ->where(function ($subQuery) use ($assignedTanks) {
                  foreach ($assignedTanks as $tank) {
                      $subQuery->orWhere('tank_ids', 'LIKE', '%' . $tank . '%');
                  }
              });
    } elseif ($roleId == 3) {
        // JE: Can see only PO listings assigned to the same tanks
        $query->where('role_id', 4)
              ->where(function ($subQuery) use ($assignedTanks) {
                  foreach ($assignedTanks as $tank) {
                      $subQuery->orWhere('tank_ids', 'LIKE', '%' . $tank . '%');
                  }
              });
    } else {
        // PO or others: No access
        $query->where('id', 0); // Ensures no results
    }

    // Paginate the filtered results
    $data = $query->latest()->paginate(30);

    // Pass data to the view
    return view('users.index', compact('data'))
        ->with('i', ($request->input('page', 1) - 1) * 30);
}


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(): View
    {
        $roles = Role::where('name', '!=', 'SuperAdmin')->pluck('name', 'name')->all();
		$userId = auth('web')->user()->id;
			$user = DB::table('users')->where('id', $userId)->first();
			if($user->role_id == 2 || $user->role_id == 3 || $user->role_id == 4) {
				if ($user && $user->tank_ids) {
					$tankIds = json_decode($user->tank_ids, true);
				
					$tanks = DB::table('tank_masters')
						->whereIn('id', $tankIds)
						->select('id', 'tank_name', 'tank_status_id', 'created_at')
						->get();
				}
			} else {
				$tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name', 'tank_status_id', 'created_at')->get();
			}
		//$tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();

        return view('users.create', compact('roles','tanks'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request): RedirectResponse
    {
        //$this->validate($request, [
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|same:confirm-password',
            'roles' => 'required'
        ]);

        $input = $request->all();
		if($input['roles'] == 'JE') {
			$input['role_id'] = 3;
			$tanksids = $input['tank_ids'];
			$input['tank_ids'] = json_encode($tanksids);
		}
		if($input['roles'] == 'PO') {
			$input['role_id'] = 4;
			$tanksids = $input['tank_ids'];
			$input['tank_ids'] = json_encode($tanksids);
		}
		if($input['roles'] == 'AE') {
			$input['role_id'] = 2;
			$tanksids = $input['tank_ids'];
			$input['tank_ids'] = json_encode($tanksids);
		}		
		
        $input['password'] = Hash::make($input['password']);

        $user = User::create($input);
        $user->assignRole($request->input('roles'));

        //return redirect()->route('users.list')->with('success', 'User created successfully');
		return redirect()->route('users.list')->with('message', 'User created successfully')->with('status', 'success');	
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id): View
    {
        $user = User::find($id);
		
        return view('users.show', compact('user'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id): View
    {
        $user = User::find($id);
        $roles = Role::where('name', '!=', 'SuperAdmin')->pluck('name', 'name')->all();
        $userRole = $user->roles->pluck('name', 'name')->all();
		
		$userId = auth('web')->user()->id;
			$users = DB::table('users')->where('id', $userId)->first();
			if($users->role_id == 2 || $users->role_id == 3 || $users->role_id == 4) {
				if ($users && $users->tank_ids) {
					$tankIds = json_decode($users->tank_ids, true);
				
					$tanks = DB::table('tank_masters')
						->whereIn('id', $tankIds)
						->select('id', 'tank_name', 'tank_status_id', 'created_at')
						->get();
				}
			} else {
				$tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name', 'tank_status_id', 'created_at')->get();
			}
		
		//$tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();

        return view('users.edit', compact('user', 'roles', 'userRole', 'tanks'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id): RedirectResponse
    {
       
        $input = $request->all();
        if (!empty($input['password'])) {
            $input['password'] = Hash::make($input['password']);
        } else {
            $input = Arr::except($input, array('password'));
        }
		
		if($input['roles'] == 'JE') {
			$input['role_id'] = 3;
			$tanksids = $input['tank_ids'];
			$input['tank_ids'] = json_encode($tanksids);
		}
		if($input['roles'] == 'PO') {
			$input['role_id'] = 4;
			$tanksids = $input['tank_ids'];
			$input['tank_ids'] = json_encode($tanksids);
		}
		if($input['roles'] == 'AE') {
			$input['role_id'] = 2;
		}
		
		//dd($input);

        $user = User::find($id);
        $user->update($input);
        DB::table('model_has_roles')->where('model_id', $id)->delete();

        $user->assignRole($request->input('roles'));

        //return redirect()->route('users.list')->with('success', 'User updated successfully');
		return redirect()->route('users.list')->with('message', 'User updated successfully')->with('status', 'success');	
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id): RedirectResponse
    {
        User::find($id)->delete();
        //return redirect()->route('users.list')->with('success', 'User deleted successfully');
		return redirect()->route('users.list')->with('message', 'User deleted successfully')->with('status', 'success');	
    }
}
