<?php

namespace App\Http\Controllers;

use App\Models\TankMaster;
use App\Models\TankGatewayMapping;
use App\Http\Requests\StoreTankRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

class TankMasterController extends Controller
{
    /**
     * Display a listing of the permission.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
        $this->middleware('permission:tank-list|tank-create|tank-edit|tank-delete', ['only' => ['tankdetails', 'store']]);
        $this->middleware('permission:tank-create', ['only' => ['addtank', 'store']]);
        $this->middleware('permission:tank-edit', ['only' => ['edit', 'update']]);
        //$this->middleware('permission:tank-delete', ['only' => ['destroy']]);
    }
    public function create()
    {
        return view('tank_master.create');
    }


    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'tank_name' => 'required|string|max:255',
            // Add other necessary validations here
        ]);
        $data = $request->all();
		$tankins = TankMaster::create([
            'tank_name' => $data['tank_name'],
            'tank_loc' => $data['tank_loc'],
			'tank_lat_loc' => $data['tank_lat_loc'],
			'tank_long_loc' => $data['tank_long_loc'],
			'address1' => $data['address1'],
			'city' => $data['city'],
			'state' => $data['state'],
			'zip' => $data['zip'],
			'description' => $data['description'],
			'contact_person_name' => $data['contact_person_name'],
			'contact_person_contact_no' => $data['contact_person_contact_no'],
			'contact_person_email' => $data['contact_person_email'],
			'created_by' => 1,
        	]);
			
        $lastInsertedId = $tankins->id;
		$tankname = strtolower(str_replace(' ', '', $data['tank_name']));
		$table_name = 'tank_'.$tankname.'_'.$lastInsertedId;
	
        $imei_ids=array();
        if(isset($request->imei) && count($request->imei))
        {
            foreach($request->imei as $k=>$v)
            {
                $imei_data=array();
                {
                    $tankins = TankGatewayMapping::create([
                        'gateway_no' => $v['no'],
                        'tank_id' => $lastInsertedId,
                        'created_at' => date('Y-m-d'),
                        'created_by' => 1
                        ]);
                    $imei_ids[] = $v['no'];
                }
            }
        }

		$json_array = ['tank_name' =>$tankname, 'tank_id' => $lastInsertedId, 'imei' => $imei_ids, 'file_name' => $table_name ];
        // Call the method to create a new readings table for the tank
        $this->createReadingsTable($table_name);
        // Call the method to create a dynamic file for the tank
        $this->createJsonFileForTank($json_array);
        /*$sql = $query->toSql();
		dd($sql); */
        //return redirect()->route('tankdetails')->with('success', 'Tank added successfully.');
        return redirect()->route('tankdetails')->with('message', 'Tank added successfully.')->with('status', 'success');
    }

    public function addtank()
    {
        return view('addtank');
    }
    /**
     * Display a listing of the tanks.
     */
    public function tankdetails()
    {
        //echo "8585"; exit;
        //$tanks = TankMaster::all();
		$userId = auth('web')->user()->id;
			$user = DB::table('users')->where('id', $userId)->first();
			if($user->role_id == 2 || $user->role_id == 3 || $user->role_id == 4) {
				if ($user && $user->tank_ids) {
					$tankIds = json_decode($user->tank_ids, true);
				
					$tanks = DB::table('tank_masters')
						->whereIn('id', $tankIds)
						->select('id', 'tank_name', 'tank_status_id', 'created_at')
						->get();
				}
			} else {
				$tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name', 'tank_status_id', 'created_at')->get();
			}
        return view('tankdetails', ['tanks' => $tanks]);
    }

    public function tank_imei_check()
    {
        //print "<pre>"; print_r($_GET); 
        $tank_id=$_GET['tank_id'];
        $arr_chk=explode('|',$_GET['send_str']);
        $ids="";
        $ret_arr=array();
        foreach($arr_chk as $k=>$v)
        {
            if($k)
            {
                list($sid,$vval)=explode('>',$v);
                $ids_arr[]=$vval;
                $ret_arr[$vval]=$sid;
            }
        }
        //print print_r($arr_chk); 
        //print print_r($ids_arr); 
        //print_r($ret_arr); 

        if($tank_id)
        {
            $imei = DB::table('tank_gateway_mappings')
            ->select('id','gateway_no')
            ->wherein('gateway_no', $ids_arr)
            ->where('tank_id','<>',$tank_id)
            ->get();
        }
        else
        {
            $imei = DB::table('tank_gateway_mappings')
            ->select('id','gateway_no')
            ->wherein('gateway_no', $ids_arr)
            //->where('tank_id','<>',$tank_id)
            ->get();
        }
        $id_ret='';
        foreach ($imei as $k => $v) 
        {
            $id_ret.=$ret_arr[$v->gateway_no].'|';
        }
        print trim($id_ret,'|');
        exit;
    }

    public function edit($enc_id)
    {
        $id = base64_decode(base64_decode($enc_id));
        $tank = TankMaster::find($id);
        $imei = TankGatewayMapping::where('tank_id', '=', $id)
        ->select('id','gateway_no')->get();
        //print "<pre>"; print_r($imei); print "</pre>";
        return view('edittank', compact('tank','imei'));
    }

    public function update(Request $request)
    {
        //print "<pre>"; print_r($request->imei); print "</pre>";  //exit;
        $data = $request->all();
        $tid = $request->tank_id;
        $tank_data = array(
            'tank_name' => $data['tank_name'],
            'tank_loc' => $data['tank_loc'],
            'tank_lat_loc' => $data['tank_lat_loc'],
            'tank_long_loc' => $data['tank_long_loc'],
            'address1' => $data['address1'],
            'city' => $data['city'],
            'state' => $data['state'],
            'zip' => $data['zip'],
            'description' => $data['description'],
            'contact_person_name' => $data['contact_person_name'],
            'contact_person_contact_no' => $data['contact_person_contact_no'],
            'contact_person_email' => $data['contact_person_email'],
            'updated_at' => date('Y-m-d H:i:s'),
            'updated_by' => 1,
        );
        $update_tank = TankMaster::where('id', '=', $tid)->update($tank_data);
        $imei_ids=array();
        if(isset($request->imei) && count($request->imei))
        {
            foreach($request->imei as $k=>$v)
            {
                $imei_data=array();
                if(isset($v['id']) && $v['id']) //edit
                {
                    $imei_data = array(
                        'gateway_no' => $v['no'],
                        'updated_at' => date('Y-m-d'),
                        'updated_by' => 1
                    );
                    $update_tank = TankGatewayMapping::where('id', '=', $v['id'])->update($imei_data);
                    $imei_ids[] = $v['id'];
                }
                else //insert
                {
                    $tankins = TankGatewayMapping::create([
                        'gateway_no' => $v['no'],
                        'tank_id' => $tid,
                        'created_at' => date('Y-m-d'),
                        'created_by' => 1
                        ]);
                    $imei_ids[] = $tankins->id;
                }
            }
        }
        DB::table('tank_gateway_mappings')->wherenotin('id', $imei_ids)->where('tank_id', $tid)->delete();
        //print "<pre>"; print_r($imei_ids); print "</pre>"; exit;

        // Redirect back with a success message
        //return redirect()->route('tankdetails')->with('success', 'Tank updated successfully.');
        return redirect()->route('tankdetails')->with('message', 'Tank updated successfully.')->with('status', 'success');
    }

    // Method to create the dynamic readings table for the tank
    private function createReadingsTable($table_name)
    {
		//dd($table_name);
        // Generate table name dynamically
        $tableName = $table_name;

        // Create the new table with a schema
        Schema::create($tableName, function (Blueprint $table) {
            $table->bigIncrements('id');                 // Primary key
            $table->string('payload_id');                // Payload ID
            $table->unsignedBigInteger('tank_id');       // Tank ID (foreign key reference)
            $table->unsignedBigInteger('device_id');     // Device ID (foreign key reference)
            $table->double('reading_value');             // Reading value (double)
            $table->string('payload_type');              // Payload type
            $table->double('opr')->nullable();                       // OPR value
            $table->string('opr_unit')->nullable();                  // OPR unit
            $table->double('chlrn')->nullable();                     // Chlorine value
            $table->string('chlrn_unit')->nullable();                // Chlorine unit
            $table->double('tds')->nullable();                       // TDS value
            $table->string('tds_unit')->nullable();                  // TDS unit
            $table->double('ph')->nullable();                        // pH value
            $table->string('ph_unit')->nullable();                   // pH unit
            $table->double('tur')->nullable();                       // Turbidity value
            $table->string('tur_unit')->nullable();                  // Turbidity unit           
            $table->double('water_lvl')->nullable();                 // Water level value
            $table->string('water_lvl_unit')->nullable();            // Water level unit
            $table->double('iron_lvl')->nullable();                 // Iron level value
            $table->string('iron_lv_unit')->nullable();            // Iron level unit
            $table->double('temp')->nullable();                       // Temp value
            $table->tinyInteger('is_deleted')->nullable(); // Soft delete flag
            $table->dateTime('created_at');                // Created date
            $table->unsignedBigInteger('created_by');    // ID of the user who created this record
            $table->unsignedBigInteger('updated_by')->nullable(); // ID of the user who updated this record
            $table->dateTime('updated_at')->nullable();              // Updated on timestamp

            // Indexes
            $table->index('tank_id');                    // Index for tank_id
            $table->index('device_id');                  // Index for device_id
        });
    }

    // Method to create the JSON file for the tank
    private function createJsonFileForTank($tank)
    {
		//dd($tank);
        // Define the filename based on tank_uid
        $fileName = $tank['file_name'].'.json';
        // Define the directory where you want to store the JSON file
        $directory = 'tank_files'; // 'storage/app/tank_data'

        // Sample data for the JSON file (can be changed based on your requirements)
        $jsonData = [
            'tank_id' => $tank['tank_id'],
            'tank_uid' => $tank['imei'],
            'tank_name' => $tank['tank_name'],
            'tank_status' => 1
        ];

        // Convert the array to JSON format
        $jsonContent = json_encode($jsonData, JSON_PRETTY_PRINT);

        // Store the JSON file on the server
        Storage::put($directory . '/' . $fileName, $jsonContent);
    }

    public function tankdata($tank_uid)
    {
        $tableName = 'tank_' . $tank_uid . '_readings'; // Dynamic table name

        if (Schema::hasTable($tableName)) {
            // The table exists, proceed with your logic
            //return response()->json(['message' => $tableName . 'Table exists.'], 200);
            $tankDataQuery = "SELECT DATE(created_at) AS read_date,REPLACE(GROUP_CONCAT(IFNULL(`chlrn`,'')),',','') AS clval, REPLACE(GROUP_CONCAT(IFNULL(`opr`,'')),',','') AS oprval, REPLACE(GROUP_CONCAT(IFNULL(`tds`,'')),',','') AS tdsval, REPLACE(GROUP_CONCAT(IFNULL(`ph`,'')),',','') AS phval, REPLACE(GROUP_CONCAT(IFNULL(`tur`,'')),',','') AS turval, REPLACE(GROUP_CONCAT(IFNULL(`water_lvl`,'')),',','') AS wtrval FROM `tank_" . $tank_uid . "_readings` GROUP BY tank_id, DATE(created_at), HOUR(created_at)";

            $data = DB::select($tankDataQuery);

            //dd($data);
            //return view('tankdata', ['readings' => $data]);
            return view('tankdata', ['readings' => $data, 'tank_uid' => $tank_uid]);
        } else {
            // The table does not exist
            //return response()->json(['error' => $tableName . 'Table does not exist.'], 404);
            return redirect()->route('tankdetails')->with('message', 'Tank data could not be populated.')->with('status', 'error');
        }
    }

    public function tankchart($tank_uid)
    {
        $tableName = 'tank_' . $tank_uid . '_readings'; // Dynamic table name
        $phdata = DB::table($tableName)->select('ph as ph_value_column', 'created_at as time_column')->whereNotNull('ph')->get();
        $oprdata = DB::table($tableName)->select('opr as opr_value_column', 'created_at as time_column')->whereNotNull('opr')->get();
        $chlrndata = DB::table($tableName)->select('chlrn as chlrn_value_column', 'created_at as time_column')->whereNotNull('chlrn')->get();
        $tdsdata = DB::table($tableName)->select('tds as tds_value_column', 'created_at as time_column')->whereNotNull('tds')->get();
        $turdata = DB::table($tableName)->select('tur as tur_value_column', 'created_at as time_column')->whereNotNull('tur')->get();
        $water_lvldata = DB::table($tableName)->select('water_lvl as water_lvl_value_column', 'created_at as time_column')->whereNotNull('water_lvl')->get();

        return view('tankchartview', ['phdata' => $phdata, 'oprdata' => $oprdata, 'chlrndata' => $chlrndata, 'tdsdata' => $tdsdata, 'turdata' => $turdata, 'water_lvldata' => $water_lvldata]);
    }

    public function tankdatahistory($tank_uid, Request $request)
    {
        $tableName = 'tank_' . $tank_uid . '_readings'; // Dynamic table name
        $tankDataQuery = "SELECT DATE(created_at) AS read_date, HOUR(created_at) AS read_hour, REPLACE(GROUP_CONCAT(IFNULL(`chlrn`,'')),',','') AS clval, REPLACE(GROUP_CONCAT(IFNULL(`opr`,'')),',','') AS oprval, REPLACE(GROUP_CONCAT(IFNULL(`tds`,'')),',','') AS tdsval, REPLACE(GROUP_CONCAT(IFNULL(`ph`,'')),',','') AS phval, REPLACE(GROUP_CONCAT(IFNULL(`tur`,'')),',','') AS turval, REPLACE(GROUP_CONCAT(IFNULL(`water_lvl`,'')),',','') AS wtrval FROM `" . $tableName . "` GROUP BY tank_id, DATE(created_at), HOUR(created_at) ORDER BY HOUR(created_at) DESC";

        $data = DB::select($tankDataQuery);

        //dd($data);

        return view('tankhistorydata', compact('data'));
    }
}
