<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cookie;
use App\Models\TankMaster;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\Excel as ExcelType;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class ReportController extends Controller
{
    //
    public function index()
    {
        $fdate = date('Y-m-d'.' 00:00:00');
        $tdate = date('Y-m-d'.' 23:59:59');
        $view_by = 1;
		$userId = auth('web')->user()->id;
			$user = DB::table('users')->where('id', $userId)->first();
			if($user->role_id == 2 || $user->role_id == 3 || $user->role_id == 4) {
				if ($user && $user->tank_ids) {
					$tankIds = json_decode($user->tank_ids, true);
				
					$tanks = DB::table('tank_masters')
						->whereIn('id', $tankIds)
						->select('id', 'tank_name')
						->get();
				}
			} else {
				$tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
			}
			if($user->role_id == 2 || $user->role_id == 3 || $user->role_id == 4) {
				//echo "11"; die;
            	$tank_uid = $tankIds[0];
				$tank_details = DB::table('tank_masters')->where('id', $tank_uid)->select('id', 'tank_name')->first();
            	$tname = strtolower(str_replace(' ', '', $tank_details->tank_name));
				$ctable = 'tank_' . $tname . '_' . $tank_details->id;
			}else{
				//echo "12"; die;
				$tank_uid = '38';
				$tank_details = DB::table('tank_masters')->where('id', $tank_uid)->select('id', 'tank_name')->first();
            	$tname = strtolower(str_replace(' ', '', $tank_details->tank_name));
				$ctable = 'tank_' . $tname . '_' . $tank_details->id;
			}
        //$tank_list = '38';

        // TANK WISE TABULAR DATA REPORT        
        DB::statement("SET sql_mode=''");
        //$ctable = 'tank_shitalpurohr_38';
        $phValues =  DB::table($ctable)->select(DB::raw('MAX(ph) as mxph'), DB::raw('MIN(ph) as miph'), DB::raw('AVG(ph) as midph'), DB::raw('DATE(created_at) as created_date'))->whereNotNull('ph')->whereBetween('created_at', [$fdate, $tdate])->groupBy(DB::raw('DATE(created_at)'))->orderBy(DB::raw('DATE(created_at)'), 'DESC')->get();

       // $oprValues =  DB::table($ctable)->select(DB::raw('MAX(opr) as mxopr'), DB::raw('MIN(opr) as miopr'), DB::raw('AVG(opr) as midopr'), DB::raw('DATE(created_at) as created_date'))->whereNotNull('opr')->whereBetween('created_at', [$fdate, $tdate])->groupBy(DB::raw('DATE(created_at)'))->orderBy(DB::raw('DATE(created_at)'), 'DESC')->get();
	   
	   $oprValues =  DB::table($ctable)->select(DB::raw('MAX(iron_lvl) as mxfe'), DB::raw('MIN(iron_lvl) as mife'), DB::raw('AVG(iron_lvl) as midfe'), DB::raw('DATE(created_at) as created_date'))->whereNotNull('iron_lvl')->whereBetween('created_at', [$fdate, $tdate])->groupBy(DB::raw('DATE(created_at)'))->orderBy(DB::raw('DATE(created_at)'), 'DESC')->get();

        $chlrnValues =  DB::table($ctable)->select(DB::raw('MAX(chlrn) as mxchlrn'), DB::raw('MIN(chlrn) as michlrn'), DB::raw('AVG(chlrn) as midchlrn'), DB::raw('DATE(created_at) as created_date'))->whereNotNull('chlrn')->whereBetween('created_at', [$fdate, $tdate])->groupBy(DB::raw('DATE(created_at)'))->orderBy(DB::raw('DATE(created_at)'), 'DESC')->get();

        $tdsValues =  DB::table($ctable)->select(DB::raw('MAX(tds) as mxtds'), DB::raw('MIN(tds) as mitds'), DB::raw('AVG(tds) as midtds'), DB::raw('DATE(created_at) as created_date'))->whereNotNull('tds')->whereBetween('created_at', [$fdate, $tdate])->groupBy(DB::raw('DATE(created_at)'))->orderBy(DB::raw('DATE(created_at)'), 'DESC')->get();

        $turValues =  DB::table($ctable)->select(DB::raw('MAX(tur) as mxtur'), DB::raw('MIN(tur) as mitur'), DB::raw('AVG(tur) as midtur'), DB::raw('DATE(created_at) as created_date'))->whereNotNull('tur')->whereBetween('created_at', [$fdate, $tdate])->groupBy(DB::raw('DATE(created_at)'))->orderBy(DB::raw('DATE(created_at)'), 'DESC')->get();

        $water_lvlValues =  DB::table($ctable)->select(DB::raw('MAX(water_lvl) as mxwater_lvl'), DB::raw('MIN(water_lvl) as miwater_lvl'), DB::raw('AVG(water_lvl) as midwater_lvl'), DB::raw('DATE(created_at) as created_date'))->whereNotNull('water_lvl')->whereBetween('created_at', [$fdate, $tdate])->orderBy(DB::raw('DATE(created_at)'), 'DESC')->groupBy(DB::raw('DATE(created_at)'))->get();

        $data = [
            'tank_uid' => $tank_uid,
            'phValues' => $phValues,
            'oprValues' => $oprValues,
            'chlrnValues' => $chlrnValues,
            'tdsValues' => $tdsValues,
            'turValues' => $turValues,
            'water_lvlValues' => $water_lvlValues,
            'to_date' => $tdate,
            'from_date' => $fdate,
            'view_by' => $view_by
        ];

        $jsonData = json_encode($data);
        $enc_data = base64_encode($jsonData);
        $data['enc_data'] = $enc_data;
        //$data['all_tanks'] = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
		$userId = auth('web')->user()->id;
			$user = DB::table('users')->where('id', $userId)->first();
			if($user->role_id == 2 || $user->role_id == 3 || $user->role_id == 4) {
				if ($user && $user->tank_ids) {
					$tankIds = json_decode($user->tank_ids, true);
				
				$data['all_tanks'] = DB::table('tank_masters')
						->whereIn('id', $tankIds)
						->select('id', 'tank_name')
						->get();
				}
			} else {
				$data['all_tanks'] = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
			}
        return view('report.historicfirst', $data);
    }

    public function tankDateReport(Request $request)
    {
        $from_date = date('Y-m-d', strtotime($request->fromdate));
        $fdate = $from_date . ' 00:00:00';
        $to_date = date('Y-m-d', strtotime($request->todate));
        $tdate = $to_date . ' 23:59:59';
        $view_by = $request->view_by;
        $tank_list = $request->tank_list;
        $device_type_id = $request->device_type_id;

        // TANK WISE TABULAR DATA REPORT
        if ($view_by == 1) {
            DB::statement("SET sql_mode=''");
            $tank_details = DB::table('tank_masters')->where('id', $tank_list)->select('id', 'tank_name')->first();
            $tname = strtolower(str_replace(' ', '', $tank_details->tank_name));
            $ctable = 'tank_' . $tname . '_' . $tank_details->id;
            //$ctable = 'tank_' . $tank_list . '_readings';
            $phValues =  DB::table($ctable)->select(DB::raw('MAX(ph) as mxph'), DB::raw('MIN(ph) as miph'), DB::raw('AVG(ph) as midph'), DB::raw('DATE(created_at) as created_date'))->whereNotNull('ph')->whereBetween('created_at', [$fdate, $tdate])->groupBy(DB::raw('DATE(created_at)'))->orderBy(DB::raw('DATE(created_at)'), 'DESC')->get();

            $oprValues =  DB::table($ctable)->select(DB::raw('MAX(iron_lvl) as mxfe'), DB::raw('MIN(iron_lvl) as mife'), DB::raw('AVG(iron_lvl) as midfe'), DB::raw('DATE(created_at) as created_date'))->whereNotNull('iron_lvl')->whereBetween('created_at', [$fdate, $tdate])->groupBy(DB::raw('DATE(created_at)'))->orderBy(DB::raw('DATE(created_at)'), 'DESC')->get();

            $chlrnValues =  DB::table($ctable)->select(DB::raw('MAX(chlrn) as mxchlrn'), DB::raw('MIN(chlrn) as michlrn'), DB::raw('AVG(chlrn) as midchlrn'), DB::raw('DATE(created_at) as created_date'))->whereNotNull('chlrn')->whereBetween('created_at', [$fdate, $tdate])->groupBy(DB::raw('DATE(created_at)'))->orderBy(DB::raw('DATE(created_at)'), 'DESC')->get();

            $tdsValues =  DB::table($ctable)->select(DB::raw('MAX(tds) as mxtds'), DB::raw('MIN(tds) as mitds'), DB::raw('AVG(tds) as midtds'), DB::raw('DATE(created_at) as created_date'))->whereNotNull('tds')->whereBetween('created_at', [$fdate, $tdate])->groupBy(DB::raw('DATE(created_at)'))->orderBy(DB::raw('DATE(created_at)'), 'DESC')->get();

            $turValues =  DB::table($ctable)->select(DB::raw('MAX(tur) as mxtur'), DB::raw('MIN(tur) as mitur'), DB::raw('AVG(tur) as midtur'), DB::raw('DATE(created_at) as created_date'))->whereNotNull('tur')->whereBetween('created_at', [$fdate, $tdate])->groupBy(DB::raw('DATE(created_at)'))->orderBy(DB::raw('DATE(created_at)'), 'DESC')->get();

            $water_lvlValues =  DB::table($ctable)->select(DB::raw('MAX(water_lvl) as mxwater_lvl'), DB::raw('MIN(water_lvl) as miwater_lvl'), DB::raw('AVG(water_lvl) as midwater_lvl'), DB::raw('DATE(created_at) as created_date'))->whereNotNull('water_lvl')->whereBetween('created_at', [$fdate, $tdate])->orderBy(DB::raw('DATE(created_at)'), 'DESC')->groupBy(DB::raw('DATE(created_at)'))->get();

            $data = [
                'tank_uid' => $tank_list,
                'phValues' => $phValues,
                'oprValues' => $oprValues,
                'chlrnValues' => $chlrnValues,
                'tdsValues' => $tdsValues,
                'turValues' => $turValues,
                'water_lvlValues' => $water_lvlValues,
                'to_date' => $to_date,
                'from_date' => $from_date,
                'view_by' => $view_by
            ];

            $jsonData = json_encode($data);
            $enc_data = base64_encode($jsonData);
            $data['enc_data'] = $enc_data;
            //$data['all_tanks'] = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
			
			$userId = auth('web')->user()->id;
			$user = DB::table('users')->where('id', $userId)->first();
			if($user->role_id == 2 || $user->role_id == 3 || $user->role_id == 4) {
				if ($user && $user->tank_ids) {
					$tankIds = json_decode($user->tank_ids, true);
				
				$data['all_tanks'] = DB::table('tank_masters')
						->whereIn('id', $tankIds)
						->select('id', 'tank_name')
						->get();
				}
			} else {
				$data['all_tanks'] = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
			}
            return view('report.tankwisereport', $data);
        }
        // KPI WISE TABULAR DATA REPORT
        if ($view_by == 2) {
            DB::statement("SET sql_mode=''");

            /*$tanks = DB::table('tank_masters')
                ->where('tank_status_id', 1)
                ->select('id', 'tank_name')
                ->get();*/
				
			$userId = auth('web')->user()->id;
			$user = DB::table('users')->where('id', $userId)->first();	
			if($user->role_id == 2 || $user->role_id == 3 || $user->role_id == 4) {
				if ($user && $user->tank_ids) {
					$tankIds = json_decode($user->tank_ids, true);
					
				$tanks = DB::table('tank_masters')->whereIn('id', $tankIds)->select('id', 'tank_name')->get();
					}
			} else {
				$tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
			}		
				
            $results = [];
            foreach ($tanks as $table) {
                $tname = strtolower(str_replace(' ', '', $table->tank_name));
                $ctable = 'tank_' . $tname . '_' . $table->id;

                // Query each table dynamically
                $results[$table->tank_name]['tank_name'] = $table->tank_name;
                $phValues =  DB::table($ctable)
                    ->select(
                        DB::raw('MAX(' . $device_type_id . ') as mxph'),
                        DB::raw('MIN(' . $device_type_id . ') as miph'),
                        DB::raw('AVG(' . $device_type_id . ') as midph'),
                        DB::raw('DATE(created_at) as created_date')
                    )
                    ->whereNotNull($device_type_id)
                    ->whereBetween('created_at', [$fdate, $tdate])
                    ->groupBy(DB::raw('DATE(created_at)'))
                    ->orderBy(DB::raw('DATE(created_at)'), 'DESC')
                    ->get();

                $results[$table->tank_name]['result'] = $phValues;
            }

            $data = [
                'readings' => $results,
                'param_val' => $device_type_id,
                'from_date' => $from_date,
                'to_date' => $to_date,
                'view_by' => $view_by
            ];

            $jsonData = json_encode($data);
            $enc_data = base64_encode($jsonData);
            $data['enc_data'] = $enc_data;
			if($user->role_id == 2 || $user->role_id == 3 || $user->role_id == 4) {
				if ($user && $user->tank_ids) {
					$tankIds = json_decode($user->tank_ids, true);
					
				$data['all_tanks'] = DB::table('tank_masters')->whereIn('id', $tankIds)->select('id', 'tank_name')->get();
					}
			} else {
				$data['all_tanks'] = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
			}            
            return view('report.daterangereport', $data);
        }
    }

    public function tankwisechart($encdata)
    {
        $cookieData = base64_decode($encdata);

        if ($cookieData) {
            $data = json_decode($cookieData, true);
            $tank_uid = $data['tank_uid'] ?? null;
            $phValues = $data['phValues'] ?? null;
            $oprValues = $data['oprValues'] ?? null;
            $chlrnValues = $data['chlrnValues'] ?? null;
            $tdsValues = $data['tdsValues'] ?? null;
            $turValues = $data['turValues'] ?? null;
            $water_lvlValues = $data['water_lvlValues'] ?? null;
            $from_date = $data['from_date'] ?? null;
            $to_date = $data['to_date'] ?? null;
            $view_by = $data['view_by'] ?? null;

            //dd($oprValues);
			
			$userId = auth('web')->user()->id;
			$user = DB::table('users')->where('id', $userId)->first();	
			if($user->role_id == 2 || $user->role_id == 3 || $user->role_id == 4) {
				if ($user && $user->tank_ids) {
					$tankIds = json_decode($user->tank_ids, true);
					
				$all_tanks = DB::table('tank_masters')->whereIn('id', $tankIds)->select('id', 'tank_name')->get();
					}
			} else {
				$all_tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
			}	

            //$all_tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
            return view('report.tankchartview', ['phValues' => $phValues, 'oprValues' => $oprValues, 'chlrnValues' => $chlrnValues, 'tdsValues' => $tdsValues, 'turValues' => $turValues, 'water_lvlValues' => $water_lvlValues, 'from_date' => $from_date, 'to_date' => $to_date, 'tank_uid' => $tank_uid, 'view_by' => $view_by, 'all_tanks' => $all_tanks]);
        } else {
            return redirect()->route('selectrange')->with('success', 'Please select parameters for the report.');
        }
    }

    public function daterangechart($encdata)
    {
        $cookieData = base64_decode($encdata);

        if ($cookieData) {
            $data = json_decode($cookieData, true);
            $readings = $data['readings'] ?? null;
            $param_val = $data['param_val'] ?? null;
            $from_date = $data['from_date'] ?? null;
            $to_date = $data['to_date'] ?? null;
            $view_by = $data['view_by'] ?? null;
            //$all_tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
			
			$userId = auth('web')->user()->id;
			$user = DB::table('users')->where('id', $userId)->first();	
			if($user->role_id == 2 || $user->role_id == 3 || $user->role_id == 4) {
				if ($user && $user->tank_ids) {
					$tankIds = json_decode($user->tank_ids, true);
					
				$all_tanks = DB::table('tank_masters')->whereIn('id', $tankIds)->select('id', 'tank_name')->get();
					}
			} else {
				$all_tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
			}
			
            return view('report.daterangechartview', ['readings' => $readings, 'param_val' => $param_val, 'from_date' => $from_date, 'to_date' => $to_date, 'view_by' => $view_by, 'all_tanks' => $all_tanks]);
        } else {
            return redirect()->route('selectrange')->with('success', 'Please select parameters for the report.');
        }
    }

    public function tankwiserange(Request $request)
    {
        //$tanks = TankMaster::all();
        //return view('report.selecttankwiserange', compact('tanks'));

        if ($request->input('sval') == 1) {
            $fdate = date('Y-m-d H:i:s', strtotime($request->input('fromdate') . ' 00:00:00'));
            $tdate = date('Y-m-d H:i:s', strtotime($request->input('todate') . ' 23:59:59'));
            $tid = $request->input('tank_list');
            $tank_details = DB::table('tank_masters')->where('id', $tid)->select('id', 'tank_name')->first();
            $tname = strtolower(str_replace(' ', '', $tank_details->tank_name));
            $ctable = 'tank_' . $tname . '_' . $tank_details->id;
            $tableName = 'tank_' . $tname . '_' . $tank_details->id;
            //$ctable = 'tank_' . $request->input('tank_list') . '_readings';
            $sval = 1;

            $tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
            $water_measures = DB::table('water_health_measures')->where('is_deleted', 0)->select('param_name', 'param_max_value', 'param_min_value')->get()->toArray();
            $measures = [];
            foreach ($water_measures as $item) {
                $measures[$item->param_name] = $item;
            }
            //-----------------------For PH-----------------------------------------------------
            $results = DB::select('CALL GetPhAverages(?, ?, ?)', [$fdate, $tdate, $tableName]);

            $data = [];
            $categories = [];
            foreach ($results as $row) {
                $categories[] = $row->period;  // X-axis labels
                $avg_val = (float) $row->average_ph;
                $data[] = round($avg_val, 2);  // Y-axis values
            }
            //-----------------------For OPR-----------------------------------------------------
            $oprresults = DB::select('CALL GetParamAverages(?, ?, ?, ?)', [$fdate, $tdate, $tableName, 'iron_lvl']);

            $oprdata = [];
            $oprcategories = [];
            foreach ($oprresults as $row) {
                $oprcategories[] = $row->period;  // X-axis labels
                $avg_val = (float) $row->average_value;
                $oprdata[] = round($avg_val, 2);  // Y-axis values
            }
            //-----------------------For chlrn-----------------------------------------------------
            $chlrnresults = DB::select('CALL GetParamAverages(?, ?, ?, ?)', [$fdate, $tdate, $tableName, 'chlrn']);

            $chlrndata = [];
            $chlrncategories = [];
            foreach ($chlrnresults as $row) {
                $chlrncategories[] = $row->period;  // X-axis labels
                $avg_val = (float) $row->average_value;
                $chlrndata[] = round($avg_val, 2);  // Y-axis values
            }
            //-----------------------For tds-----------------------------------------------------
            $tdsresults = DB::select('CALL GetParamAverages(?, ?, ?, ?)', [$fdate, $tdate, $tableName, 'tds']);

            $tdsdata = [];
            $tdscategories = [];
            foreach ($tdsresults as $row) {
                $tdscategories[] = $row->period;  // X-axis labels
                $avg_val = (float) $row->average_value;
                $tdsdata[] = round($avg_val, 2);  // Y-axis values
            }
            //-----------------------For tur-----------------------------------------------------
            $turresults = DB::select('CALL GetParamAverages(?, ?, ?, ?)', [$fdate, $tdate, $tableName, 'tur']);

            $turdata = [];
            $turcategories = [];
            foreach ($turresults as $row) {
                $turcategories[] = $row->period;  // X-axis labels
                $avg_val = (float) $row->average_value;
                $turdata[] = round($avg_val, 2);  // Y-axis values
            }
            //-----------------------For water_lvl-----------------------------------------------------
            $water_lvlresults = DB::select('CALL GetParamAverages(?, ?, ?, ?)', [$fdate, $tdate, $tableName, 'water_lvl']);

            $water_lvldata = [];
            $water_lvlcategories = [];
            foreach ($water_lvlresults as $row) {
                $water_lvlcategories[] = $row->period;  // X-axis labels
                $avg_val = (float) $row->average_value;
                $water_lvldata[] = round($avg_val, 2);  // Y-axis values
            }

            return view('report.tankwisechartview', ['measures' => $measures, 'categories' => $categories, 'data' => $data, 'oprcategories' => $oprcategories, 'oprdata' => $oprdata, 'chlrncategories' => $chlrncategories, 'chlrndata' => $chlrndata, 'tdscategories' => $tdscategories, 'tdsdata' => $tdsdata, 'turcategories' => $turcategories, 'turdata' => $turdata, 'water_lvlcategories' => $water_lvlcategories, 'water_lvldata' => $water_lvldata, 'fdate' => $fdate, 'tdate' => $tdate, 'tname' => $tid, 'tanks' => $tanks, 'sval' => $sval]);
        } else {
            $fdate = '2024-10-01 00:00:00';
            $tdate = '2024-10-03  23:59:59';
            $tname = '57';
            $tableName = 'tank_nayapatti_57';
            $ctable = 'tank_nayapatti_57';
            $sval = 0;

            $tanks = DB::table('tank_masters')->where('tank_status_id', 1)->select('id', 'tank_name')->get();
            $water_measures = DB::table('water_health_measures')->where('is_deleted', 0)->select('param_name', 'param_max_value', 'param_min_value')->get()->toArray();
            $measures = [];
            foreach ($water_measures as $item) {
                $measures[$item->param_name] = $item;
            }
            //-----------------------For PH-----------------------------------------------------
            $results = DB::select('CALL GetPhAverages(?, ?, ?)', [$fdate, $tdate, $tableName]);

            $data = [];
            $categories = [];
            foreach ($results as $row) {
                $categories[] = $row->period;  // X-axis labels
                $avg_val = (float) $row->average_ph;
                $data[] = round($avg_val, 2);  // Y-axis values
            }
            //-----------------------For OPR/Iron-----------------------------------------------------
            $oprresults = DB::select('CALL GetParamAverages(?, ?, ?, ?)', [$fdate, $tdate, $tableName, 'iron_lvl']);

            $oprdata = [];
            $oprcategories = [];
            foreach ($oprresults as $row) {
                $oprcategories[] = $row->period;  // X-axis labels
                $avg_val = (float) $row->average_value;
                $oprdata[] = round($avg_val, 2);  // Y-axis values
            }
            //-----------------------For chlrn-----------------------------------------------------
            $chlrnresults = DB::select('CALL GetParamAverages(?, ?, ?, ?)', [$fdate, $tdate, $tableName, 'chlrn']);

            $chlrndata = [];
            $chlrncategories = [];
            foreach ($chlrnresults as $row) {
                $chlrncategories[] = $row->period;  // X-axis labels
                $avg_val = (float) $row->average_value;
                $chlrndata[] = round($avg_val, 2);  // Y-axis values
            }
            //-----------------------For tds-----------------------------------------------------
            $tdsresults = DB::select('CALL GetParamAverages(?, ?, ?, ?)', [$fdate, $tdate, $tableName, 'tds']);

            $tdsdata = [];
            $tdscategories = [];
            foreach ($tdsresults as $row) {
                $tdscategories[] = $row->period;  // X-axis labels
                $avg_val = (float) $row->average_value;
                $tdsdata[] = round($avg_val, 2);  // Y-axis values
            }
            //-----------------------For tur-----------------------------------------------------
            $turresults = DB::select('CALL GetParamAverages(?, ?, ?, ?)', [$fdate, $tdate, $tableName, 'tur']);

            $turdata = [];
            $turcategories = [];
            foreach ($turresults as $row) {
                $turcategories[] = $row->period;  // X-axis labels
                $avg_val = (float) $row->average_value;
                $turdata[] = round($avg_val, 2);  // Y-axis values
            }
            //-----------------------For water_lvl-----------------------------------------------------
            $water_lvlresults = DB::select('CALL GetParamAverages(?, ?, ?, ?)', [$fdate, $tdate, $tableName, 'water_lvl']);

            $water_lvldata = [];
            $water_lvlcategories = [];
            foreach ($water_lvlresults as $row) {
                $water_lvlcategories[] = $row->period;  // X-axis labels
                $avg_val = (float) $row->average_value;
                $water_lvldata[] = round($avg_val, 2);  // Y-axis values
            }

            return view('report.tankwisechartview', ['measures' => $measures, 'categories' => $categories, 'data' => $data, 'oprcategories' => $oprcategories, 'oprdata' => $oprdata, 'chlrncategories' => $chlrncategories, 'chlrndata' => $chlrndata, 'tdscategories' => $tdscategories, 'tdsdata' => $tdsdata, 'turcategories' => $turcategories, 'turdata' => $turdata, 'water_lvlcategories' => $water_lvlcategories, 'water_lvldata' => $water_lvldata, 'fdate' => $fdate, 'tdate' => $tdate, 'tname' => $tname, 'tanks' => $tanks, 'sval' => $sval]);
        }
    }

    public function excelTankWiseData($encdata)
    {
        $cookieData = base64_decode($encdata);

        if ($cookieData) {
            $data = json_decode($cookieData, true);
            $tank_uid = $data['tank_uid'] ?? null;
            $phValues = $data['phValues'] ?? null;
            $oprValues = $data['oprValues'] ?? null;
            $chlrnValues = $data['chlrnValues'] ?? null;
            $tdsValues = $data['tdsValues'] ?? null;
            $turValues = $data['turValues'] ?? null;
            $water_lvlValues = $data['water_lvlValues'] ?? null;
            $from_date = $data['from_date'] ?? null;
            $to_date = $data['to_date'] ?? null;

            // Create a new spreadsheet instance
            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Add Report File Information
            $sheet->mergeCells('A1:F1');
            $sheet->setCellValue('A1', 'Tank wise data report for tank' . $tank_uid);
            $sheet->mergeCells('A3:F3');
            $sheet->setCellValue('A3', 'Date range From: ' . \Carbon\Carbon::parse($from_date)->format("d-m-Y") . ' To: ' . \Carbon\Carbon::parse($to_date)->format('d-m-Y'));

            $rowNumber = 4;
            //$rowNumber++;
            //$sheet->setCellValue('A' . $rowNumber, 'pH report for tank');
            $rowNumber++;  // Start from the second row after headers
            $sheet->setCellValue('A' . $rowNumber, 'Date');
            $sheet->setCellValue('B' . $rowNumber, 'Parameter');
            $sheet->setCellValue('C' . $rowNumber, 'Unit');
            $sheet->setCellValue('D' . $rowNumber, 'Maximum');
            $sheet->setCellValue('E' . $rowNumber, 'Average');
            $sheet->setCellValue('F' . $rowNumber, 'Minimum');
            $rowNumber++;
            foreach ($phValues as $phData) {
                $sheet->setCellValue('A' . $rowNumber, \Carbon\Carbon::parse($phData['created_date'])->format("d-m-Y"));
                $sheet->setCellValue('B' . $rowNumber, 'pH');
                $sheet->setCellValue('C' . $rowNumber, '');
                $sheet->setCellValue('D' . $rowNumber, number_format((float)($phData['mxph']), 2));
                $sheet->setCellValue('E' . $rowNumber, number_format((float)($phData['midph']), 2));
                $sheet->setCellValue('F' . $rowNumber, number_format((float)($phData['miph']), 2));
                $sheet->getStyle('D' . $rowNumber . ':F' . $rowNumber)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_00);
                $rowNumber++;
            }
            /*$rowNumber++;

            $sheet->setCellValue('A' . $rowNumber, 'OPR report for tank(mV)');
            $rowNumber++;
            $sheet->setCellValue('A' . $rowNumber, 'Date');
            $sheet->setCellValue('B' . $rowNumber, 'Maximum');
            $sheet->setCellValue('C' . $rowNumber, 'Average');
            $sheet->setCellValue('D' . $rowNumber, 'Minimum');
            $rowNumber++;*/
            foreach ($oprValues as $oprData) {
                $sheet->setCellValue('A' . $rowNumber, \Carbon\Carbon::parse($oprData['created_date'])->format("d-m-Y"));
                $sheet->setCellValue('B' . $rowNumber, 'IRON');
                $sheet->setCellValue('C' . $rowNumber, 'mg/L');
                $sheet->setCellValue('D' . $rowNumber, number_format((float)($oprData['mxfe']), 2));
                $sheet->setCellValue('E' . $rowNumber, number_format((float)($oprData['midfe']), 2));
                $sheet->setCellValue('F' . $rowNumber, number_format((float)($oprData['mife']), 2));
                $sheet->getStyle('D' . $rowNumber . ':F' . $rowNumber)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_00);
                $rowNumber++;
            }
            /*$rowNumber++;

            $sheet->setCellValue('A' . $rowNumber, 'Ch report for tank (mg/L)');
            $rowNumber++;
            $sheet->setCellValue('A' . $rowNumber, 'Date');
            $sheet->setCellValue('B' . $rowNumber, 'Maximum');
            $sheet->setCellValue('C' . $rowNumber, 'Average');
            $sheet->setCellValue('D' . $rowNumber, 'Minimum');
            $rowNumber++;*/
            foreach ($chlrnValues as $chlrnData) {
                $sheet->setCellValue('A' . $rowNumber, \Carbon\Carbon::parse($chlrnData['created_date'])->format("d-m-Y"));
                $sheet->setCellValue('B' . $rowNumber, 'CH');
                $sheet->setCellValue('C' . $rowNumber, 'mg/L');
                $sheet->setCellValue('D' . $rowNumber, number_format((float)($chlrnData['mxchlrn']), 2));
                $sheet->setCellValue('E' . $rowNumber, number_format((float)($chlrnData['midchlrn']), 2));
                $sheet->setCellValue('F' . $rowNumber, number_format((float)($chlrnData['michlrn']), 2));
                $sheet->getStyle('D' . $rowNumber . ':F' . $rowNumber)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_00);
                $rowNumber++;
            }
            /*$rowNumber++;

            $sheet->setCellValue('A' . $rowNumber, 'TDS report for tank (mg/L)');
            $rowNumber += 2;
            $sheet->setCellValue('A' . $rowNumber, 'Date');
            $sheet->setCellValue('B' . $rowNumber, 'Maximum');
            $sheet->setCellValue('C' . $rowNumber, 'Average');
            $sheet->setCellValue('D' . $rowNumber, 'Minimum');
            $rowNumber++;*/
            foreach ($tdsValues as $tdsData) {
                $sheet->setCellValue('A' . $rowNumber, \Carbon\Carbon::parse($tdsData['created_date'])->format("d-m-Y"));
                $sheet->setCellValue('B' . $rowNumber, 'TDS');
                $sheet->setCellValue('C' . $rowNumber, 'mg/L');
                $sheet->setCellValue('D' . $rowNumber, number_format((float)($tdsData['mxtds']), 2));
                $sheet->setCellValue('E' . $rowNumber, number_format((float)($tdsData['midtds']), 2));
                $sheet->setCellValue('F' . $rowNumber, number_format((float)($tdsData['mitds']), 2));
                $sheet->getStyle('D' . $rowNumber . ':F' . $rowNumber)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_00);
                $rowNumber++;
            }
            /*$rowNumber++;

            $sheet->setCellValue('A' . $rowNumber, 'TUR report for tank (NTU)');
            $rowNumber++;
            $sheet->setCellValue('A' . $rowNumber, 'Date');
            $sheet->setCellValue('B' . $rowNumber, 'Maximum');
            $sheet->setCellValue('C' . $rowNumber, 'Average');
            $sheet->setCellValue('D' . $rowNumber, 'Minimum');
            $rowNumber++;*/
            foreach ($turValues as $turData) {
                $sheet->setCellValue('A' . $rowNumber, \Carbon\Carbon::parse($turData['created_date'])->format("d-m-Y"));
                $sheet->setCellValue('B' . $rowNumber, 'TUR');
                $sheet->setCellValue('C' . $rowNumber, 'NTU');
                $sheet->setCellValue('D' . $rowNumber, number_format((float)($turData['mxtur']), 2));
                $sheet->setCellValue('E' . $rowNumber, number_format((float)($turData['midtur']), 2));
                $sheet->setCellValue('F' . $rowNumber, number_format((float)($turData['mitur']), 2));
                $sheet->getStyle('D' . $rowNumber . ':F' . $rowNumber)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_00);
                $rowNumber++;
            }
            /*$rowNumber++;

            $sheet->setCellValue('A' . $rowNumber, 'Water Level report for tank (M)');
            $rowNumber++;
            $sheet->setCellValue('A' . $rowNumber, 'Date');
            $sheet->setCellValue('B' . $rowNumber, 'Maximum');
            $sheet->setCellValue('C' . $rowNumber, 'Average');
            $sheet->setCellValue('D' . $rowNumber, 'Minimum');
            $rowNumber++;*/
            foreach ($water_lvlValues as $water_lvlData) {
                $sheet->setCellValue('A' . $rowNumber, \Carbon\Carbon::parse($water_lvlData['created_date'])->format("d-m-Y"));
                $sheet->setCellValue('B' . $rowNumber, 'Water Level');
                $sheet->setCellValue('C' . $rowNumber, 'M');
                $sheet->setCellValue('D' . $rowNumber, number_format((float)($water_lvlData['mxwater_lvl']), 2));
                $sheet->setCellValue('E' . $rowNumber, number_format((float)($water_lvlData['midwater_lvl']), 2));
                $sheet->setCellValue('F' . $rowNumber, number_format((float)($water_lvlData['miwater_lvl']), 2));
                $sheet->getStyle('D' . $rowNumber . ':F' . $rowNumber)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_00);
                $rowNumber++;
            }


            // Create the writer to export to Excel
            $writer = new Xlsx($spreadsheet);

            // Prepare the response
            $fileName = 'tank_wise_excel_report_' . \Carbon\Carbon::now() . '.xlsx';

            // Set headers for download
            $response = response()->streamDownload(function () use ($writer) {
                $writer->save('php://output');
            }, $fileName);

            // Return the file as a download
            return $response;
        } else {
            return redirect()->route('selectrange')->with('success', 'Please select parameters for the report.');
        }
    }

    public function excelDateRangeData($encdata)
    {
        $cookieData = base64_decode($encdata);

        if ($cookieData) {
            $data = json_decode($cookieData, true);
            $readings = $data['readings'] ?? null;
            $param_val = $data['param_val'] ?? null;
            $from_date = $data['from_date'] ?? null;
            $to_date = $data['to_date'] ?? null;
            $view_by = $data['view_by'] ?? null;

            // Create a new spreadsheet instance
            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Add Report File Information
            $sheet->mergeCells('A1:D1');
            $sheet->setCellValue('A1', 'KPI wise data report for paramenter' . strtoupper($param_val));
            $sheet->setCellValue('A3', 'From: ' . \Carbon\Carbon::parse($from_date)->format("d-m-Y") . ' To: ' . \Carbon\Carbon::parse($to_date)->format('d-m-Y'));

            $rowNumber = 4;
            foreach ($readings as $tankId => $readingData) {
                $sheet->setCellValue('A' . $rowNumber, 'Readings for tank: ' . $readingData['tank_name']);
                $rowNumber++;
                if (!empty($readingData['result'])) {
                    $sheet->setCellValue('A' . $rowNumber, 'Date');
                    $sheet->setCellValue('B' . $rowNumber, 'Maximum');
                    $sheet->setCellValue('C' . $rowNumber, 'Average');
                    $sheet->setCellValue('D' . $rowNumber, 'Minimum');
                    $rowNumber++;
                    foreach ($readingData['result'] as $rowData) {
                        $sheet->setCellValue('A' . $rowNumber, \Carbon\Carbon::parse($rowData['created_date'])->format("d-m-Y"));
                        $sheet->setCellValue('B' . $rowNumber, number_format((float)($rowData['mxph']), 2));
                        $sheet->setCellValue('C' . $rowNumber, number_format((float)($rowData['midph']), 2));
                        $sheet->setCellValue('D' . $rowNumber, number_format((float)($rowData['miph']), 2));
                        $sheet->getStyle('B' . $rowNumber . ':D' . $rowNumber)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_00);
                        $rowNumber++;
                    }
                } else {
                    $sheet->mergeCells('A' . $rowNumber . ':D' . $rowNumber);
                    $sheet->setCellValue('A' . $rowNumber, 'No data available for this tank');
                    $rowNumber++;
                }
            }


            // Create the writer to export to Excel
            $writer = new Xlsx($spreadsheet);

            // Prepare the response
            $fileName = 'kpi_wise_excel_report_' . \Carbon\Carbon::now() . '.xlsx';

            // Set headers for download
            $response = response()->streamDownload(function () use ($writer) {
                $writer->save('php://output');
            }, $fileName);

            // Return the file as a download
            return $response;
        } else {
            return redirect()->route('selectrange')->with('success', 'Please select parameters for the report.');
        }
    }

    public function dailyTankData(Request $request)
    {
        $tanks = TankMaster::all();
        if ($request->isMethod('post')) {
            $fdate = date('Y-m-d H:i:s', strtotime($request->input('fromdate') . ' 00:00:00'));
            $tdate = date('Y-m-d H:i:s', strtotime($request->input('todate') . ' 23:59:59'));
            $tank_uid = $request->input('tank_list');
            $tableName = 'tank_' . $request->input('tank_list') . '_readings';

            $tankDataQuery = "SELECT DATE(created_at) AS read_date, HOUR(created_at) AS read_hour, REPLACE(GROUP_CONCAT(IFNULL(`chlrn`,'')),',','') AS clval, REPLACE(GROUP_CONCAT(IFNULL(`opr`,'')),',','') AS oprval, REPLACE(GROUP_CONCAT(IFNULL(`tds`,'')),',','') AS tdsval, REPLACE(GROUP_CONCAT(IFNULL(`ph`,'')),',','') AS phval, REPLACE(GROUP_CONCAT(IFNULL(`tur`,'')),',','') AS turval, REPLACE(GROUP_CONCAT(IFNULL(`water_lvl`,'')),',','') AS wtrval FROM `" . $tableName . "` WHERE created_at BETWEEN '" . $fdate . "' AND '" . $tdate . "' GROUP BY tank_id, DATE(created_at), HOUR(created_at) ORDER BY DATE(created_at) DESC, HOUR(created_at) DESC";

            $records = DB::select($tankDataQuery);
            $data = [
                'readings' => $records,
                'fdate' => $fdate,
                'tdate' => $tdate,
                'tank_uid' => $tank_uid
            ];
            $jsonData = json_encode($data);
            $enc_data = base64_encode($jsonData);
            $data['enc_data'] = $enc_data;
            $data['tanks'] = $tanks;
            //dd($data);
            //return view('tankdata', ['readings' => $data]);
            return view('report.dailytankdata', $data);
        } else {
            $fdate = '';
            $tdate = '';
            $tank_uid = '';
            $data = [
                'fdate' => $fdate,
                'tdate' => $tdate,
                'tank_uid' => $tank_uid,
                'tanks' => $tanks
            ];
            return view('report.dailytankdata', $data);
        }
    }

    public function dailyTankChart($tank_uid)
    {
        $dec_data = base64_decode($tank_uid);
        $data = json_decode($dec_data, true);
        $fdate = $data['fdate'];
        $tdate = $data['tdate'];
        $tankuid = $data['tank_uid'];
        $tanks = TankMaster::all();

        $tableName = 'tank_' . $tankuid . '_readings'; // Dynamic table name
        $phdata = DB::table($tableName)->select('ph as ph_value_column', 'created_at as time_column')->whereNotNull('ph')->whereBetween('created_at', [$fdate, $tdate])->get();
        $oprdata = DB::table($tableName)->select('opr as opr_value_column', 'created_at as time_column')->whereNotNull('opr')->whereBetween('created_at', [$fdate, $tdate])->get();
        $chlrndata = DB::table($tableName)->select('chlrn as chlrn_value_column', 'created_at as time_column')->whereNotNull('chlrn')->whereBetween('created_at', [$fdate, $tdate])->get();
        $tdsdata = DB::table($tableName)->select('tds as tds_value_column', 'created_at as time_column')->whereNotNull('tds')->whereBetween('created_at', [$fdate, $tdate])->get();
        $turdata = DB::table($tableName)->select('tur as tur_value_column', 'created_at as time_column')->whereNotNull('tur')->whereBetween('created_at', [$fdate, $tdate])->get();
        $water_lvldata = DB::table($tableName)->select('water_lvl as water_lvl_value_column', 'created_at as time_column')->whereNotNull('water_lvl')->whereBetween('created_at', [$fdate, $tdate])->get();

        return view('report.dailytankchart', ['tank_uid' => $tankuid, 'phdata' => $phdata, 'oprdata' => $oprdata, 'chlrndata' => $chlrndata, 'tdsdata' => $tdsdata, 'turdata' => $turdata, 'water_lvldata' => $water_lvldata, 'fdate' => $fdate, 'tdate' => $tdate, 'tanks' => $tanks]);
    }

    public function excelDailyTank($encdata)
    {

        $cookieData = base64_decode($encdata);

        if ($cookieData) {
            $data = json_decode($cookieData, true);
            $tank_uid = $data['tank_uid'] ?? null;
            $from_date = $data['from_date'] ?? null;
            $to_date = $data['to_date'] ?? null;
            $records = $data['readings'] ?? null;

            // Create a new spreadsheet instance
            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Add Report File Information
            $sheet->mergeCells('A1:D1');
            $sheet->setCellValue('A1', 'Daily Summary Of Tank Data' . $tank_uid);
            $sheet->setCellValue('A3', 'From: ' . \Carbon\Carbon::parse($from_date)->format("d-m-Y") . ' To: ' . \Carbon\Carbon::parse($to_date)->format('d-m-Y'));

            $rowNumber = 4;
            $rowNumber++;  // Start from the second row after headers
            $sheet->setCellValue('A' . $rowNumber, 'Time');
            $sheet->setCellValue('B' . $rowNumber, 'pH');
            $sheet->setCellValue('C' . $rowNumber, 'Turbidity (NTU)');
            $sheet->setCellValue('D' . $rowNumber, 'Chlorine (mg/L)');
            $sheet->setCellValue('E' . $rowNumber, 'TDS (mg/L)');
            $sheet->setCellValue('F' . $rowNumber, 'Water Level (mtr)');
            $sheet->setCellValue('G' . $rowNumber, 'Iron Level (mg/L)');
            $rowNumber++;
            //dd($records);
            foreach ($records as $reading) {
                $sheet->setCellValue('A' . $rowNumber, \Carbon\Carbon::parse($reading['read_date'])->format('d-m-Y') . \Carbon\Carbon::createFromTime($reading['read_hour'])->format(' g A'));
                $sheet->setCellValue('B' . $rowNumber, number_format((float)($reading['phval']), 2));
                $sheet->setCellValue('C' . $rowNumber, number_format((float)($reading['turval']), 2));
                $sheet->setCellValue('D' . $rowNumber, number_format((float)($reading['clval']), 2));
                $sheet->setCellValue('E' . $rowNumber, number_format((float)($reading['tdsval']), 2));
                $sheet->setCellValue('F' . $rowNumber, number_format((float)($reading['wtrval']), 2));
                $sheet->setCellValue('G' . $rowNumber, number_format((float)($reading['oprval']), 2));
                $sheet->getStyle('B' . $rowNumber . ':G' . $rowNumber)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_00);
                $rowNumber++;
            }
            $rowNumber++;

            // Create the writer to export to Excel
            $writer = new Xlsx($spreadsheet);

            // Prepare the response
            $fileName = 'tank_daily_excel_report_' . \Carbon\Carbon::now() . '.xlsx';

            // Set headers for download
            $response = response()->streamDownload(function () use ($writer) {
                $writer->save('php://output');
            }, $fileName);

            // Return the file as a download
            return $response;
        } else {
            return redirect()->route('selectrange')->with('success', 'Please select parameters for the report.');
        }
    }
}
