<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use App\Models\PortalConfigSetting;
use App\Models\TankMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PortalConfigSettingsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
        $this->middleware('permission:settings-list|settings-create|settings-edit|settings-delete', ['only' => ['index']]);
        $this->middleware('permission:settings-create', ['only' => ['create', 'store']]);
        $this->middleware('permission:settings-edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:settings-delete', ['only' => ['destroy']]);
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //$configs =  PortalConfigSetting::all();
        //$tanks = TankMaster::all();
        $configs = DB::select('SELECT pcs.*, tm.tank_name, tm.id as tank_id FROM portal_config_settings pcs LEFT JOIN tank_masters tm ON tm.id = pcs.value ORDER BY pcs.key;');
        return view('list_settings', ['configs' => $configs]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('add_settings');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'key' => 'required|max:255',
            'value' => 'required|max:255',
        ]);
        $validatedData['alpha_id'] = hash('sha256', $request->key);;
        $validatedData['created_by'] = Auth::id();

        PortalConfigSetting::create($validatedData);

        return redirect()->route('list_config');
    }

    /**
     * Display the specified resource.
     */
    public function show(PortalConfigSetting $portalConfigSetting)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($alpha_id)
    {
        $config = PortalConfigSetting::where('alpha_id', $alpha_id)->firstOrFail();
        $tanks = TankMaster::all();
        return view('edit_settings', ['config' => $config, 'tanks' => $tanks]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $data = $request->all();
        $cnfgId = $request->config_id;
        if ($cnfgId == 2) {
            $request->validate([
                'value' => ['required', function ($attribute, $value, $fail) {
                    // Split the input by commas and trim any extra whitespace
                    $emails = array_map('trim', explode(',', $value));

                    // Validate each email
                    foreach ($emails as $email) {
                        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                            $fail('The ' . $attribute . ' must be a comma-separated list of valid email addresses.');
                        }
                    }
                }],
            ]);
        } else if ($cnfgId == 3) {
            $request->validate([
                'phone_numbers' => ['required', function ($attribute, $value, $fail) {
                    // Split the input by commas and trim any extra whitespace
                    $numbers = array_map('trim', explode(',', $value));

                    // Define a regex for 10-digit numbers
                    $regex = '/^\d{10}$/';

                    // Validate each number
                    foreach ($numbers as $number) {
                        if (!preg_match($regex, $number)) {
                            $fail('The ' . $attribute . ' must be a comma-separated list of 10-digit numbers.');
                        }
                    }
                }],
            ]);
        }
        $config_data = array(
            'value' => $data['value'],
            'updated_at' => date('Y-m-d H:i:s'),
            'updated_by' => Auth::id(),
        );
        $update_config = PortalConfigSetting::where('id', '=', $cnfgId)->update($config_data);
        // Redirect back with a success message
        return redirect()->route('list_config')->with('success', 'Configuration updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(PortalConfigSetting $portalConfigSetting)
    {
        //
    }
}
