<?php

namespace App\Http\Controllers;

use App\Models\DeviceMaster;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class DeviceMasterController extends Controller
{
    /**
     * Display a listing of the permission.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
        $this->middleware('permission:sensor-list|sensor-create|sensor-edit', ['only' => ['index', 'store']]);
        $this->middleware('permission:sensor-create', ['only' => ['create', 'store']]);
        $this->middleware('permission:sensor-edit', ['only' => ['edit', 'update']]);
        //$this->middleware('permission:sensor-delete', ['only' => ['destroy']]);
    }
    /**
     * Display a listing of the devices.
     */
    public function index()
    {
        $devices = DeviceMaster::all();  // Fetch all devices
        return view('device_master.index', compact('devices'));
    }

    /**
     * Show the form for creating a new device.
     */
    public function create()
    {
        return view('device_master.adddevice');
    }

    /**
     * Store a newly created device in the database. 
     */
    public function store(Request $request)
    {
        // Validate the incoming request data
        $request->validate([
            'device_uid' => 'required|unique:device_masters,device_uid|max:255',
            'device_type_id' => 'required|string|max:255',
        ]);
        if ($request->device_purchased_on != "") {
            $purchase_date = date('Y-m-d', strtotime($request->device_purchased_on));
        } else {
            $purchase_date = '0000-00-00';
        }
        // Create a new device
        DeviceMaster::create([
            'device_uid' => $request->device_uid,
            'device_type_id' => $request->device_type_id,
            'device_purchased_on' => $purchase_date,
            'device_brand' => $request->device_brand,
            'device_status' => $request->device_status,
            'is_mapped' => 0,
            'is_deleted' => $request->is_deleted ?? 0,
            'created_on' => now(),
            'created_by' => auth()->id(),
        ]);
        return redirect()->route('devicedetails')->with('message', 'Device added successfully.')->with('status', 'success');
    }

    /**
     * Display the specified device.
     */
    public function show(DeviceMaster $device)
    {
        $devices = DeviceMaster::all();
        return view('device_master.devicedetails', compact('devices'));
    }

    /**
     * Show the form for editing the specified device.
     */
    public function edit($enc_id)
    {
        $id = base64_decode(base64_decode($enc_id));
        $device = DeviceMaster::find($id);
        return view('device_master.editdevice', compact('device'));
    }

    /**
     * Update the specified device in the database.
     */
    public function update(Request $request)
    {   // Validate the incoming request data
        $data = $request->all();
        $did = $request->device_id;
        if ($request->device_purchased_on != "") {
            $purchase_date = date('Y-m-d', strtotime($request->device_purchased_on));
        } else {
            $purchase_date = '0000-00-00';
        }
        $device_data = array(
            'device_uid' => $request->device_uid,
            'device_type_id' => $request->device_type_id,
            'device_purchased_on' => $purchase_date,
            'device_brand' => $request->device_brand,
            'device_status' => $request->device_status,
            'updated_at' => now(),
            'updated_by' => auth()->id(),
        );
        $update_device = DeviceMaster::where('id', '=', $did)->update($device_data);

        return redirect()->route('devicedetails')->with('message', 'Device Updated successfully.')->with('status', 'success');
    }

    /**
     * Remove the specified device from the database.
     */
    public function destroy(DeviceMaster $device)
    {
        $device->delete();

        return redirect()->route('device_master.index')->with('success', 'Device deleted successfully.');
    }
}
