<?php include 'include/header.php';?>
<div id="content" class="site-content pt-66">
   <main class="homepage homepage_new" id="homepage-content">
      <section class="banner-section mt-66 hospital-banner">
         <div class="banner-txt">
            <div class="container">
               <div class="row">
                  <div class="col-md-12">
                     <h1 class="HeadingText">Hospital Management System</h1>
                     <div class="default-breadcrumb">
                        <nav aria-label="breadcrumb">
                           <ol class="breadcrumb">
                              <li class="breadcrumb-item"><a href="#" class="changeText">Home</a></li>
                              <li class="breadcrumb-item"><a href="#" class="changeText">Products</a></li>
                              <li class="breadcrumb-item active changeText" aria-current="page">Hospital Management System</li>
                           </ol>
                        </nav>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>

      <section class="white-bg pt-80 pb-80 with-circle-bg">
         <div class="container">
            <div class="row">
               <div class="col-md-12">
                  <h2 class="default-title mb-10px text-left"><span>Hospital</span> Management System</h2>
               </div>
               <div class="col-md-5">
                  <p class="font-size-22px">Customized Software Application Service</p>
                  <div class="hospital-txt-one">
                     <h5>Features</h5>
                     <ul class="default-tick">
                        <li>In-Patient Management</li>
                        <li>O.T. Management</li>
                        <li>Out Patient Management</li>
                        <li>Diagnostic and Laboratory Management</li>
                        <li>Pharmacy with Inventory</li>
                        <li>Inventory Control System</li>
                        <li>Marketing Control System</li>
                        <li>System Security & Software Management</li>
                        <li>M.I.S. Report</li>
                        <li>Supplier Payment</li>
                        <li>GST Reporting & Easy to Excel Export</li>
                        <li>Investigation Report Upload & SMS Facilit</li>
                        <li>Tally Integration</li>
                        <li>IVF (In Vitro Fertilization) Management System</li>
                        <li>Patient Feedback Management System</li>
                     </ul>
                  </div>
               </div>
               <div class="col-md-7">
                  <img src="images/hosp-collage.png" class="full-img">
               </div>
            </div>
         </div>
      </section>

      <section class="highlights-ar pt-50 pb-50">
         <div class="container">
            <div class="row align-items-center">
               <div class="col-md-12">
                  <h2 class="default-title mb-20 text-center">All <span>Modules</span></h2>
                  <div class="all-modules-txt text-center">
                     Hospital Management Information System streamlines the treatment flow of patients and simultaneously empowers the hospital's workforce to perform their duties effectively and efficiently and also modelled on the unique combination of a 'patient centric and medical staff centric' paradigm, thus providing benefits to both the recipients and the providers of healthcare. This software is designed to assist in daily operations involved in healthcare, such as scheduling, billing and perform daily administrative tasks.
                  </div>
                  <div class="all-modules-holder">
                     <div class="row gy-4">
                        
                        <div class="col-md-4">
                           <div class="call-modules-item">
                              <a href="#" class="item-txt-over">
                                 <div class="item-text-content">In Patient Department (IPD)</div>
                                 <div class="item-arrow-content">
                                    <i class="fa fa-long-arrow-right"></i>
                                 </div>
                              </a>
                              <img src="images/all-modules-1.png">
                           </div>
                        </div>

                        <div class="col-md-4">
                           <div class="call-modules-item">
                              <a href="#" class="item-txt-over">
                                 <div class="item-text-content">Out Patient Department (OPD)</div>
                                 <div class="item-arrow-content">
                                    <i class="fa fa-long-arrow-right"></i>
                                 </div>
                              </a>
                              <img src="images/all-modules-2.png">
                           </div>
                        </div>

                        <div class="col-md-4">
                           <div class="call-modules-item">
                              <a href="#" class="item-txt-over">
                                 <div class="item-text-content">Hospital Store (Inventory)</div>
                                 <div class="item-arrow-content">
                                    <i class="fa fa-long-arrow-right"></i>
                                 </div>
                              </a>
                              <img src="images/all-modules-3.png">
                           </div>
                        </div>

                        <div class="col-md-4">
                           <div class="call-modules-item">
                              <a href="#" class="item-txt-over">
                                 <div class="item-text-content">Operation Theatre (OT) </div>
                                 <div class="item-arrow-content">
                                    <i class="fa fa-long-arrow-right"></i>
                                 </div>
                              </a>
                              <img src="images/all-modules-4.png">
                           </div>
                        </div>

                        <div class="col-md-4">
                           <div class="call-modules-item">
                              <a href="#" class="item-txt-over">
                                 <div class="item-text-content">Laboratory Management (Investigation) </div>
                                 <div class="item-arrow-content">
                                    <i class="fa fa-long-arrow-right"></i>
                                 </div>
                              </a>
                              <img src="images/all-modules-5.png">
                           </div>
                        </div>

                        <div class="col-md-4">
                           <div class="call-modules-item">
                              <a href="#" class="item-txt-over">
                                 <div class="item-text-content">Pharmacy</div>
                                 <div class="item-arrow-content">
                                    <i class="fa fa-long-arrow-right"></i>
                                 </div>
                              </a>
                              <img src="images/all-modules-6.png">
                           </div>
                        </div>

                     </div>
                  </div>
               </div>
               
            </div>
         </div>
      </section>

      <section class="start-up-section pt-5 pb-5 no-border">
         <div class="container">
            <div class="row">
               <div class="col-md-12">
                  <div class="gradient-box sm-box">Book Your FREE 30 minutes Consultation With Experts! 
                     <a href="mailto:business@maxbridgesolution.com?subject=30 minutes Consultation With Experts!" class="btn btn-white">Book Now!</a>
                  </div>
               </div>
            </div>
         </div>
      </section>

      
   </main>
</div>
<?php include 'include/footer.php';?>
<script type="text/javascript">
   $(document).ready(function () {
      //match-height
      $('.call-modules-item > .item-txt-over').matchHeight();
      $('.changeText').invertImgText('images/hospital-management-system-banner.jpg');
   });
</script>